/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.FixedColRowGroupBuilder;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;

class VariableColRowGroupBuilder
extends RowGroupBuilder {
    private List events = new LinkedList();

    VariableColRowGroupBuilder(Table table) {
        super(table);
    }

    void addTableCell(final TableCell tableCell) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.addTableCell(tableCell);
            }
        });
    }

    void startTableRow(final TableRow tableRow) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.startTableRow(tableRow);
            }
        });
    }

    void endTableRow() {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.endTableRow();
            }
        });
    }

    void endRow(final TablePart tablePart) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.endRow(tablePart);
            }
        });
    }

    void startTablePart(final TablePart tablePart) {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) {
                rowGroupBuilder.startTablePart(tablePart);
            }
        });
    }

    void endTablePart() throws ValidationException {
        this.events.add(new Event(){

            public void play(RowGroupBuilder rowGroupBuilder) throws ValidationException {
                rowGroupBuilder.endTablePart();
            }
        });
    }

    void endTable() throws ValidationException {
        FixedColRowGroupBuilder fixedColRowGroupBuilder = new FixedColRowGroupBuilder(this.table);
        Iterator iterator = this.events.iterator();
        while (iterator.hasNext()) {
            ((Event)iterator.next()).play(fixedColRowGroupBuilder);
        }
        ((RowGroupBuilder)fixedColRowGroupBuilder).endTable();
    }

    private static interface Event {
        public void play(RowGroupBuilder var1) throws ValidationException;
    }
}

