/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.traits.WritingMode;
import org.xml.sax.Locator;

public abstract class Region
extends FObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int displayAlign;
    private int overflow;
    private String regionName;
    private Numeric referenceOrientation;
    private WritingMode writingMode;
    protected final SimplePageMaster layoutMaster;

    protected Region(FONode fONode) {
        super(fONode);
        this.layoutMaster = (SimplePageMaster)fONode;
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.displayAlign = propertyList.get(87).getEnum();
        this.overflow = propertyList.get(169).getEnum();
        this.regionName = propertyList.get(199).getString();
        this.referenceOrientation = propertyList.get(197).getNumeric();
        this.writingMode = WritingMode.valueOf(propertyList.get(267).getEnum());
        if (this.regionName.equals("")) {
            this.regionName = this.getDefaultRegionName();
        } else if (this.isReserved(this.getRegionName()) && !this.getRegionName().equals(this.getDefaultRegionName())) {
            this.getFOValidationEventProducer().illegalRegionName(this, this.getName(), this.regionName, this.getLocator());
        }
        if (this.getCommonBorderPaddingBackground().getBPPaddingAndBorder(false, null) != 0 || this.getCommonBorderPaddingBackground().getIPPaddingAndBorder(false, null) != 0) {
            this.getFOValidationEventProducer().nonZeroBorderPaddingOnRegion(this, this.getName(), this.regionName, true, this.getLocator());
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public abstract Rectangle getViewportRectangle(FODimension var1);

    protected abstract String getDefaultRegionName();

    protected boolean isReserved(String string) {
        return string.equals("xsl-region-before") || string.equals("xsl-region-start") || string.equals("xsl-region-end") || string.equals("xsl-region-after") || string.equals("xsl-before-float-separator") || string.equals("xsl-footnote-separator");
    }

    protected PercentBaseContext getPageWidthContext(int n) {
        return this.layoutMaster.getPageWidthContext(n);
    }

    protected PercentBaseContext getPageHeightContext(int n) {
        return this.layoutMaster.getPageHeightContext(n);
    }

    public boolean generatesReferenceAreas() {
        return true;
    }

    protected Region getSiblingRegion(int n) {
        return this.layoutMaster.getRegion(n);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public int getReferenceOrientation() {
        return this.referenceOrientation.getValue();
    }

    public WritingMode getWritingMode() {
        return this.writingMode;
    }
}

