/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOTreeBuilderContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.destination.Destination;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.fo.pagination.Declarations;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTree;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.Locator;

public class Root
extends FObj
implements CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private int mediaUsage;
    private LayoutMasterSet layoutMasterSet;
    private Declarations declarations;
    private BookmarkTree bookmarkTree = null;
    private List<Destination> destinationList;
    private List<PageSequence> pageSequences = new ArrayList<PageSequence>();
    private Locale locale;
    private boolean pageSequenceFound = false;
    private int endingPageNumberOfPreviousSequence = 0;
    private int totalPagesGenerated = 0;
    private FOTreeBuilderContext builderContext;
    private FOEventHandler foEventHandler = null;

    public Root(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.mediaUsage = propertyList.get(161).getEnum();
        String string = propertyList.get(134).getString();
        String string2 = propertyList.get(81).getString();
        if (this.isLocalePropertySet(string)) {
            this.locale = this.isLocalePropertySet(string2) ? new Locale(string, string2) : new Locale(string);
        }
    }

    private boolean isLocalePropertySet(String string) {
        return string != null && !string.equals("none");
    }

    protected void startOfNode() throws FOPException {
        this.foEventHandler.startRoot(this);
    }

    protected void endOfNode() throws FOPException {
        if (!this.pageSequenceFound || this.layoutMasterSet == null) {
            this.missingChildElementError("(layout-master-set, declarations?, bookmark-tree?, (page-sequence|fox:external-document)+)");
        }
        this.foEventHandler.endRoot(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("layout-master-set")) {
                if (this.layoutMasterSet != null) {
                    this.tooManyNodesError(locator, "fo:layout-master-set");
                }
            } else if (string2.equals("declarations")) {
                if (this.layoutMasterSet == null) {
                    this.nodesOutOfOrderError(locator, "fo:layout-master-set", "fo:declarations");
                } else if (this.declarations != null) {
                    this.tooManyNodesError(locator, "fo:declarations");
                } else if (this.bookmarkTree != null) {
                    this.nodesOutOfOrderError(locator, "fo:declarations", "fo:bookmark-tree");
                } else if (this.pageSequenceFound) {
                    this.nodesOutOfOrderError(locator, "fo:declarations", "fo:page-sequence");
                }
            } else if (string2.equals("bookmark-tree")) {
                if (this.layoutMasterSet == null) {
                    this.nodesOutOfOrderError(locator, "fo:layout-master-set", "fo:bookmark-tree");
                } else if (this.bookmarkTree != null) {
                    this.tooManyNodesError(locator, "fo:bookmark-tree");
                } else if (this.pageSequenceFound) {
                    this.nodesOutOfOrderError(locator, "fo:bookmark-tree", "fo:page-sequence");
                }
            } else if (string2.equals("page-sequence")) {
                if (this.layoutMasterSet == null) {
                    this.nodesOutOfOrderError(locator, "fo:layout-master-set", "fo:page-sequence");
                } else {
                    this.pageSequenceFound = true;
                }
            } else {
                this.invalidChildError(locator, string, string2);
            }
        } else if ("http://xmlgraphics.apache.org/fop/extensions".equals(string) && "external-document".equals(string2)) {
            this.pageSequenceFound = true;
        }
    }

    protected void validateChildNode(Locator locator, FONode fONode) throws ValidationException {
        if (fONode instanceof AbstractPageSequence) {
            this.pageSequenceFound = true;
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public void setFOEventHandler(FOEventHandler fOEventHandler) {
        this.foEventHandler = fOEventHandler;
    }

    public FOEventHandler getFOEventHandler() {
        return this.foEventHandler;
    }

    public void setBuilderContext(FOTreeBuilderContext fOTreeBuilderContext) {
        this.builderContext = fOTreeBuilderContext;
    }

    public FOTreeBuilderContext getBuilderContext() {
        return this.builderContext;
    }

    public int getEndingPageNumberOfPreviousSequence() {
        return this.endingPageNumberOfPreviousSequence;
    }

    public int getTotalPagesGenerated() {
        return this.totalPagesGenerated;
    }

    public void notifyPageSequenceFinished(int n, int n2) throws IllegalArgumentException {
        if (n2 >= 0) {
            this.totalPagesGenerated += n2;
        } else {
            throw new IllegalArgumentException("Number of additional pages must be zero or greater.");
        }
        this.endingPageNumberOfPreviousSequence = n;
    }

    public int getPageSequenceCount() {
        return this.pageSequences.size();
    }

    public PageSequence getSucceedingPageSequence(PageSequence pageSequence) {
        int n = this.pageSequences.indexOf(pageSequence);
        if (n == -1) {
            return null;
        }
        if (n < this.pageSequences.size() - 1) {
            return this.pageSequences.get(n + 1);
        }
        return null;
    }

    public LayoutMasterSet getLayoutMasterSet() {
        return this.layoutMasterSet;
    }

    public void setLayoutMasterSet(LayoutMasterSet layoutMasterSet) {
        this.layoutMasterSet = layoutMasterSet;
    }

    public Declarations getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(Declarations declarations) {
        this.declarations = declarations;
    }

    public void setBookmarkTree(BookmarkTree bookmarkTree) {
        this.bookmarkTree = bookmarkTree;
    }

    public void addDestination(Destination destination) {
        if (this.destinationList == null) {
            this.destinationList = new ArrayList<Destination>();
        }
        this.destinationList.add(destination);
    }

    public List getDestinationList() {
        return this.destinationList;
    }

    public BookmarkTree getBookmarkTree() {
        return this.bookmarkTree;
    }

    public Root getRoot() {
        return this;
    }

    public String getLocalName() {
        return "root";
    }

    public int getNameId() {
        return 66;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

