/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;

public class IndentPropertyMaker
extends CorrespondingPropertyMaker {
    private int[] paddingCorresponding = null;
    private int[] borderWidthCorresponding = null;

    public IndentPropertyMaker(PropertyMaker propertyMaker) {
        super(propertyMaker);
    }

    public void setPaddingCorresponding(int[] nArray) {
        if (nArray == null || nArray.length != 4) {
            throw new IllegalArgumentException();
        }
        this.paddingCorresponding = nArray;
    }

    public void setBorderWidthCorresponding(int[] nArray) {
        if (nArray == null || nArray.length != 4) {
            throw new IllegalArgumentException();
        }
        this.borderWidthCorresponding = nArray;
    }

    public Property compute(PropertyList propertyList) throws PropertyException {
        if (propertyList.getFObj().getUserAgent().isBreakIndentInheritanceOnReferenceAreaBoundary()) {
            return this.computeAlternativeRuleset(propertyList);
        }
        return this.computeConforming(propertyList);
    }

    public Property computeConforming(PropertyList propertyList) throws PropertyException {
        PropertyList propertyList2 = this.getWMPropertyList(propertyList);
        if (propertyList2 == null) {
            return null;
        }
        Numeric numeric = this.getCorresponding(this.paddingCorresponding, propertyList).getNumeric();
        Numeric numeric2 = this.getCorresponding(this.borderWidthCorresponding, propertyList).getNumeric();
        int n = propertyList2.selectFromWritingMode(this.lrtb, this.rltb, this.tbrl, this.tblr);
        if (propertyList.getExplicitOrShorthand(n) == null) {
            Property property = propertyList.getExplicit(this.baseMaker.propId);
            if (property == null) {
                return null;
            }
            return property;
        }
        Numeric numeric3 = propertyList.get(n).getNumeric();
        Numeric numeric4 = FixedLength.ZERO_FIXED_LENGTH;
        if (!propertyList.getFObj().generatesReferenceAreas()) {
            numeric4 = NumericOp.addition(numeric4, propertyList.getInherited(this.baseMaker.propId).getNumeric());
        }
        numeric4 = NumericOp.addition(numeric4, numeric3);
        numeric4 = NumericOp.addition(numeric4, numeric);
        numeric4 = NumericOp.addition(numeric4, numeric2);
        return numeric4;
    }

    private boolean isInherited(PropertyList propertyList) {
        if (propertyList.getFObj().getUserAgent().isBreakIndentInheritanceOnReferenceAreaBoundary()) {
            FONode fONode = propertyList.getFObj().getParent();
            return !(fONode instanceof FObj) || !((FObj)fONode).generatesReferenceAreas();
        }
        return true;
    }

    public Property computeAlternativeRuleset(PropertyList propertyList) throws PropertyException {
        PropertyList propertyList2 = this.getWMPropertyList(propertyList);
        if (propertyList2 == null) {
            return null;
        }
        Numeric numeric = this.getCorresponding(this.paddingCorresponding, propertyList).getNumeric();
        Numeric numeric2 = this.getCorresponding(this.borderWidthCorresponding, propertyList).getNumeric();
        int n = propertyList2.selectFromWritingMode(this.lrtb, this.rltb, this.tbrl, this.tblr);
        boolean bl = false;
        for (PropertyList propertyList3 = propertyList.getParentPropertyList(); propertyList3 != null && propertyList3.getExplicit(this.baseMaker.propId) == null; propertyList3 = propertyList3.getParentPropertyList()) {
            if (propertyList3.getExplicitOrShorthand(n) == null) continue;
            bl = true;
            break;
        }
        if (propertyList.getExplicitOrShorthand(n) == null) {
            Property property = propertyList.getExplicit(this.baseMaker.propId);
            if (property == null) {
                if (this.isInherited(propertyList) || !bl) {
                    return null;
                }
                return FixedLength.ZERO_FIXED_LENGTH;
            }
            return property;
        }
        Numeric numeric3 = propertyList.get(n).getNumeric();
        Numeric numeric4 = FixedLength.ZERO_FIXED_LENGTH;
        if (this.isInherited(propertyList)) {
            numeric4 = NumericOp.addition(numeric4, propertyList.getInherited(this.baseMaker.propId).getNumeric());
        }
        numeric4 = NumericOp.addition(numeric4, numeric3);
        numeric4 = NumericOp.addition(numeric4, numeric);
        numeric4 = NumericOp.addition(numeric4, numeric2);
        return numeric4;
    }

    private Property getCorresponding(int[] nArray, PropertyList propertyList) throws PropertyException {
        PropertyList propertyList2 = this.getWMPropertyList(propertyList);
        if (propertyList2 != null) {
            int n = propertyList2.selectFromWritingMode(nArray[0], nArray[1], nArray[2], nArray[3]);
            return propertyList.get(n);
        }
        return null;
    }
}

