/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.CompareUtil;

public class LengthPairProperty
extends Property
implements CompoundDatatype {
    private Property ipd;
    private Property bpd;

    public LengthPairProperty() {
    }

    public LengthPairProperty(Property property, Property property2) {
        this();
        this.ipd = property;
        this.bpd = property2;
    }

    public LengthPairProperty(Property property) {
        this(property, property);
    }

    public void setComponent(int n, Property property, boolean bl) {
        if (n == 512) {
            this.bpd = property;
        } else if (n == 1536) {
            this.ipd = property;
        }
    }

    public Property getComponent(int n) {
        if (n == 512) {
            return this.getBPD();
        }
        if (n == 1536) {
            return this.getIPD();
        }
        return null;
    }

    public Property getIPD() {
        return this.ipd;
    }

    public Property getBPD() {
        return this.bpd;
    }

    public String toString() {
        return "LengthPair[ipd:" + this.getIPD().getObject() + ", bpd:" + this.getBPD().getObject() + "]";
    }

    public LengthPairProperty getLengthPair() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + CompareUtil.getHashCode(this.bpd);
        n = 31 * n + CompareUtil.getHashCode(this.ipd);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LengthPairProperty)) {
            return false;
        }
        LengthPairProperty lengthPairProperty = (LengthPairProperty)object;
        return CompareUtil.equal(this.bpd, lengthPairProperty.bpd) && CompareUtil.equal(this.ipd, lengthPairProperty.ipd);
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property makeNewProperty() {
            return new LengthPairProperty();
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof LengthPairProperty) {
                return property;
            }
            return super.convertProperty(property, propertyList, fObj);
        }
    }
}

