/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.SpaceProperty;

public class LineHeightPropertyMaker
extends SpaceProperty.Maker {
    public LineHeightPropertyMaker(int n) {
        super(n);
    }

    public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
        Property property = super.make(propertyList, string, fObj);
        property.getSpace().setConditionality(EnumProperty.getInstance(118, "RETAIN"), true);
        property.getSpace().setPrecedence(EnumProperty.getInstance(53, "FORCE"), true);
        return property;
    }

    protected Property compute(PropertyList propertyList) throws PropertyException {
        String string;
        Property property = propertyList.getNearestSpecified(this.propId);
        if (property != null && (string = property.getSpecifiedValue()) != null) {
            return this.make(propertyList, string, propertyList.getParentFObj());
        }
        return null;
    }

    public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
        Numeric numeric = property.getNumeric();
        if (numeric != null && numeric.getDimension() == 0) {
            Object object;
            if (this.getPercentBase(propertyList) instanceof LengthBase) {
                object = ((LengthBase)this.getPercentBase(propertyList)).getBaseLength();
                property = object != null && object.isAbsolute() ? FixedLength.getInstance(numeric.getNumericValue() * object.getNumericValue()) : new PercentLength(numeric.getNumericValue(), this.getPercentBase(propertyList));
            }
            object = super.convertProperty(property, propertyList, fObj);
            ((Property)object).setSpecifiedValue(String.valueOf(numeric.getNumericValue()));
            return object;
        }
        return super.convertProperty(property, propertyList, fObj);
    }
}

