/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumNumber;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FixedLength;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.CompareUtil;

public final class NumberProperty
extends Property
implements Numeric {
    private static final PropertyCache<NumberProperty> CACHE = new PropertyCache();
    private final Number number;

    private NumberProperty(double d) {
        this.number = d == Math.floor(d) ? (Number)(d < 2.147483647E9 ? (Number)new Integer((int)d) : (Number)new Long((long)d)) : (Number)new Double(d);
    }

    private NumberProperty(int n) {
        this.number = new Integer(n);
    }

    public static NumberProperty getInstance(Double d) {
        return CACHE.fetch(new NumberProperty(d));
    }

    public static NumberProperty getInstance(Integer n) {
        return CACHE.fetch(new NumberProperty(n));
    }

    public static NumberProperty getInstance(double d) {
        return CACHE.fetch(new NumberProperty(d));
    }

    public static NumberProperty getInstance(int n) {
        return CACHE.fetch(new NumberProperty(n));
    }

    public int getDimension() {
        return 0;
    }

    public double getNumericValue() {
        return this.number.doubleValue();
    }

    public double getNumericValue(PercentBaseContext percentBaseContext) {
        return this.getNumericValue();
    }

    public int getValue() {
        return this.number.intValue();
    }

    public int getValue(PercentBaseContext percentBaseContext) {
        return this.getValue();
    }

    public boolean isAbsolute() {
        return true;
    }

    public Number getNumber() {
        return this.number;
    }

    public Object getObject() {
        return this.number;
    }

    public Numeric getNumeric() {
        return this;
    }

    public Length getLength() {
        return FixedLength.getInstance(this.getNumericValue(), "px");
    }

    public Color getColor(FOUserAgent fOUserAgent) {
        return Color.black;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NumberProperty)) {
            return false;
        }
        NumberProperty numberProperty = (NumberProperty)object;
        return CompareUtil.equal(this.number, numberProperty.number);
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    public static class PositiveIntegerMaker
    extends PropertyMaker {
        public PositiveIntegerMaker(int n) {
            super(n);
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof EnumProperty) {
                return EnumNumber.getInstance(property);
            }
            Number number = property.getNumber();
            if (number != null) {
                int n = Math.round(number.floatValue());
                if (n <= 0) {
                    n = 1;
                }
                return NumberProperty.getInstance(n);
            }
            return this.convertPropertyDatatype(property, propertyList, fObj);
        }
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof NumberProperty) {
                return property;
            }
            if (property instanceof EnumProperty) {
                return EnumNumber.getInstance(property);
            }
            Number number = property.getNumber();
            if (number != null) {
                return NumberProperty.getInstance(number.doubleValue());
            }
            return this.convertPropertyDatatype(property, propertyList, fObj);
        }
    }
}

