/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.util.CompareUtil;

public class PercentLength
extends LengthProperty {
    private double factor;
    private PercentBase lbase;

    public PercentLength(double d, PercentBase percentBase) {
        this.factor = d;
        this.lbase = percentBase;
    }

    public PercentBase getBaseLength() {
        return this.lbase;
    }

    protected double getPercentage() {
        return this.factor * 100.0;
    }

    public boolean isAbsolute() {
        return false;
    }

    public double getNumericValue() {
        return this.getNumericValue(null);
    }

    public double getNumericValue(PercentBaseContext percentBaseContext) {
        try {
            return this.factor * (double)this.lbase.getBaseLength(percentBaseContext);
        }
        catch (PropertyException propertyException) {
            log.error((Object)propertyException);
            return 0.0;
        }
    }

    public String getString() {
        return this.factor * 100.0 + "%";
    }

    public int getValue() {
        return (int)this.getNumericValue();
    }

    public int getValue(PercentBaseContext percentBaseContext) {
        return (int)this.getNumericValue(percentBaseContext);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(PercentLength.class.getName()).append("[factor=").append(this.factor).append(",lbase=").append(this.lbase).append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + CompareUtil.getHashCode(this.factor);
        n = 31 * n + CompareUtil.getHashCode(this.lbase);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PercentLength)) {
            return false;
        }
        PercentLength percentLength = (PercentLength)object;
        return CompareUtil.equal(this.factor, percentLength.factor) && CompareUtil.equal(this.lbase, percentLength.lbase);
    }
}

