/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.CompoundDatatype;
import org.apache.fop.datatypes.LengthBase;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.expr.PropertyParser;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.ShorthandParser;

public class PropertyMaker
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(PropertyMaker.class);
    private static final boolean IS_LOG_TRACE_ENABLED = LOG.isTraceEnabled();
    protected int propId;
    private boolean inherited = true;
    private Map enums = null;
    private Map keywords = null;
    protected String defaultValue = null;
    protected boolean contextDep = false;
    protected boolean setByShorthand = false;
    private int percentBase = -1;
    private PropertyMaker[] shorthands = null;
    private ShorthandParser datatypeParser;
    protected Property defaultProperty;
    protected CorrespondingPropertyMaker corresponding;

    public int getPropId() {
        return this.propId;
    }

    public PropertyMaker(int n) {
        this.propId = n;
    }

    public void useGeneric(PropertyMaker propertyMaker) {
        this.contextDep = propertyMaker.contextDep;
        this.inherited = propertyMaker.inherited;
        this.defaultValue = propertyMaker.defaultValue;
        this.percentBase = propertyMaker.percentBase;
        if (propertyMaker.shorthands != null) {
            this.shorthands = new PropertyMaker[propertyMaker.shorthands.length];
            System.arraycopy(propertyMaker.shorthands, 0, this.shorthands, 0, this.shorthands.length);
        }
        if (propertyMaker.enums != null) {
            this.enums = new HashMap(propertyMaker.enums);
        }
        if (propertyMaker.keywords != null) {
            this.keywords = new HashMap(propertyMaker.keywords);
        }
    }

    public void setInherited(boolean bl) {
        this.inherited = bl;
    }

    public void addKeyword(String string, String string2) {
        if (this.keywords == null) {
            this.keywords = new HashMap();
        }
        this.keywords.put(string, string2);
    }

    public void addEnum(String string, Property property) {
        if (this.enums == null) {
            this.enums = new HashMap();
        }
        this.enums.put(string, property);
    }

    public void addSubpropMaker(PropertyMaker propertyMaker) {
        throw new RuntimeException("Unable to add subproperties " + this.getClass());
    }

    public PropertyMaker getSubpropMaker(int n) {
        throw new RuntimeException("Unable to add subproperties");
    }

    public void addShorthand(PropertyMaker propertyMaker) {
        if (this.shorthands == null) {
            this.shorthands = new PropertyMaker[3];
        }
        for (int i = 0; i < this.shorthands.length; ++i) {
            if (this.shorthands[i] != null) continue;
            this.shorthands[i] = propertyMaker;
            break;
        }
    }

    public void setDatatypeParser(ShorthandParser shorthandParser) {
        this.datatypeParser = shorthandParser;
    }

    public void setDefault(String string) {
        this.defaultValue = string;
    }

    public void setDefault(String string, boolean bl) {
        this.defaultValue = string;
        this.contextDep = bl;
    }

    public void setPercentBase(int n) {
        this.percentBase = n;
    }

    public void setByShorthand(boolean bl) {
        this.setByShorthand = bl;
    }

    public void setCorresponding(CorrespondingPropertyMaker correspondingPropertyMaker) {
        this.corresponding = correspondingPropertyMaker;
    }

    public Property makeNewProperty() {
        return null;
    }

    public Property findProperty(PropertyList propertyList, boolean bl) throws PropertyException {
        PropertyList propertyList2;
        Property property = null;
        if (IS_LOG_TRACE_ENABLED) {
            LOG.trace((Object)("PropertyMaker.findProperty: " + FOPropertyMapping.getPropertyName(this.propId) + ", " + propertyList.getFObj().getName()));
        }
        if (this.corresponding != null && this.corresponding.isCorrespondingForced(propertyList)) {
            property = this.corresponding.compute(propertyList);
        } else {
            property = propertyList.getExplicit(this.propId);
            if (property == null) {
                property = this.getShorthand(propertyList);
            }
            if (property == null) {
                property = this.compute(propertyList);
            }
        }
        if (property == null && bl && (propertyList2 = propertyList.getParentPropertyList()) != null && this.isInherited()) {
            property = propertyList2.get(this.propId, true, false);
        }
        return property;
    }

    public Property get(int n, PropertyList propertyList, boolean bl, boolean bl2) throws PropertyException {
        Property property = this.findProperty(propertyList, bl);
        if (property == null && bl2) {
            property = this.make(propertyList);
        }
        return property;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public PercentBase getPercentBase(PropertyList propertyList) throws PropertyException {
        if (this.percentBase == -1) {
            return null;
        }
        return new LengthBase(propertyList, this.percentBase);
    }

    public Property getSubprop(Property property, int n) {
        CompoundDatatype compoundDatatype = (CompoundDatatype)property.getObject();
        return compoundDatatype.getComponent(n);
    }

    protected Property setSubprop(Property property, int n, Property property2) {
        CompoundDatatype compoundDatatype = (CompoundDatatype)property.getObject();
        compoundDatatype.setComponent(n, property2, false);
        return property;
    }

    public Property make(PropertyList propertyList) throws PropertyException {
        if (this.defaultProperty != null) {
            if (IS_LOG_TRACE_ENABLED) {
                LOG.trace((Object)("PropertyMaker.make: reusing defaultProperty, " + FOPropertyMapping.getPropertyName(this.propId)));
            }
            return this.defaultProperty;
        }
        if (IS_LOG_TRACE_ENABLED) {
            LOG.trace((Object)("PropertyMaker.make: making default property value, " + FOPropertyMapping.getPropertyName(this.propId) + ", " + propertyList.getFObj().getName()));
        }
        Property property = this.make(propertyList, this.defaultValue, propertyList.getParentFObj());
        if (!this.contextDep) {
            this.defaultProperty = property;
        }
        return property;
    }

    public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
        try {
            Property property = null;
            String string2 = string;
            if ("inherit".equals(string)) {
                Property property2;
                property = propertyList.getFromParent(this.propId & 0x1FF);
                if ((this.propId & 0xFFFFFE00) != 0) {
                    property = this.getSubprop(property, this.propId & 0xFFFFFE00);
                }
                if (!this.isInherited() && LOG.isWarnEnabled() && (property2 = propertyList.getParentPropertyList().getExplicit(this.getPropId())) == null) {
                    LOG.warn((Object)(FOPropertyMapping.getPropertyName(this.getPropId()) + "=\"inherit\" on " + propertyList.getFObj().getName() + ", but no explicit value found on the parent FO."));
                }
            } else {
                string2 = this.checkValueKeywords(string2.trim());
                property = this.checkEnumValues(string2);
            }
            if (property == null) {
                property = PropertyParser.parse(string2, new PropertyInfo(this, propertyList));
            }
            if (property != null) {
                property = this.convertProperty(property, propertyList, fObj);
            }
            if (property == null) {
                throw new PropertyException("No conversion defined " + string2);
            }
            return property;
        }
        catch (PropertyException propertyException) {
            if (fObj != null) {
                propertyException.setLocator(fObj.getLocator());
            }
            propertyException.setPropertyName(this.getName());
            throw propertyException;
        }
    }

    public Property make(Property property, int n, PropertyList propertyList, String string, FObj fObj) throws PropertyException {
        return property;
    }

    public Property convertShorthandProperty(PropertyList propertyList, Property property, FObj fObj) throws PropertyException {
        String string;
        String string2;
        Property property2 = this.convertProperty(property, propertyList, fObj);
        if (property2 == null && (string2 = property.getNCname()) != null && (property2 = this.checkEnumValues(string2)) == null && !(string = this.checkValueKeywords(string2)).equals(string2)) {
            Property property3 = PropertyParser.parse(string, new PropertyInfo(this, propertyList));
            property2 = this.convertProperty(property3, propertyList, fObj);
        }
        if (property2 != null) {
            // empty if block
        }
        return property2;
    }

    protected Property checkEnumValues(String string) {
        if (this.enums != null) {
            Property property = (Property)this.enums.get(string);
            return property;
        }
        return null;
    }

    protected String checkValueKeywords(String string) {
        String string2;
        if (this.keywords != null && (string2 = (String)this.keywords.get(string)) != null) {
            return string2;
        }
        return string;
    }

    protected Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
        return null;
    }

    protected Property convertPropertyDatatype(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
        return null;
    }

    protected Property compute(PropertyList propertyList) throws PropertyException {
        if (this.corresponding != null) {
            return this.corresponding.compute(propertyList);
        }
        return null;
    }

    public Property getShorthand(PropertyList propertyList) throws PropertyException {
        if (this.shorthands == null) {
            return null;
        }
        int n = this.shorthands.length;
        for (int i = 0; i < n && this.shorthands[i] != null; ++i) {
            ShorthandParser shorthandParser;
            Property property;
            PropertyMaker propertyMaker = this.shorthands[i];
            Property property2 = propertyList.getExplicit(propertyMaker.propId);
            if (property2 == null || (property = (shorthandParser = propertyMaker.datatypeParser).getValueForProperty(this.getPropId(), property2, this, propertyList)) == null) continue;
            return property;
        }
        return null;
    }

    public String getName() {
        return FOPropertyMapping.getPropertyName(this.propId);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

