/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CompoundPropertyMaker;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.util.CompareUtil;

public class SpaceProperty
extends LengthRangeProperty {
    private Property precedence;
    private Property conditionality;

    public void setComponent(int n, Property property, boolean bl) {
        if (n == 4096) {
            this.setPrecedence(property, bl);
        } else if (n == 1024) {
            this.setConditionality(property, bl);
        } else {
            super.setComponent(n, property, bl);
        }
    }

    public Property getComponent(int n) {
        if (n == 4096) {
            return this.getPrecedence();
        }
        if (n == 1024) {
            return this.getConditionality();
        }
        return super.getComponent(n);
    }

    protected void setPrecedence(Property property, boolean bl) {
        this.precedence = property;
    }

    protected void setConditionality(Property property, boolean bl) {
        this.conditionality = property;
    }

    public Property getPrecedence() {
        return this.precedence;
    }

    public Property getConditionality() {
        return this.conditionality;
    }

    public boolean isDiscard() {
        return this.conditionality.getEnum() == 32;
    }

    public String toString() {
        return "Space[min:" + this.getMinimum(null).getObject() + ", max:" + this.getMaximum(null).getObject() + ", opt:" + this.getOptimum(null).getObject() + ", precedence:" + this.precedence.getObject() + ", conditionality:" + this.conditionality.getObject() + "]";
    }

    public SpaceProperty getSpace() {
        return this;
    }

    public LengthRangeProperty getLengthRange() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + CompareUtil.getHashCode(this.precedence);
        n = 31 * n + CompareUtil.getHashCode(this.conditionality);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpaceProperty)) {
            return false;
        }
        SpaceProperty spaceProperty = (SpaceProperty)object;
        return super.equals(object) && CompareUtil.equal(this.precedence, spaceProperty.precedence) && CompareUtil.equal(this.conditionality, spaceProperty.conditionality);
    }

    public static class Maker
    extends CompoundPropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property makeNewProperty() {
            return new SpaceProperty();
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof SpaceProperty) {
                return property;
            }
            return super.convertProperty(property, propertyList, fObj);
        }
    }
}

