/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.CompareUtil;

public class URIProperty
extends Property {
    private URI resolvedURI;

    protected URIProperty(URI uRI) {
        this.resolvedURI = uRI;
    }

    private URIProperty(String string, boolean bl) {
        if (bl && string != null && !"".equals(string)) {
            this.resolvedURI = URI.create(string);
        } else {
            this.setSpecifiedValue(string);
        }
    }

    public String getString() {
        if (this.resolvedURI == null) {
            return this.getSpecifiedValue();
        }
        return this.resolvedURI.toString();
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + CompareUtil.getHashCode(this.getSpecifiedValue());
        n = 31 * n + CompareUtil.getHashCode(this.resolvedURI);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof URIProperty)) {
            return false;
        }
        URIProperty uRIProperty = (URIProperty)object;
        return CompareUtil.equal(this.getSpecifiedValue(), uRIProperty.getSpecifiedValue()) && CompareUtil.equal(this.resolvedURI, uRIProperty.resolvedURI);
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
            URIProperty uRIProperty = null;
            if (string.matches("(?s)^(url\\(('|\")?)?data:.*$")) {
                uRIProperty = new URIProperty(string, false);
            } else {
                try {
                    URI uRI = new URI(URISpecification.escapeURI(string));
                    URIProperty uRIProperty2 = (URIProperty)propertyList.get(275, true, false);
                    if (uRIProperty2 == null) {
                        if (this.propId == 275) {
                            uRIProperty = new URIProperty(uRI);
                            uRIProperty.setSpecifiedValue(string);
                        } else {
                            uRIProperty = new URIProperty(string, false);
                        }
                    } else {
                        uRIProperty = new URIProperty(uRIProperty2.resolvedURI.resolve(uRI));
                        uRIProperty.setSpecifiedValue(string);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new PropertyException("Invalid URI specified");
                }
            }
            return uRIProperty;
        }
    }
}

