/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Arrays;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.xmlgraphics.fonts.Glyphs;

public class AbstractCodePointMapping
implements SingleByteEncoding {
    private final String name;
    private char[] latin1Map;
    private char[] characters;
    private char[] codepoints;
    private char[] unicodeMap;
    private String[] charNameMap;

    public AbstractCodePointMapping(String string, int[] nArray) {
        this(string, nArray, null);
    }

    public AbstractCodePointMapping(String string, int[] nArray, String[] stringArray) {
        this.name = string;
        this.buildFromTable(nArray);
        if (stringArray != null) {
            this.charNameMap = new String[256];
            for (int i = 0; i < 256; ++i) {
                String string2 = stringArray[i];
                this.charNameMap[i] = string2 == null ? ".notdef" : string2;
            }
        }
    }

    protected void buildFromTable(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        this.latin1Map = new char[256];
        this.unicodeMap = new char[256];
        Arrays.fill(this.unicodeMap, '\uffff');
        for (n2 = 0; n2 < nArray.length; n2 += 2) {
            n = nArray[n2 + 1];
            if (n < 256) {
                if (this.latin1Map[n] == '\u0000') {
                    this.latin1Map[n] = (char)nArray[n2];
                }
            } else {
                ++n3;
            }
            if (this.unicodeMap[nArray[n2]] != '\uffff') continue;
            this.unicodeMap[nArray[n2]] = n;
        }
        this.characters = new char[n3];
        this.codepoints = new char[n3];
        n2 = 0;
        block1: for (n = 0; n < nArray.length; n += 2) {
            char c = (char)nArray[n + '\u0001'];
            if (c < '\u0100') continue;
            for (int i = ++n2 - 1; i >= 0; --i) {
                if (i <= 0 || this.characters[i - 1] < c) {
                    this.characters[i] = c;
                    this.codepoints[i] = (char)nArray[n];
                    continue block1;
                }
                this.characters[i] = this.characters[i - 1];
                this.codepoints[i] = this.codepoints[i - 1];
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public final char mapChar(char c) {
        int n;
        if (c < '\u0100' && (n = this.latin1Map[c]) > 0) {
            return (char)n;
        }
        n = 0;
        int n2 = this.characters.length - 1;
        while (n2 >= n) {
            int n3 = (n + n2) / 2;
            char c2 = this.characters[n3];
            if (c == c2) {
                return this.codepoints[n3];
            }
            if (c < c2) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return '\u0000';
    }

    public final char getUnicodeForIndex(int n) {
        return this.unicodeMap[n];
    }

    public final char[] getUnicodeCharMap() {
        char[] cArray = new char[this.unicodeMap.length];
        System.arraycopy(this.unicodeMap, 0, cArray, 0, this.unicodeMap.length);
        return cArray;
    }

    public short getCodePointForGlyph(String string) {
        String[] stringArray = this.charNameMap;
        if (stringArray == null) {
            stringArray = this.getCharNameMap();
        }
        short s = (short)stringArray.length;
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            if (!stringArray[s2].equals(string)) continue;
            return s2;
        }
        return -1;
    }

    public String[] getCharNameMap() {
        if (this.charNameMap != null) {
            String[] stringArray = new String[this.charNameMap.length];
            System.arraycopy(this.charNameMap, 0, stringArray, 0, this.charNameMap.length);
            return stringArray;
        }
        Object[] objectArray = new String[256];
        Arrays.fill(objectArray, ".notdef");
        for (int i = 0; i < 256; ++i) {
            String string;
            char c = this.getUnicodeForIndex(i);
            if (c == '\uffff' || (string = Glyphs.charToGlyphName((char)c)).length() <= 0) continue;
            objectArray[i] = string;
        }
        return objectArray;
    }

    public String toString() {
        return this.getName();
    }
}

