/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.Typeface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Substitutable,
Positionable {
    public static final int WEIGHT_EXTRA_BOLD = 800;
    public static final int WEIGHT_BOLD = 700;
    public static final int WEIGHT_NORMAL = 400;
    public static final int WEIGHT_LIGHT = 200;
    public static final String STYLE_NORMAL = "normal";
    public static final String STYLE_ITALIC = "italic";
    public static final String STYLE_OBLIQUE = "oblique";
    public static final String STYLE_INCLINED = "inclined";
    public static final int PRIORITY_DEFAULT = 0;
    public static final FontTriplet DEFAULT_FONT = new FontTriplet("any", "normal", 400, 0);
    private static Log log = LogFactory.getLog(Font.class);
    private final String fontName;
    private final FontTriplet triplet;
    private final int fontSize;
    private final FontMetrics metric;

    public Font(String string, FontTriplet fontTriplet, FontMetrics fontMetrics, int n) {
        this.fontName = string;
        this.triplet = fontTriplet;
        this.metric = fontMetrics;
        this.fontSize = n;
    }

    public FontMetrics getFontMetrics() {
        return this.metric;
    }

    public int getAscender() {
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontName() {
        return this.fontName;
    }

    public FontTriplet getFontTriplet() {
        return this.triplet;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public boolean hasKerning() {
        return this.metric.hasKerningInfo();
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        if (this.metric.hasKerningInfo()) {
            return this.metric.getKerningInfo();
        }
        return Collections.emptyMap();
    }

    public int getKernValue(char c, char c2) {
        Integer n;
        Map<Integer, Integer> map = this.getKerning().get(c);
        if (map != null && (n = map.get(c2)) != null) {
            return n * this.getFontSize() / 1000;
        }
        return 0;
    }

    public int getKernValue(int n, int n2) {
        if (n > 65536) {
            return 0;
        }
        if (n >= 55296 && n <= 57344) {
            return 0;
        }
        if (n2 > 65536) {
            return 0;
        }
        if (n2 >= 55296 && n2 <= 57344) {
            return 0;
        }
        return this.getKernValue((char)n, (char)n2);
    }

    public int getWidth(int n) {
        return this.metric.getWidth(n, this.fontSize) / 1000;
    }

    public char mapChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).mapChar(c);
        }
        char c2 = CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c);
        if (c2 != '\u0000') {
            c = c2;
        } else {
            log.warn((Object)("Glyph " + c + " not available in font " + this.fontName));
            c = (char)35;
        }
        return c;
    }

    public boolean hasChar(char c) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).hasChar(c);
        }
        return CodePointMapping.getMapping("WinAnsiEncoding").mapChar(c) > '\u0000';
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('{');
        stringBuffer.append(this.fontName);
        stringBuffer.append(',');
        stringBuffer.append(this.fontSize);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int getCharWidth(char c) {
        int n;
        if (c == '\n' || c == '\r' || c == '\t' || c == '\u00a0') {
            n = this.getCharWidth(' ');
        } else {
            int n2;
            if (this.hasChar(c)) {
                n2 = this.mapChar(c);
                n = this.getWidth(n2);
            } else {
                n = -1;
            }
            if (n <= 0) {
                n2 = this.getFontSize();
                int n3 = n2 / 2;
                n = c == ' ' ? n2 : (c == '\u2000' ? n3 : (c == '\u2001' ? n2 : (c == '\u2002' ? n2 / 2 : (c == '\u2003' ? this.getFontSize() : (c == '\u2004' ? n2 / 3 : (c == '\u2005' ? n2 / 4 : (c == '\u2006' ? n2 / 6 : (c == '\u2007' ? this.getCharWidth('0') : (c == '\u2008' ? this.getCharWidth('.') : (c == '\u2009' ? n2 / 5 : (c == '\u200a' ? n2 / 10 : (c == '\u200b' ? 0 : (c == '\u202f' ? this.getCharWidth(' ') / 2 : (c == '\u2060' ? 0 : (c == '\u3000' ? this.getCharWidth(' ') * 2 : (c == '\ufeff' ? 0 : this.getWidth(this.mapChar(c))))))))))))))))));
            }
        }
        return n;
    }

    public int getCharWidth(int n) {
        if (n < 65536) {
            return this.getCharWidth((char)n);
        }
        return -1;
    }

    public int getWordWidth(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            n2 += this.getCharWidth(cArray[i]);
        }
        return n2;
    }

    @Override
    public boolean performsSubstitution() {
        if (this.metric instanceof Substitutable) {
            Substitutable substitutable = (Substitutable)((Object)this.metric);
            return substitutable.performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence charSequence, String string, String string2) {
        if (this.metric instanceof Substitutable) {
            Substitutable substitutable = (Substitutable)((Object)this.metric);
            return substitutable.performSubstitution(charSequence, string, string2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence charSequence, int[][] nArray, String string, String string2) {
        if (this.metric instanceof Substitutable) {
            Substitutable substitutable = (Substitutable)((Object)this.metric);
            return substitutable.reorderCombiningMarks(charSequence, nArray, string, string2);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean performsPositioning() {
        if (this.metric instanceof Positionable) {
            Positionable positionable = (Positionable)((Object)this.metric);
            return positionable.performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence charSequence, String string, String string2, int n) {
        if (this.metric instanceof Positionable) {
            Positionable positionable = (Positionable)((Object)this.metric);
            return positionable.performPositioning(charSequence, string, string2, n);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] performPositioning(CharSequence charSequence, String string, String string2) {
        return this.performPositioning(charSequence, string, string2, this.fontSize);
    }
}

