/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FontCache
implements Serializable {
    private static final long serialVersionUID = 605232520271754719L;
    private static Log log = LogFactory.getLog(FontCache.class);
    private static final String FOP_USER_DIR = ".fop";
    private static final String DEFAULT_CACHE_FILENAME = "fop-fonts.cache";
    private transient boolean changed = false;
    private final boolean[] changeLock = new boolean[1];
    private Map<String, CachedFontFile> fontfileMap = null;
    private Map<String, Long> failedFontMap = null;

    private static File getUserHome() {
        return FontCache.toDirectory(System.getProperty("user.home"));
    }

    private static File getTempDirectory() {
        return FontCache.toDirectory(System.getProperty("java.io.tmpdir"));
    }

    private static File toDirectory(String string) {
        File file;
        if (string != null && (file = new File(string)).exists()) {
            return file;
        }
        return null;
    }

    public static File getDefaultCacheFile(boolean bl) {
        File file = FontCache.getUserHome();
        if (file != null) {
            File file2 = new File(file, FOP_USER_DIR);
            if (bl) {
                boolean bl2 = file2.canWrite();
                if (!file2.exists()) {
                    bl2 = file2.mkdir();
                }
                if (!bl2) {
                    file = FontCache.getTempDirectory();
                    file2 = new File(file, FOP_USER_DIR);
                    file2.mkdir();
                }
            }
            return new File(file2, DEFAULT_CACHE_FILENAME);
        }
        return new File(FOP_USER_DIR);
    }

    public static FontCache load() {
        return FontCache.loadFrom(FontCache.getDefaultCacheFile(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontCache loadFrom(File file) {
        block10: {
            if (file.exists()) {
                FontCache fontCache;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading font cache from " + file.getCanonicalPath()));
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
                try {
                    fontCache = (FontCache)objectInputStream.readObject();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly((InputStream)objectInputStream);
                        throw throwable;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        log.warn((Object)("Could not read font cache. Discarding font cache file. Reason: " + classNotFoundException.getMessage()));
                        break block10;
                    }
                    catch (IOException iOException) {
                        log.warn((Object)("I/O exception while reading font cache (" + iOException.getMessage() + "). Discarding font cache file."));
                        try {
                            file.delete();
                        }
                        catch (SecurityException securityException) {
                            log.warn((Object)("Failed to delete font cache file: " + file.getAbsolutePath()));
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)objectInputStream);
                return fontCache;
            }
        }
        return null;
    }

    public void save() throws FOPException {
        this.saveTo(FontCache.getDefaultCacheFile(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File file) throws FOPException {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.changed) {
                try {
                    log.trace((Object)("Writing font cache to " + file.getCanonicalPath()));
                    OutputStream outputStream = new FileOutputStream(file);
                    outputStream = new BufferedOutputStream(outputStream);
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
                    try {
                        objectOutputStream.writeObject(this);
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)objectOutputStream);
                    }
                }
                catch (IOException iOException) {
                    LogUtil.handleException(log, iOException, true);
                }
                this.changed = false;
                log.trace((Object)"Cache file written.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static String getCacheKey(EmbedFontInfo embedFontInfo) {
        if (embedFontInfo != null) {
            String string = embedFontInfo.getEmbedFile();
            String string2 = embedFontInfo.getMetricsFile();
            return string != null ? string : string2;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean containsFont(String string) {
        return string != null && this.getFontFileMap().containsKey(string);
    }

    public boolean containsFont(EmbedFontInfo embedFontInfo) {
        return embedFontInfo != null && this.getFontFileMap().containsKey(FontCache.getCacheKey(embedFontInfo));
    }

    public static File getFileFromUrls(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            File file = null;
            if (string.startsWith("file:")) {
                try {
                    URL uRL = new URL(string);
                    file = FileUtils.toFile((URL)uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (file == null) {
                file = new File(string);
            }
            if (!file.exists() || !file.canRead()) continue;
            return file;
        }
        return null;
    }

    private Map<String, CachedFontFile> getFontFileMap() {
        if (this.fontfileMap == null) {
            this.fontfileMap = new HashMap<String, CachedFontFile>();
        }
        return this.fontfileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFont(EmbedFontInfo embedFontInfo) {
        String string = FontCache.getCacheKey(embedFontInfo);
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.containsFont(string)) {
                CachedFontFile cachedFontFile = this.getFontFileMap().get(string);
                if (!cachedFontFile.containsFont(embedFontInfo)) {
                    cachedFontFile.put(embedFontInfo);
                }
            } else {
                File file = FontCache.getFileFromUrls(new String[]{embedFontInfo.getEmbedFile(), embedFontInfo.getMetricsFile()});
                long l = file != null ? file.lastModified() : -1L;
                CachedFontFile cachedFontFile = new CachedFontFile(l);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Font added to cache: " + string));
                }
                cachedFontFile.put(embedFontInfo);
                this.getFontFileMap().put(string, cachedFontFile);
                this.changed = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public CachedFontFile getFontFile(String string) {
        return this.containsFont(string) ? this.getFontFileMap().get(string) : null;
    }

    public EmbedFontInfo[] getFontInfos(String string, long l) {
        CachedFontFile cachedFontFile = this.getFontFile(string);
        if (cachedFontFile.lastModified() == l) {
            return cachedFontFile.getEmbedFontInfos();
        }
        this.removeFont(string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFont(String string) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.containsFont(string)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Font removed from cache: " + string));
                }
                this.getFontFileMap().remove(string);
                this.changed = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailedFont(String string, long l) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (this.getFailedFontMap().containsKey(string)) {
                long l2 = this.getFailedFontMap().get(string);
                if (l != l2) {
                    this.getFailedFontMap().remove(string);
                    this.changed = true;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailedFont(String string, long l) {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (!this.getFailedFontMap().containsKey(string)) {
                this.getFailedFontMap().put(string, new Long(l));
                this.changed = true;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private Map<String, Long> getFailedFontMap() {
        if (this.failedFontMap == null) {
            this.failedFontMap = new HashMap<String, Long>();
        }
        return this.failedFontMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean[] blArray = this.changeLock;
        synchronized (this.changeLock) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Font cache cleared.");
            }
            this.fontfileMap = null;
            this.failedFontMap = null;
            this.changed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL uRL) {
        long l;
        URLConnection uRLConnection = uRL.openConnection();
        try {
            l = uRLConnection.getLastModified();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)uRLConnection.getInputStream());
                throw throwable;
            }
            catch (IOException iOException) {
                log.debug((Object)("IOError: " + iOException.getMessage()));
                return 0L;
            }
        }
        IOUtils.closeQuietly((InputStream)uRLConnection.getInputStream());
        return l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedFontFile
    implements Serializable {
        private static final long serialVersionUID = 4524237324330578883L;
        private long lastModified = -1L;
        private Map<String, EmbedFontInfo> filefontsMap = null;

        public CachedFontFile(long l) {
            this.setLastModified(l);
        }

        private Map<String, EmbedFontInfo> getFileFontsMap() {
            if (this.filefontsMap == null) {
                this.filefontsMap = new HashMap<String, EmbedFontInfo>();
            }
            return this.filefontsMap;
        }

        void put(EmbedFontInfo embedFontInfo) {
            this.getFileFontsMap().put(embedFontInfo.getPostScriptName(), embedFontInfo);
        }

        public boolean containsFont(EmbedFontInfo embedFontInfo) {
            return embedFontInfo.getPostScriptName() != null && this.getFileFontsMap().containsKey(embedFontInfo.getPostScriptName());
        }

        public EmbedFontInfo[] getEmbedFontInfos() {
            return this.getFileFontsMap().values().toArray(new EmbedFontInfo[this.getFileFontsMap().size()]);
        }

        public long lastModified() {
            return this.lastModified;
        }

        public void setLastModified(long l) {
            this.lastModified = l;
        }

        public String toString() {
            return super.toString() + ", lastModified=" + this.lastModified;
        }
    }
}

