/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontDetector;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.fonts.autodetect.FontInfoFinder;
import org.apache.fop.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontInfoConfigurator {
    protected static final Log log = LogFactory.getLog(FontInfoConfigurator.class);
    private final Configuration cfg;
    private final FontManager fontManager;
    private final FontResolver fontResolver;
    private final FontEventListener listener;
    private final boolean strict;

    public FontInfoConfigurator(Configuration configuration, FontManager fontManager, FontResolver fontResolver, FontEventListener fontEventListener, boolean bl) {
        this.cfg = configuration;
        this.fontManager = fontManager;
        this.fontResolver = fontResolver;
        this.listener = fontEventListener;
        this.strict = bl;
    }

    public void configure(List<EmbedFontInfo> list) throws FOPException {
        Configuration configuration = this.cfg.getChild("fonts", false);
        if (configuration != null) {
            FontDetector fontDetector;
            boolean bl;
            long l = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting font configuration...");
                l = System.currentTimeMillis();
            }
            FontAdder fontAdder = new FontAdder(this.fontManager, this.fontResolver, this.listener);
            boolean bl2 = bl = configuration.getChild("auto-detect", false) != null;
            if (bl) {
                fontDetector = new FontDetector(this.fontManager, fontAdder, this.strict, this.listener);
                fontDetector.detect(list);
            }
            this.addDirectories(configuration, fontAdder, list);
            this.addFonts(configuration, this.fontManager.getFontCache(), list);
            this.fontManager.updateReferencedFonts(list);
            fontDetector = configuration.getChild("referenced-fonts", false);
            if (fontDetector != null) {
                FontTriplet.Matcher matcher = FontManagerConfigurator.createFontsMatcher((Configuration)fontDetector, this.strict);
                this.fontManager.updateReferencedFonts(list, matcher);
            }
            this.fontManager.saveCache();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished font configuration in " + (System.currentTimeMillis() - l) + "ms"));
            }
        }
    }

    private void addDirectories(Configuration configuration, FontAdder fontAdder, List<EmbedFontInfo> list) throws FOPException {
        Configuration[] configurationArray = configuration.getChildren("directory");
        for (int i = 0; i < configurationArray.length; ++i) {
            boolean bl = configurationArray[i].getAttributeAsBoolean("recursive", false);
            String string = null;
            try {
                string = configurationArray[i].getValue();
            }
            catch (ConfigurationException configurationException) {
                LogUtil.handleException(log, (Exception)((Object)configurationException), this.strict);
                continue;
            }
            if (string == null) {
                LogUtil.handleException(log, new FOPException("directory defined without value"), this.strict);
                continue;
            }
            FontFileFinder fontFileFinder = new FontFileFinder(bl ? -1 : 1, this.listener);
            try {
                List<URL> list2 = fontFileFinder.find(string);
                fontAdder.add(list2, list);
                continue;
            }
            catch (IOException iOException) {
                LogUtil.handleException(log, iOException, this.strict);
            }
        }
    }

    protected void addFonts(Configuration configuration, FontCache fontCache, List<EmbedFontInfo> list) throws FOPException {
        Configuration[] configurationArray = configuration.getChildren("font");
        for (int i = 0; i < configurationArray.length; ++i) {
            EmbedFontInfo embedFontInfo = this.getFontInfo(configurationArray[i], fontCache);
            if (embedFontInfo == null) continue;
            list.add(embedFontInfo);
        }
    }

    private static void closeSource(Source source) {
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            IOUtils.closeQuietly((InputStream)streamSource.getInputStream());
            IOUtils.closeQuietly((Reader)streamSource.getReader());
        }
    }

    protected EmbedFontInfo getFontInfo(Configuration configuration, FontCache fontCache) throws FOPException {
        boolean bl;
        Object object;
        String string = configuration.getAttribute("metrics-url", null);
        String string2 = configuration.getAttribute("embed-url", null);
        String string3 = configuration.getAttribute("sub-font", null);
        if (string == null && string2 == null) {
            LogUtil.handleError(log, "Font configuration without metric-url or embed-url attribute", this.strict);
            return null;
        }
        if (this.strict) {
            if (string2 != null) {
                object = this.fontResolver.resolve(string2);
                FontInfoConfigurator.closeSource((Source)object);
                if (object == null) {
                    LogUtil.handleError(log, "Failed to resolve font with embed-url '" + string2 + "'", this.strict);
                    return null;
                }
            }
            if (string != null) {
                object = this.fontResolver.resolve(string);
                FontInfoConfigurator.closeSource((Source)object);
                if (object == null) {
                    LogUtil.handleError(log, "Failed to resolve font with metric-url '" + string + "'", this.strict);
                    return null;
                }
            }
        }
        if (((Configuration[])(object = configuration.getChildren("font-triplet"))).length == 0) {
            LogUtil.handleError(log, "font without font-triplet", this.strict);
            File file = FontCache.getFileFromUrls(new String[]{string2, string});
            URL uRL = null;
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                LogUtil.handleException(log, malformedURLException, this.strict);
            }
            if (file != null) {
                FontInfoFinder fontInfoFinder = new FontInfoFinder();
                fontInfoFinder.setEventListener(this.listener);
                EmbedFontInfo[] embedFontInfoArray = fontInfoFinder.find(uRL, this.fontResolver, fontCache);
                return embedFontInfoArray[0];
            }
            return null;
        }
        ArrayList<FontTriplet> arrayList = new ArrayList<FontTriplet>();
        for (bl = false; bl < ((Configuration[])object).length; bl += 1) {
            FontTriplet fontTriplet = this.getFontTriplet(object[bl]);
            arrayList.add(fontTriplet);
        }
        bl = configuration.getAttributeAsBoolean("kerning", true);
        boolean bl2 = configuration.getAttributeAsBoolean("advanced", true);
        EncodingMode encodingMode = EncodingMode.getValue(configuration.getAttribute("encoding-mode", EncodingMode.AUTO.getName()));
        EmbeddingMode embeddingMode = EmbeddingMode.getValue(configuration.getAttribute("embedding-mode", EmbeddingMode.AUTO.toString()));
        EmbedFontInfo embedFontInfo = new EmbedFontInfo(string, bl, bl2, arrayList, string2, string3);
        embedFontInfo.setEncodingMode(encodingMode);
        embedFontInfo.setEmbeddingMode(embeddingMode);
        boolean bl3 = false;
        if (fontCache != null) {
            if (!fontCache.containsFont(embedFontInfo)) {
                fontCache.addFont(embedFontInfo);
            } else {
                bl3 = true;
            }
        }
        if (log.isDebugEnabled()) {
            String string4 = embedFontInfo.getEmbedFile();
            log.debug((Object)((bl3 ? "Skipping (cached) font " : "Adding font ") + (string4 != null ? string4 + ", " : "") + "metric file " + embedFontInfo.getMetricsFile()));
            for (int i = 0; i < arrayList.size(); ++i) {
                FontTriplet fontTriplet = (FontTriplet)arrayList.get(i);
                log.debug((Object)("  Font triplet " + fontTriplet.getName() + ", " + fontTriplet.getStyle() + ", " + fontTriplet.getWeight()));
            }
        }
        return embedFontInfo;
    }

    private FontTriplet getFontTriplet(Configuration configuration) throws FOPException {
        try {
            String string = configuration.getAttribute("name");
            if (string == null) {
                LogUtil.handleError(log, "font-triplet without name", this.strict);
                return null;
            }
            String string2 = configuration.getAttribute("weight");
            if (string2 == null) {
                LogUtil.handleError(log, "font-triplet without weight", this.strict);
                return null;
            }
            int n = FontUtil.parseCSS2FontWeight(FontUtil.stripWhiteSpace(string2));
            String string3 = configuration.getAttribute("style");
            if (string3 == null) {
                LogUtil.handleError(log, "font-triplet without style", this.strict);
                return null;
            }
            string3 = FontUtil.stripWhiteSpace(string3);
            return FontInfo.createFontKey(string, string3, n);
        }
        catch (ConfigurationException configurationException) {
            LogUtil.handleException(log, (Exception)((Object)configurationException), this.strict);
            return null;
        }
    }
}

