/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;

public final class FontSelector {
    private FontSelector() {
    }

    private static Font selectFontForCharacter(char c, FONode fONode, CommonFont commonFont, PercentBaseContext percentBaseContext) {
        FontInfo fontInfo = fONode.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = commonFont.getFontState(fontInfo);
        for (int i = 0; i < fontTripletArray.length; ++i) {
            Font font = fontInfo.getFontInstance(fontTripletArray[i], commonFont.fontSize.getValue(percentBaseContext));
            if (!font.hasChar(c)) continue;
            return font;
        }
        return fontInfo.getFontInstance(fontTripletArray[0], commonFont.fontSize.getValue(percentBaseContext));
    }

    public static Font selectFontForCharacter(Character character, PercentBaseContext percentBaseContext) {
        return FontSelector.selectFontForCharacter(character.getCharacter(), character, character.getCommonFont(), percentBaseContext);
    }

    public static Font selectFontForCharacterInText(char c, FOText fOText, PercentBaseContext percentBaseContext) {
        return FontSelector.selectFontForCharacter(c, fOText, fOText.getCommonFont(), percentBaseContext);
    }

    public static Font selectFontForCharactersInText(CharSequence charSequence, int n, int n2, FOText fOText, PercentBaseContext percentBaseContext) {
        int n3;
        FontInfo fontInfo = fOText.getFOEventHandler().getFontInfo();
        CommonFont commonFont = fOText.getCommonFont();
        FontTriplet[] fontTripletArray = commonFont.getFontState(fontInfo);
        int n4 = fontTripletArray.length;
        Font[] fontArray = new Font[n4];
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            Font font;
            fontArray[i] = font = fontInfo.getFontInstance(fontTripletArray[i], commonFont.fontSize.getValue(percentBaseContext));
            for (n3 = n; n3 < n2; ++n3) {
                if (!font.hasChar(charSequence.charAt(n3))) continue;
                int n5 = i;
                nArray[n5] = nArray[n5] + 1;
            }
            if (nArray[i] != n2 - n) continue;
            return font;
        }
        Font font = fontArray[0];
        int n6 = nArray[0];
        for (n3 = 1; n3 < n4; ++n3) {
            int n7 = nArray[n3];
            if (n7 <= n6) continue;
            font = fontArray[n3];
            n6 = n7;
        }
        return font;
    }
}

