/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import org.apache.xmlgraphics.fonts.Glyphs;

public class NamedCharacter {
    private String charName;
    private String unicodeSequence;

    public NamedCharacter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("charName must not be null");
        }
        this.charName = string;
        this.unicodeSequence = string2 != null ? string2 : Glyphs.getUnicodeSequenceForGlyphName((String)string);
    }

    public NamedCharacter(String string) {
        this(string, null);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.charName == null ? 0 : this.charName.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NamedCharacter namedCharacter = (NamedCharacter)object;
        return this.charName.equals(namedCharacter.charName);
    }

    public String getName() {
        return this.charName;
    }

    public String getUnicodeSequence() {
        return this.unicodeSequence;
    }

    public boolean hasSingleUnicodeValue() {
        return this.unicodeSequence != null && this.unicodeSequence.length() == 1;
    }

    public char getSingleUnicodeValue() throws IllegalStateException {
        if (this.unicodeSequence == null) {
            return '\uffff';
        }
        if (this.unicodeSequence.length() > 1) {
            throw new IllegalStateException("getSingleUnicodeValue() may not be called for a named character that has more than one Unicode value (a sequence) associated with the named character!");
        }
        return this.unicodeSequence.charAt(0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.unicodeSequence);
        stringBuffer.append(" (");
        if (this.unicodeSequence != null) {
            int n = this.unicodeSequence.length();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("0x").append(Integer.toHexString(this.unicodeSequence.charAt(0)));
            }
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.getName()).append(')');
        return stringBuffer.toString();
    }
}

