/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SingleByteEncoding;

public class SimpleSingleByteEncoding
implements SingleByteEncoding {
    private final String name;
    private final List<NamedCharacter> mapping = new ArrayList<NamedCharacter>();
    private final Map<Character, Character> charMap = new HashMap<Character, Character>();

    public SimpleSingleByteEncoding(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public char mapChar(char c) {
        Character c2 = this.charMap.get(Character.valueOf(c));
        if (c2 != null) {
            return c2.charValue();
        }
        return '\u0000';
    }

    public String[] getCharNameMap() {
        Object[] objectArray = new String[this.getSize()];
        Arrays.fill(objectArray, ".notdef");
        for (int i = this.getFirstChar(); i <= this.getLastChar(); ++i) {
            NamedCharacter namedCharacter = this.mapping.get(i - 1);
            objectArray[i] = namedCharacter.getName();
        }
        return objectArray;
    }

    public int getFirstChar() {
        return 1;
    }

    public int getLastChar() {
        return this.mapping.size();
    }

    public int getSize() {
        return this.mapping.size() + 1;
    }

    public boolean isFull() {
        return this.getSize() == 256;
    }

    public char addCharacter(NamedCharacter namedCharacter) {
        if (!namedCharacter.hasSingleUnicodeValue()) {
            throw new IllegalArgumentException("Only NamedCharacters with a single Unicode value are currently supported!");
        }
        if (this.isFull()) {
            throw new IllegalStateException("Encoding is full!");
        }
        char c = (char)(this.getLastChar() + 1);
        this.mapping.add(namedCharacter);
        this.charMap.put(Character.valueOf(namedCharacter.getSingleUnicodeValue()), Character.valueOf(c));
        return c;
    }

    public NamedCharacter getCharacterForIndex(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("codePoint must be between 0 and 255");
        }
        if (n <= this.getLastChar()) {
            return this.mapping.get(n - 1);
        }
        return null;
    }

    public char[] getUnicodeCharMap() {
        int n;
        char[] cArray = new char[this.getLastChar() + 1];
        for (n = 0; n < this.getFirstChar(); ++n) {
            cArray[n] = 65535;
        }
        for (n = this.getFirstChar(); n <= this.getLastChar(); ++n) {
            cArray[n] = this.getCharacterForIndex(n).getSingleUnicodeValue();
        }
        return cArray;
    }

    public String toString() {
        return this.getName() + " (" + this.getSize() + " chars)";
    }
}

