/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SimpleSingleByteEncoding;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.xmlgraphics.fonts.Glyphs;

public class SingleByteFont
extends CustomFont {
    private static Log log = LogFactory.getLog(SingleByteFont.class);
    private SingleByteEncoding mapping;
    private boolean useNativeEncoding = false;
    private int[] width = null;
    private Map<Character, UnencodedCharacter> unencodedCharacters;
    private List<SimpleSingleByteEncoding> additionalEncodings;
    private Map<Character, Character> alternativeCodes;
    private TTFFile.PostScriptVersion ttPostScriptVersion;

    public SingleByteFont() {
        this.setEncoding("WinAnsiEncoding");
    }

    public boolean isEmbeddable() {
        return this.getEmbedFileName() != null || this.getEmbedResourceName() != null;
    }

    public boolean isSubsetEmbedded() {
        return false;
    }

    public String getEncodingName() {
        return this.mapping.getName();
    }

    public SingleByteEncoding getEncoding() {
        return this.mapping;
    }

    public int getWidth(int n, int n2) {
        if (n < 256) {
            int n3 = n - this.getFirstChar();
            if (n3 >= 0 && n3 < this.width.length) {
                return n2 * this.width[n3];
            }
        } else if (this.additionalEncodings != null) {
            int n4 = n / 256 - 1;
            SimpleSingleByteEncoding simpleSingleByteEncoding = this.getAdditionalEncoding(n4);
            int n5 = n % 256;
            NamedCharacter namedCharacter = simpleSingleByteEncoding.getCharacterForIndex(n5);
            UnencodedCharacter unencodedCharacter = this.unencodedCharacters.get(Character.valueOf(namedCharacter.getSingleUnicodeValue()));
            return n2 * unencodedCharacter.getWidth();
        }
        return 0;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.width.length];
        System.arraycopy(this.width, 0, nArray, 0, this.width.length);
        return nArray;
    }

    private char findAlternative(char c) {
        Object object;
        if (this.alternativeCodes == null) {
            this.alternativeCodes = new HashMap<Character, Character>();
        } else {
            object = this.alternativeCodes.get(Character.valueOf(c));
            if (object != null) {
                return ((Character)object).charValue();
            }
        }
        object = Glyphs.charToGlyphName((char)c);
        String[] stringArray = Glyphs.getCharNameAlternativesFor((String)object);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                char c2;
                String string;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking alternative for char " + c + " (charname=" + (String)object + "): " + stringArray[i]));
                }
                if ((string = Glyphs.getUnicodeSequenceForGlyphName((String)stringArray[i])) == null || (c2 = this.lookupChar(string.charAt(0))) == '\u0000') continue;
                this.alternativeCodes.put(Character.valueOf(c), Character.valueOf(c2));
                return c2;
            }
        }
        return '\u0000';
    }

    private char lookupChar(char c) {
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        c2 = this.mapUnencodedChar(c);
        return c2;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char c2 = this.lookupChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        c2 = this.findAlternative(c);
        if (c2 != '\u0000') {
            return c2;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    private char mapUnencodedChar(char c) {
        UnencodedCharacter unencodedCharacter;
        if (this.unencodedCharacters != null && (unencodedCharacter = this.unencodedCharacters.get(Character.valueOf(c))) != null) {
            if (this.additionalEncodings == null) {
                this.additionalEncodings = new ArrayList<SimpleSingleByteEncoding>();
            }
            SimpleSingleByteEncoding simpleSingleByteEncoding = null;
            int n = 0;
            int n2 = this.additionalEncodings.size();
            for (int i = 0; i < n2; ++i) {
                n = (char)(n + 256);
                simpleSingleByteEncoding = this.getAdditionalEncoding(i);
                char c2 = simpleSingleByteEncoding.mapChar(c);
                if (c2 == '\u0000') continue;
                return (char)(n + c2);
            }
            if (simpleSingleByteEncoding != null && simpleSingleByteEncoding.isFull()) {
                simpleSingleByteEncoding = null;
            }
            if (simpleSingleByteEncoding == null) {
                simpleSingleByteEncoding = new SimpleSingleByteEncoding(this.getFontName() + "EncodingSupp" + (n2 + 1));
                this.additionalEncodings.add(simpleSingleByteEncoding);
                n = (char)(n + 256);
            }
            return (char)(n + simpleSingleByteEncoding.addCharacter(unencodedCharacter.getCharacter()));
        }
        return '\u0000';
    }

    public boolean hasChar(char c) {
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return true;
        }
        c2 = this.mapUnencodedChar(c);
        if (c2 != '\u0000') {
            return true;
        }
        c2 = this.findAlternative(c);
        return c2 != '\u0000';
    }

    protected void updateMapping(String string) {
        try {
            this.mapping = CodePointMapping.getMapping(string);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.error((Object)("Font '" + super.getFontName() + "': " + unsupportedOperationException.getMessage()));
        }
    }

    public void setEncoding(String string) {
        this.updateMapping(string);
    }

    public void setEncoding(CodePointMapping codePointMapping) {
        this.mapping = codePointMapping;
    }

    public void setUseNativeEncoding(boolean bl) {
        this.useNativeEncoding = bl;
    }

    public boolean isUsingNativeEncoding() {
        return this.useNativeEncoding;
    }

    public void setWidth(int n, int n2) {
        if (this.width == null) {
            this.width = new int[this.getLastChar() - this.getFirstChar() + 1];
        }
        this.width[n - this.getFirstChar()] = n2;
    }

    public void addUnencodedCharacter(NamedCharacter namedCharacter, int n) {
        if (this.unencodedCharacters == null) {
            this.unencodedCharacters = new HashMap<Character, UnencodedCharacter>();
        }
        if (namedCharacter.hasSingleUnicodeValue()) {
            UnencodedCharacter unencodedCharacter = new UnencodedCharacter(namedCharacter, n);
            this.unencodedCharacters.put(Character.valueOf(namedCharacter.getSingleUnicodeValue()), unencodedCharacter);
        }
    }

    public void encodeAllUnencodedCharacters() {
        if (this.unencodedCharacters != null) {
            TreeSet<Character> treeSet = new TreeSet<Character>(this.unencodedCharacters.keySet());
            for (Character c : treeSet) {
                char c2 = this.mapChar(c.charValue());
                assert (c2 != '#');
            }
        }
    }

    public boolean hasAdditionalEncodings() {
        return this.additionalEncodings != null && this.additionalEncodings.size() > 0;
    }

    public int getAdditionalEncodingCount() {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.size();
        }
        return 0;
    }

    public SimpleSingleByteEncoding getAdditionalEncoding(int n) throws IndexOutOfBoundsException {
        if (this.hasAdditionalEncodings()) {
            return this.additionalEncodings.get(n);
        }
        throw new IndexOutOfBoundsException("No additional encodings available");
    }

    public int[] getAdditionalWidths(int n) {
        SimpleSingleByteEncoding simpleSingleByteEncoding = this.getAdditionalEncoding(n);
        int[] nArray = new int[simpleSingleByteEncoding.getLastChar() - simpleSingleByteEncoding.getFirstChar() + 1];
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            NamedCharacter namedCharacter = simpleSingleByteEncoding.getCharacterForIndex(simpleSingleByteEncoding.getFirstChar() + i);
            UnencodedCharacter unencodedCharacter = this.unencodedCharacters.get(Character.valueOf(namedCharacter.getSingleUnicodeValue()));
            nArray[i] = unencodedCharacter.getWidth();
        }
        return nArray;
    }

    public void setTrueTypePostScriptVersion(TTFFile.PostScriptVersion postScriptVersion) {
        this.ttPostScriptVersion = postScriptVersion;
    }

    public TTFFile.PostScriptVersion getTrueTypePostScriptVersion() {
        assert (this.getFontType() == FontType.TRUETYPE);
        return this.ttPostScriptVersion;
    }

    private static final class UnencodedCharacter {
        private final NamedCharacter character;
        private final int width;

        public UnencodedCharacter(NamedCharacter namedCharacter, int n) {
            this.character = namedCharacter;
            this.width = n;
        }

        public NamedCharacter getCharacter() {
            return this.character;
        }

        public int getWidth() {
            return this.width;
        }

        public String toString() {
            return this.getCharacter().toString();
        }
    }
}

