/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.apps.AbstractFontReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.util.CommandLineLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TTFReader
extends AbstractFontReader {
    public static final String METRICS_VERSION_ATTR = "metrics-version";
    public static final int METRICS_VERSION = 2;

    private static void displayUsage() {
        System.out.println("java " + TTFReader.class.getName() + " [options] fontfile.ttf xmlfile.xml");
        System.out.println();
        System.out.println("where options can be:");
        System.out.println("-t  Trace mode");
        System.out.println("-d  Debug mode");
        System.out.println("-q  Quiet mode");
        System.out.println("-enc ansi");
        System.out.println("    With this option you create a WinAnsi encoded font.");
        System.out.println("    The default is to create a CID keyed font.");
        System.out.println("    If you're not going to use characters outside the");
        System.out.println("    pdfencoding range (almost the same as iso-8889-1)");
        System.out.println("    you can add this option.");
        System.out.println("-ttcname <fontname>");
        System.out.println("    If you're reading data from a TrueType Collection");
        System.out.println("    (.ttc file) you must specify which font from the");
        System.out.println("    collection you will read metrics from. If you read");
        System.out.println("    from a .ttc file without this option, the fontnames");
        System.out.println("    will be listed for you.");
        System.out.println(" -fn <fontname>");
        System.out.println("    default is to use the fontname in the .ttf file, but");
        System.out.println("    you can override that name to make sure that the");
        System.out.println("    embedded font is used (if you're embedding fonts)");
        System.out.println("    instead of installed fonts when viewing documents ");
        System.out.println("    with Acrobat Reader.");
    }

    public static void main(String[] stringArray) {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = true;
        HashMap hashMap = new HashMap();
        String[] stringArray2 = TTFReader.parseArguments(hashMap, stringArray);
        LogFactory logFactory = LogFactory.getFactory();
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            logFactory.setAttribute("org.apache.commons.logging.Log", (Object)CommandLineLogger.class.getName());
        }
        TTFReader.determineLogLevel(hashMap);
        TTFReader tTFReader = new TTFReader();
        log.info((Object)("TTF Reader for Apache FOP " + Version.getVersion() + "\n"));
        if (hashMap.get("-enc") != null && "ansi".equals(string = (String)hashMap.get("-enc"))) {
            bl = false;
        }
        if (hashMap.get("-ttcname") != null) {
            string6 = (String)hashMap.get("-ttcname");
        }
        if (hashMap.get("-ef") != null) {
            string2 = (String)hashMap.get("-ef");
        }
        if (hashMap.get("-er") != null) {
            string3 = (String)hashMap.get("-er");
        }
        if (hashMap.get("-fn") != null) {
            string5 = (String)hashMap.get("-fn");
        }
        if (hashMap.get("-cn") != null) {
            string4 = (String)hashMap.get("-cn");
        }
        boolean bl2 = true;
        boolean bl3 = true;
        if (hashMap.get("-nocs") != null) {
            bl3 = false;
        }
        if (stringArray2.length != 2 || hashMap.get("-h") != null || hashMap.get("-help") != null || hashMap.get("--help") != null) {
            TTFReader.displayUsage();
        } else {
            try {
                log.info((Object)"Parsing font...");
                TTFFile tTFFile = tTFReader.loadTTF(stringArray2[0], string6, bl2, bl3);
                if (tTFFile != null) {
                    Document document = tTFReader.constructFontXML(tTFFile, string5, string4, string3, string2, bl, string6);
                    if (bl) {
                        log.info((Object)"Creating CID encoded metrics...");
                    } else {
                        log.info((Object)"Creating WinAnsi encoded metrics...");
                    }
                    if (document != null) {
                        tTFReader.writeFontXML(document, stringArray2[1]);
                    }
                    if (tTFFile.isEmbeddable()) {
                        log.info((Object)"This font contains no embedding license restrictions.");
                    } else {
                        log.info((Object)"** Note: This font contains license retrictions for\n         embedding. This font shouldn't be embedded.");
                    }
                }
                log.info((Object)"");
                log.info((Object)"XML font metrics file successfully created.");
            }
            catch (Exception exception) {
                log.error((Object)"Error while building XML font metrics file.", (Throwable)exception);
                System.exit(-1);
            }
        }
    }

    public TTFFile loadTTF(String string, String string2, boolean bl, boolean bl2) throws IOException {
        TTFFile tTFFile = new TTFFile(bl, bl2);
        log.info((Object)("Reading " + string + "..."));
        FontFileReader fontFileReader = new FontFileReader(string);
        boolean bl3 = tTFFile.readFont(fontFileReader, string2);
        if (!bl3) {
            return null;
        }
        log.info((Object)("Font Family: " + tTFFile.getFamilyNames()));
        if (tTFFile.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
        }
        return tTFFile;
    }

    public Document constructFontXML(TTFFile tTFFile, String string, String string2, String string3, String string4, boolean bl, String string5) {
        Object object;
        Set<String> set;
        Document document;
        Object object2;
        log.info((Object)"Creating xml font file...");
        try {
            object2 = DocumentBuilderFactory.newInstance();
            document = ((DocumentBuilderFactory)object2).newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error((Object)"Can't create DOM implementation", (Throwable)parserConfigurationException);
            return null;
        }
        object2 = document.createElement("font-metrics");
        document.appendChild((Node)object2);
        object2.setAttribute(METRICS_VERSION_ATTR, String.valueOf(2));
        if (bl) {
            object2.setAttribute("type", "TYPE0");
        } else {
            object2.setAttribute("type", "TRUETYPE");
        }
        Element element = document.createElement("font-name");
        object2.appendChild(element);
        String string6 = FontUtil.stripWhiteSpace(tTFFile.getPostScriptName());
        if (string != null) {
            element.appendChild(document.createTextNode(FontUtil.stripWhiteSpace(string)));
        } else {
            element.appendChild(document.createTextNode(string6));
        }
        if (tTFFile.getFullName() != null) {
            element = document.createElement("full-name");
            object2.appendChild(element);
            element.appendChild(document.createTextNode(tTFFile.getFullName()));
        }
        if ((set = tTFFile.getFamilyNames()).size() > 0) {
            object = set.iterator().next();
            element = document.createElement("family-name");
            object2.appendChild(element);
            element.appendChild(document.createTextNode((String)object));
        }
        element = document.createElement("embed");
        object2.appendChild(element);
        if (string4 != null && tTFFile.isEmbeddable()) {
            element.setAttribute("file", string4);
        }
        if (string3 != null && tTFFile.isEmbeddable()) {
            element.setAttribute("class", string3);
        }
        element = document.createElement("cap-height");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(String.valueOf(tTFFile.getCapHeight())));
        element = document.createElement("x-height");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(String.valueOf(tTFFile.getXHeight())));
        element = document.createElement("ascender");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(String.valueOf(tTFFile.getLowerCaseAscent())));
        element = document.createElement("descender");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(String.valueOf(tTFFile.getLowerCaseDescent())));
        object = document.createElement("bbox");
        object2.appendChild((Node)object);
        int[] nArray = tTFFile.getFontBBox();
        String[] stringArray = new String[]{"left", "bottom", "right", "top"};
        for (int i = 0; i < stringArray.length; ++i) {
            element = document.createElement(stringArray[i]);
            object.appendChild(element);
            element.appendChild(document.createTextNode(String.valueOf(nArray[i])));
        }
        element = document.createElement("flags");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(String.valueOf(tTFFile.getFlags())));
        element = document.createElement("stemv");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(tTFFile.getStemV()));
        element = document.createElement("italicangle");
        object2.appendChild(element);
        element.appendChild(document.createTextNode(tTFFile.getItalicAngle()));
        if (string5 != null) {
            element = document.createElement("ttc-name");
            object2.appendChild(element);
            element.appendChild(document.createTextNode(string5));
        }
        element = document.createElement("subtype");
        object2.appendChild(element);
        if (bl) {
            element.appendChild(document.createTextNode("TYPE0"));
            this.generateDOM4MultiByteExtras((Element)object2, tTFFile, bl);
        } else {
            element.appendChild(document.createTextNode("TRUETYPE"));
            this.generateDOM4SingleByteExtras((Element)object2, tTFFile, bl);
        }
        this.generateDOM4Kerning((Element)object2, tTFFile, bl);
        return document;
    }

    private void generateDOM4MultiByteExtras(Element element, TTFFile tTFFile, boolean bl) {
        Element element2;
        Document document = element.getOwnerDocument();
        Element element3 = document.createElement("multibyte-extras");
        element.appendChild(element3);
        Element element4 = document.createElement("cid-type");
        element3.appendChild(element4);
        element4.appendChild(document.createTextNode("CIDFontType2"));
        element4 = document.createElement("default-width");
        element3.appendChild(element4);
        element4.appendChild(document.createTextNode("0"));
        element4 = document.createElement("bfranges");
        element3.appendChild(element4);
        for (CMapSegment cMapSegment : tTFFile.getCMaps()) {
            element2 = document.createElement("bf");
            element4.appendChild(element2);
            element2.setAttribute("us", String.valueOf(cMapSegment.getUnicodeStart()));
            element2.setAttribute("ue", String.valueOf(cMapSegment.getUnicodeEnd()));
            element2.setAttribute("gi", String.valueOf(cMapSegment.getGlyphStartIndex()));
        }
        element4 = document.createElement("cid-widths");
        element4.setAttribute("start-index", "0");
        element3.appendChild(element4);
        Object object = tTFFile.getWidths();
        for (int i = 0; i < ((Object)object).length; ++i) {
            element2 = document.createElement("wx");
            element2.setAttribute("w", String.valueOf((int)object[i]));
            element4.appendChild(element2);
        }
    }

    private void generateDOM4SingleByteExtras(Element element, TTFFile tTFFile, boolean bl) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("singlebyte-extras");
        element.appendChild(element2);
        Element element3 = document.createElement("encoding");
        element2.appendChild(element3);
        element3.appendChild(document.createTextNode(tTFFile.getCharSetName()));
        element3 = document.createElement("first-char");
        element2.appendChild(element3);
        element3.appendChild(document.createTextNode(String.valueOf(tTFFile.getFirstChar())));
        element3 = document.createElement("last-char");
        element2.appendChild(element3);
        element3.appendChild(document.createTextNode(String.valueOf(tTFFile.getLastChar())));
        Element element4 = document.createElement("widths");
        element2.appendChild(element4);
        for (short s = tTFFile.getFirstChar(); s <= tTFFile.getLastChar(); s = (short)(s + 1)) {
            element3 = document.createElement("char");
            element4.appendChild(element3);
            element3.setAttribute("idx", String.valueOf(s));
            element3.setAttribute("wdt", String.valueOf(tTFFile.getCharWidth(s)));
        }
    }

    private void generateDOM4Kerning(Element element, TTFFile tTFFile, boolean bl) {
        Document document = element.getOwnerDocument();
        Set<Integer> set = bl ? tTFFile.getKerning().keySet() : tTFFile.getAnsiKerning().keySet();
        for (Integer n : set) {
            Element element2 = document.createElement("kerning");
            element2.setAttribute("kpx1", n.toString());
            element.appendChild(element2);
            Element element3 = null;
            Map<Integer, Integer> map = bl ? tTFFile.getKerning().get(n) : tTFFile.getAnsiKerning().get(n);
            for (Integer n2 : map.keySet()) {
                if (!bl && n2 >= 256) continue;
                element3 = document.createElement("pair");
                element3.setAttribute("kpx2", n2.toString());
                Integer n3 = map.get(n2);
                element3.setAttribute("kern", n3.toString());
                element2.appendChild(element3);
            }
        }
    }

    public static void checkMetricsVersion(Attributes attributes) throws SAXException {
        String string = null;
        String string2 = attributes.getValue(METRICS_VERSION_ATTR);
        if (string2 == null) {
            string = "Missing metrics-version attribute";
        } else {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
                if (n < 2) {
                    string = "Incompatible metrics-version value (" + n + ", should be " + 2 + ")";
                }
            }
            catch (NumberFormatException numberFormatException) {
                string = "Invalid metrics-version attribute value (" + string2 + ")";
            }
        }
        if (string != null) {
            throw new SAXException(string + " - please regenerate the font metrics file with " + "a more recent version of FOP.");
        }
    }
}

