/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.autodetect;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.autodetect.FontDirFinder;
import org.apache.fop.fonts.autodetect.FontFinder;
import org.apache.fop.fonts.autodetect.MacFontDirFinder;
import org.apache.fop.fonts.autodetect.UnixFontDirFinder;
import org.apache.fop.fonts.autodetect.WindowsFontDirFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontFileFinder
extends DirectoryWalker
implements FontFinder {
    private final Log log = LogFactory.getLog(FontFileFinder.class);
    public static final int DEFAULT_DEPTH_LIMIT = -1;
    private final FontEventListener eventListener;

    public FontFileFinder(FontEventListener fontEventListener) {
        this(-1, fontEventListener);
    }

    public FontFileFinder(int n, FontEventListener fontEventListener) {
        super(FontFileFinder.getDirectoryFilter(), FontFileFinder.getFileFilter(), n);
        this.eventListener = fontEventListener;
    }

    protected static IOFileFilter getDirectoryFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.directoryFileFilter(), (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)".")));
    }

    protected static IOFileFilter getFileFilter() {
        return FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.fileFileFilter(), (IOFileFilter)new WildcardFileFilter(new String[]{"*.ttf", "*.otf", "*.pfb", "*.ttc"}, IOCase.INSENSITIVE));
    }

    protected boolean handleDirectory(File file, int n, Collection collection) {
        return true;
    }

    protected void handleFile(File file, int n, Collection collection) {
        try {
            collection.add(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            this.log.debug((Object)("MalformedURLException" + malformedURLException.getMessage()));
        }
    }

    protected void handleDirectoryEnd(File file, int n, Collection collection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(file + ": found " + collection.size() + " font" + (collection.size() == 1 ? "" : "s")));
        }
    }

    @Override
    public List<URL> find() throws IOException {
        String string = System.getProperty("os.name");
        FontDirFinder fontDirFinder = string.startsWith("Windows") ? new WindowsFontDirFinder() : (string.startsWith("Mac") ? new MacFontDirFinder() : new UnixFontDirFinder());
        List<File> list = fontDirFinder.find();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : list) {
            super.walk(file, arrayList);
        }
        return arrayList;
    }

    public List<URL> find(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        File file = new File(string);
        if (!file.isDirectory()) {
            this.eventListener.fontDirectoryNotFound(this, string);
        } else {
            super.walk(file, arrayList);
        }
        return arrayList;
    }
}

