/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesItalic
extends Base14Font {
    private static final String fontName = "Times-Italic";
    private static final String fullName = "Times Italic";
    private static final Set familyNames;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 653;
    private static final int xHeight = 441;
    private static final int ascender = 683;
    private static final int descender = -205;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public TimesItalic() {
        this(false);
    }

    public TimesItalic(boolean bl) {
        this.enableKerning = bl;
    }

    public String getEncodingName() {
        return encoding;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int n) {
        return n * 683;
    }

    public int getCapHeight(int n) {
        return n * 653;
    }

    public int getDescender(int n) {
        return n * -205;
    }

    public int getXHeight(int n) {
        return n * 441;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int n, int n2) {
        return n2 * width[n];
    }

    public int[] getWidths() {
        int[] nArray = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), nArray, 0, this.getLastChar() - this.getFirstChar() + 1);
        return nArray;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        width = new int[256];
        TimesItalic.width[65] = 611;
        TimesItalic.width[198] = 889;
        TimesItalic.width[193] = 611;
        TimesItalic.width[194] = 611;
        TimesItalic.width[196] = 611;
        TimesItalic.width[192] = 611;
        TimesItalic.width[197] = 611;
        TimesItalic.width[195] = 611;
        TimesItalic.width[66] = 611;
        TimesItalic.width[67] = 667;
        TimesItalic.width[199] = 667;
        TimesItalic.width[68] = 722;
        TimesItalic.width[69] = 611;
        TimesItalic.width[201] = 611;
        TimesItalic.width[202] = 611;
        TimesItalic.width[203] = 611;
        TimesItalic.width[200] = 611;
        TimesItalic.width[208] = 722;
        TimesItalic.width[128] = 500;
        TimesItalic.width[70] = 611;
        TimesItalic.width[71] = 722;
        TimesItalic.width[72] = 722;
        TimesItalic.width[73] = 333;
        TimesItalic.width[205] = 333;
        TimesItalic.width[206] = 333;
        TimesItalic.width[207] = 333;
        TimesItalic.width[204] = 333;
        TimesItalic.width[74] = 444;
        TimesItalic.width[75] = 667;
        TimesItalic.width[76] = 556;
        TimesItalic.width[77] = 833;
        TimesItalic.width[78] = 667;
        TimesItalic.width[209] = 667;
        TimesItalic.width[79] = 722;
        TimesItalic.width[140] = 944;
        TimesItalic.width[211] = 722;
        TimesItalic.width[212] = 722;
        TimesItalic.width[214] = 722;
        TimesItalic.width[210] = 722;
        TimesItalic.width[216] = 722;
        TimesItalic.width[213] = 722;
        TimesItalic.width[80] = 611;
        TimesItalic.width[81] = 722;
        TimesItalic.width[82] = 611;
        TimesItalic.width[83] = 500;
        TimesItalic.width[138] = 500;
        TimesItalic.width[84] = 556;
        TimesItalic.width[222] = 611;
        TimesItalic.width[85] = 722;
        TimesItalic.width[218] = 722;
        TimesItalic.width[219] = 722;
        TimesItalic.width[220] = 722;
        TimesItalic.width[217] = 722;
        TimesItalic.width[86] = 611;
        TimesItalic.width[87] = 833;
        TimesItalic.width[88] = 611;
        TimesItalic.width[89] = 556;
        TimesItalic.width[221] = 556;
        TimesItalic.width[159] = 556;
        TimesItalic.width[90] = 556;
        TimesItalic.width[142] = 556;
        TimesItalic.width[97] = 500;
        TimesItalic.width[225] = 500;
        TimesItalic.width[226] = 500;
        TimesItalic.width[180] = 333;
        TimesItalic.width[228] = 500;
        TimesItalic.width[230] = 667;
        TimesItalic.width[224] = 500;
        TimesItalic.width[38] = 778;
        TimesItalic.width[229] = 500;
        TimesItalic.width[94] = 422;
        TimesItalic.width[126] = 541;
        TimesItalic.width[42] = 500;
        TimesItalic.width[64] = 920;
        TimesItalic.width[227] = 500;
        TimesItalic.width[98] = 500;
        TimesItalic.width[92] = 278;
        TimesItalic.width[124] = 275;
        TimesItalic.width[123] = 400;
        TimesItalic.width[125] = 400;
        TimesItalic.width[91] = 389;
        TimesItalic.width[93] = 389;
        TimesItalic.width[166] = 275;
        TimesItalic.width[149] = 350;
        TimesItalic.width[99] = 444;
        TimesItalic.width[231] = 444;
        TimesItalic.width[184] = 333;
        TimesItalic.width[162] = 500;
        TimesItalic.width[136] = 333;
        TimesItalic.width[58] = 333;
        TimesItalic.width[44] = 250;
        TimesItalic.width[169] = 760;
        TimesItalic.width[164] = 500;
        TimesItalic.width[100] = 500;
        TimesItalic.width[134] = 500;
        TimesItalic.width[135] = 500;
        TimesItalic.width[176] = 400;
        TimesItalic.width[168] = 333;
        TimesItalic.width[247] = 675;
        TimesItalic.width[36] = 500;
        TimesItalic.width[101] = 444;
        TimesItalic.width[233] = 444;
        TimesItalic.width[234] = 444;
        TimesItalic.width[235] = 444;
        TimesItalic.width[232] = 444;
        TimesItalic.width[56] = 500;
        TimesItalic.width[133] = 889;
        TimesItalic.width[151] = 889;
        TimesItalic.width[150] = 500;
        TimesItalic.width[61] = 675;
        TimesItalic.width[240] = 500;
        TimesItalic.width[33] = 333;
        TimesItalic.width[161] = 389;
        TimesItalic.width[102] = 278;
        TimesItalic.width[53] = 500;
        TimesItalic.width[131] = 500;
        TimesItalic.width[52] = 500;
        TimesItalic.width[103] = 500;
        TimesItalic.width[223] = 500;
        TimesItalic.width[96] = 333;
        TimesItalic.width[62] = 675;
        TimesItalic.width[171] = 500;
        TimesItalic.width[187] = 500;
        TimesItalic.width[139] = 333;
        TimesItalic.width[155] = 333;
        TimesItalic.width[104] = 500;
        TimesItalic.width[45] = 333;
        TimesItalic.width[105] = 278;
        TimesItalic.width[237] = 278;
        TimesItalic.width[238] = 278;
        TimesItalic.width[239] = 278;
        TimesItalic.width[236] = 278;
        TimesItalic.width[106] = 278;
        TimesItalic.width[107] = 444;
        TimesItalic.width[108] = 278;
        TimesItalic.width[60] = 675;
        TimesItalic.width[172] = 675;
        TimesItalic.width[109] = 722;
        TimesItalic.width[175] = 333;
        TimesItalic.width[181] = 500;
        TimesItalic.width[215] = 675;
        TimesItalic.width[110] = 500;
        TimesItalic.width[57] = 500;
        TimesItalic.width[241] = 500;
        TimesItalic.width[35] = 500;
        TimesItalic.width[111] = 500;
        TimesItalic.width[243] = 500;
        TimesItalic.width[244] = 500;
        TimesItalic.width[246] = 500;
        TimesItalic.width[156] = 667;
        TimesItalic.width[242] = 500;
        TimesItalic.width[49] = 500;
        TimesItalic.width[189] = 750;
        TimesItalic.width[188] = 750;
        TimesItalic.width[185] = 300;
        TimesItalic.width[170] = 276;
        TimesItalic.width[186] = 310;
        TimesItalic.width[248] = 500;
        TimesItalic.width[245] = 500;
        TimesItalic.width[112] = 500;
        TimesItalic.width[182] = 523;
        TimesItalic.width[40] = 333;
        TimesItalic.width[41] = 333;
        TimesItalic.width[37] = 833;
        TimesItalic.width[46] = 250;
        TimesItalic.width[183] = 250;
        TimesItalic.width[137] = 1000;
        TimesItalic.width[43] = 675;
        TimesItalic.width[177] = 675;
        TimesItalic.width[113] = 500;
        TimesItalic.width[63] = 500;
        TimesItalic.width[191] = 500;
        TimesItalic.width[34] = 420;
        TimesItalic.width[132] = 556;
        TimesItalic.width[147] = 556;
        TimesItalic.width[148] = 556;
        TimesItalic.width[145] = 333;
        TimesItalic.width[146] = 333;
        TimesItalic.width[130] = 333;
        TimesItalic.width[39] = 214;
        TimesItalic.width[114] = 389;
        TimesItalic.width[174] = 760;
        TimesItalic.width[115] = 389;
        TimesItalic.width[154] = 389;
        TimesItalic.width[167] = 500;
        TimesItalic.width[59] = 333;
        TimesItalic.width[55] = 500;
        TimesItalic.width[54] = 500;
        TimesItalic.width[47] = 278;
        TimesItalic.width[32] = 250;
        TimesItalic.width[163] = 500;
        TimesItalic.width[116] = 278;
        TimesItalic.width[254] = 500;
        TimesItalic.width[51] = 500;
        TimesItalic.width[190] = 750;
        TimesItalic.width[179] = 300;
        TimesItalic.width[152] = 333;
        TimesItalic.width[153] = 980;
        TimesItalic.width[50] = 500;
        TimesItalic.width[178] = 300;
        TimesItalic.width[117] = 500;
        TimesItalic.width[250] = 500;
        TimesItalic.width[251] = 500;
        TimesItalic.width[252] = 500;
        TimesItalic.width[249] = 500;
        TimesItalic.width[95] = 500;
        TimesItalic.width[118] = 444;
        TimesItalic.width[119] = 667;
        TimesItalic.width[120] = 444;
        TimesItalic.width[121] = 444;
        TimesItalic.width[253] = 444;
        TimesItalic.width[255] = 444;
        TimesItalic.width[165] = 500;
        TimesItalic.width[122] = 389;
        TimesItalic.width[158] = 389;
        TimesItalic.width[48] = 500;
        kerning = new HashMap();
        Integer n = new Integer(79);
        Map<Integer, Integer> map = (HashMap<Integer, Integer>)kerning.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            kerning.put(n, map);
        }
        Integer n2 = new Integer(65);
        map.put(n2, new Integer(-55));
        n2 = new Integer(87);
        map.put(n2, new Integer(-50));
        n2 = new Integer(89);
        map.put(n2, new Integer(-50));
        n2 = new Integer(84);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n2 = new Integer(88);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(107);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-10));
        n2 = new Integer(121);
        map.put(n2, new Integer(-10));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n = new Integer(112);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(80);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-80));
        n2 = new Integer(97);
        map.put(n2, new Integer(-80));
        n2 = new Integer(65);
        map.put(n2, new Integer(-90));
        n2 = new Integer(46);
        map.put(n2, new Integer(-135));
        n2 = new Integer(101);
        map.put(n2, new Integer(-80));
        n2 = new Integer(44);
        map.put(n2, new Integer(-135));
        n = new Integer(86);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-111));
        n2 = new Integer(79);
        map.put(n2, new Integer(-30));
        n2 = new Integer(58);
        map.put(n2, new Integer(-65));
        n2 = new Integer(71);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-129));
        n2 = new Integer(59);
        map.put(n2, new Integer(-74));
        n2 = new Integer(45);
        map.put(n2, new Integer(-55));
        n2 = new Integer(105);
        map.put(n2, new Integer(-74));
        n2 = new Integer(65);
        map.put(n2, new Integer(-60));
        n2 = new Integer(97);
        map.put(n2, new Integer(-111));
        n2 = new Integer(117);
        map.put(n2, new Integer(-74));
        n2 = new Integer(46);
        map.put(n2, new Integer(-129));
        n2 = new Integer(101);
        map.put(n2, new Integer(-111));
        n = new Integer(118);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-74));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-74));
        n = new Integer(32);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-18));
        n2 = new Integer(87);
        map.put(n2, new Integer(-40));
        n2 = new Integer(147);
        map.put(n2, new Integer(0));
        n2 = new Integer(89);
        map.put(n2, new Integer(-75));
        n2 = new Integer(84);
        map.put(n2, new Integer(-18));
        n2 = new Integer(145);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-35));
        n = new Integer(97);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(-10));
        n2 = new Integer(98);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n = new Integer(70);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-105));
        n2 = new Integer(105);
        map.put(n2, new Integer(-45));
        n2 = new Integer(114);
        map.put(n2, new Integer(-55));
        n2 = new Integer(97);
        map.put(n2, new Integer(-75));
        n2 = new Integer(65);
        map.put(n2, new Integer(-115));
        n2 = new Integer(46);
        map.put(n2, new Integer(-135));
        n2 = new Integer(101);
        map.put(n2, new Integer(-75));
        n2 = new Integer(44);
        map.put(n2, new Integer(-135));
        n = new Integer(85);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(-25));
        n2 = new Integer(44);
        map.put(n2, new Integer(-25));
        n = new Integer(100);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(100);
        map.put(n2, new Integer(0));
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(83);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(122);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n = new Integer(68);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-35));
        n2 = new Integer(87);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(146);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(100);
        map.put(n2, new Integer(-25));
        n2 = new Integer(32);
        map.put(n2, new Integer(-111));
        n2 = new Integer(146);
        map.put(n2, new Integer(-111));
        n2 = new Integer(114);
        map.put(n2, new Integer(-25));
        n2 = new Integer(116);
        map.put(n2, new Integer(-30));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(115);
        map.put(n2, new Integer(-40));
        n2 = new Integer(118);
        map.put(n2, new Integer(-10));
        n = new Integer(58);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n = new Integer(119);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-74));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-74));
        n = new Integer(75);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-40));
        n2 = new Integer(79);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-40));
        n2 = new Integer(121);
        map.put(n2, new Integer(-40));
        n2 = new Integer(101);
        map.put(n2, new Integer(-35));
        n = new Integer(82);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-40));
        n2 = new Integer(87);
        map.put(n2, new Integer(-18));
        n2 = new Integer(85);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-18));
        n2 = new Integer(84);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-18));
        n = new Integer(145);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(0));
        n2 = new Integer(145);
        map.put(n2, new Integer(-111));
        n = new Integer(103);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(103);
        map.put(n2, new Integer(-10));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-10));
        n = new Integer(66);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-25));
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(98);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(81);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(44);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-140));
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n2 = new Integer(146);
        map.put(n2, new Integer(-140));
        n = new Integer(102);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(105);
        map.put(n2, new Integer(-20));
        n2 = new Integer(146);
        map.put(n2, new Integer(92));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(102);
        map.put(n2, new Integer(-18));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-10));
        n = new Integer(84);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-92));
        n2 = new Integer(79);
        map.put(n2, new Integer(-18));
        n2 = new Integer(119);
        map.put(n2, new Integer(-74));
        n2 = new Integer(58);
        map.put(n2, new Integer(-55));
        n2 = new Integer(114);
        map.put(n2, new Integer(-55));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-74));
        n2 = new Integer(59);
        map.put(n2, new Integer(-65));
        n2 = new Integer(45);
        map.put(n2, new Integer(-74));
        n2 = new Integer(105);
        map.put(n2, new Integer(-55));
        n2 = new Integer(65);
        map.put(n2, new Integer(-50));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(117);
        map.put(n2, new Integer(-55));
        n2 = new Integer(121);
        map.put(n2, new Integer(-74));
        n2 = new Integer(46);
        map.put(n2, new Integer(-74));
        n2 = new Integer(101);
        map.put(n2, new Integer(-92));
        n = new Integer(121);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-55));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-55));
        n = new Integer(120);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n = new Integer(101);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-15));
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-15));
        n2 = new Integer(103);
        map.put(n2, new Integer(-40));
        n2 = new Integer(98);
        map.put(n2, new Integer(0));
        n2 = new Integer(120);
        map.put(n2, new Integer(-20));
        n2 = new Integer(118);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(-10));
        n = new Integer(99);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(107);
        map.put(n2, new Integer(-20));
        n2 = new Integer(104);
        map.put(n2, new Integer(-15));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(87);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-92));
        n2 = new Integer(79);
        map.put(n2, new Integer(-25));
        n2 = new Integer(58);
        map.put(n2, new Integer(-65));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n2 = new Integer(59);
        map.put(n2, new Integer(-65));
        n2 = new Integer(45);
        map.put(n2, new Integer(-37));
        n2 = new Integer(105);
        map.put(n2, new Integer(-55));
        n2 = new Integer(65);
        map.put(n2, new Integer(-60));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(117);
        map.put(n2, new Integer(-55));
        n2 = new Integer(121);
        map.put(n2, new Integer(-70));
        n2 = new Integer(46);
        map.put(n2, new Integer(-92));
        n2 = new Integer(101);
        map.put(n2, new Integer(-92));
        n = new Integer(104);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(71);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(105);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n = new Integer(65);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-40));
        n2 = new Integer(146);
        map.put(n2, new Integer(-37));
        n2 = new Integer(119);
        map.put(n2, new Integer(-55));
        n2 = new Integer(87);
        map.put(n2, new Integer(-95));
        n2 = new Integer(67);
        map.put(n2, new Integer(-30));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(81);
        map.put(n2, new Integer(-40));
        n2 = new Integer(71);
        map.put(n2, new Integer(-35));
        n2 = new Integer(86);
        map.put(n2, new Integer(-105));
        n2 = new Integer(118);
        map.put(n2, new Integer(-55));
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(85);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(89);
        map.put(n2, new Integer(-55));
        n2 = new Integer(121);
        map.put(n2, new Integer(-55));
        n2 = new Integer(84);
        map.put(n2, new Integer(-37));
        n = new Integer(147);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(0));
        n2 = new Integer(145);
        map.put(n2, new Integer(0));
        n = new Integer(78);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-27));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(115);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n = new Integer(111);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(-10));
        n2 = new Integer(120);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-10));
        n = new Integer(114);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-45));
        n2 = new Integer(100);
        map.put(n2, new Integer(-37));
        n2 = new Integer(107);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(99);
        map.put(n2, new Integer(-37));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(-37));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(113);
        map.put(n2, new Integer(-37));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-111));
        n2 = new Integer(45);
        map.put(n2, new Integer(-20));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(109);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(-15));
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-111));
        n2 = new Integer(110);
        map.put(n2, new Integer(0));
        n2 = new Integer(115);
        map.put(n2, new Integer(-10));
        n2 = new Integer(101);
        map.put(n2, new Integer(-37));
        n = new Integer(108);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(76);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(146);
        map.put(n2, new Integer(-37));
        n2 = new Integer(87);
        map.put(n2, new Integer(-55));
        n2 = new Integer(89);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(-30));
        n2 = new Integer(84);
        map.put(n2, new Integer(-20));
        n2 = new Integer(86);
        map.put(n2, new Integer(-55));
        n = new Integer(148);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n = new Integer(109);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(89);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-92));
        n2 = new Integer(45);
        map.put(n2, new Integer(-74));
        n2 = new Integer(105);
        map.put(n2, new Integer(-74));
        n2 = new Integer(79);
        map.put(n2, new Integer(-15));
        n2 = new Integer(58);
        map.put(n2, new Integer(-65));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(65);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-92));
        n2 = new Integer(46);
        map.put(n2, new Integer(-92));
        n2 = new Integer(101);
        map.put(n2, new Integer(-92));
        n2 = new Integer(59);
        map.put(n2, new Integer(-65));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n = new Integer(74);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(97);
        map.put(n2, new Integer(-35));
        n2 = new Integer(65);
        map.put(n2, new Integer(-40));
        n2 = new Integer(117);
        map.put(n2, new Integer(-35));
        n2 = new Integer(46);
        map.put(n2, new Integer(-25));
        n2 = new Integer(101);
        map.put(n2, new Integer(-25));
        n2 = new Integer(44);
        map.put(n2, new Integer(-25));
        n = new Integer(46);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-140));
        n2 = new Integer(146);
        map.put(n2, new Integer(-140));
        n = new Integer(110);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-40));
        familyNames = new HashSet();
        familyNames.add("Times");
    }
}

