/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphSubstitutionTable;
import org.apache.fop.complexscripts.fonts.OTFAdvancedTypographicTableReader;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.fonts.truetype.TTFMtxEntry;
import org.apache.fop.fonts.truetype.TTFOutputStream;
import org.apache.fop.fonts.truetype.TTFTableName;
import org.apache.fop.fonts.truetype.TTFTableOutputStream;
import org.apache.xmlgraphics.fonts.Glyphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TTFFile {
    static final byte NTABS = 24;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    private static final String[] MAC_GLYPH_ORDERING = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    protected FontFileReader fontFile;
    public static final boolean TRACE_ENABLED = false;
    private final String encoding = "WinAnsiEncoding";
    private final short firstChar = 0;
    private boolean useKerning = false;
    private boolean isEmbeddable = true;
    private boolean hasSerifs = true;
    protected Map<TTFTableName, TTFDirTabEntry> dirTabs;
    private Map<Integer, Map<Integer, Integer>> kerningTab;
    private Map<Integer, Map<Integer, Integer>> ansiKerningTab;
    private List<CMapSegment> cmaps;
    private Set<UnicodeMapping> unicodeMappings;
    private int upem;
    private int nhmtx;
    private PostScriptVersion postScriptVersion;
    private int locaFormat;
    protected long lastLoca = 0L;
    private int numberOfGlyphs;
    protected TTFMtxEntry[] mtxTab;
    private String postScriptName = "";
    private String fullName = "";
    private String notice = "";
    private Set<String> familyNames = new HashSet<String>();
    private String subFamilyName = "";
    private long italicAngle = 0L;
    private long isFixedPitch = 0L;
    private int fontBBox1 = 0;
    private int fontBBox2 = 0;
    private int fontBBox3 = 0;
    private int fontBBox4 = 0;
    private int capHeight = 0;
    private int os2CapHeight = 0;
    private int underlinePosition = 0;
    private int underlineThickness = 0;
    private int xHeight = 0;
    private int os2xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private int hheaAscender = 0;
    private int hheaDescender = 0;
    private int os2Ascender = 0;
    private int os2Descender = 0;
    private int usWeightClass = 0;
    private short lastChar = 0;
    private int[] ansiWidth;
    private Map<Integer, List<Integer>> ansiIndex;
    private final Map<Integer, Integer> glyphToUnicodeMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> unicodeToGlyphMap = new HashMap<Integer, Integer>();
    private TTFDirTabEntry currentDirTab;
    private boolean isCFF;
    private boolean useAdvanced = false;
    private OTFAdvancedTypographicTableReader advancedTableReader;
    protected Log log = LogFactory.getLog(TTFFile.class);

    public TTFFile() {
        this(true, false);
    }

    public TTFFile(boolean bl, boolean bl2) {
        this.useKerning = bl;
        this.useAdvanced = bl2;
    }

    public TTFDirTabEntry getDirectoryEntry(TTFTableName tTFTableName) {
        return this.dirTabs.get(tTFTableName);
    }

    public boolean seekTab(FontFileReader fontFileReader, TTFTableName tTFTableName, long l) throws IOException {
        TTFDirTabEntry tTFDirTabEntry = this.dirTabs.get(tTFTableName);
        if (tTFDirTabEntry == null) {
            this.log.error((Object)("Dirtab " + tTFTableName.getName() + " not found."));
            return false;
        }
        fontFileReader.seekSet(tTFDirTabEntry.getOffset() + l);
        this.currentDirTab = tTFDirTabEntry;
        return true;
    }

    public int convertTTFUnit2PDFUnit(int n) {
        int n2;
        if (n < 0) {
            long l = n % this.upem;
            long l2 = 1000L * l;
            long l3 = l2 != 0L ? l / l2 : 0L;
            n2 = -(-1000 * n / this.upem - (int)l3);
        } else {
            n2 = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return n2;
    }

    private boolean readCMAP() throws IOException {
        this.unicodeMappings = new TreeSet<UnicodeMapping>();
        this.seekTab(this.fontFile, TTFTableName.CMAP, 2L);
        int n = this.fontFile.readTTFUShort();
        long l = 0L;
        long l2 = 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(n + " cmap tables"));
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.fontFile.readTTFUShort();
            int n3 = this.fontFile.readTTFUShort();
            long l3 = this.fontFile.readTTFLong();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Platform ID: " + n2 + " Encoding: " + n3));
            }
            if (n2 == 3 && n3 == 1) {
                l = l3;
            }
            if (n2 != 3 || n3 != 0) continue;
            l2 = l3;
        }
        if (l > 0L) {
            return this.readUnicodeCmap(l, 1);
        }
        if (l2 > 0L) {
            return this.readUnicodeCmap(l2, 0);
        }
        this.log.fatal((Object)"Unsupported TrueType font: No Unicode or Symbol cmap table not present. Aborting");
        return false;
    }

    private boolean readUnicodeCmap(long l, int n) throws IOException {
        int n2 = 0;
        this.seekTab(this.fontFile, TTFTableName.CMAP, l);
        int n3 = this.fontFile.readTTFUShort();
        this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("CMAP format: " + n3));
        }
        if (n3 == 4) {
            int n4;
            this.fontFile.skip(2L);
            int n5 = this.fontFile.readTTFUShort();
            int n6 = this.fontFile.readTTFUShort();
            int n7 = this.fontFile.readTTFUShort();
            int n8 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("segCountX2   : " + n5));
                this.log.debug((Object)("searchRange  : " + n6));
                this.log.debug((Object)("entrySelector: " + n7));
                this.log.debug((Object)("rangeShift   : " + n8));
            }
            int[] nArray = new int[n5 / 2];
            int[] nArray2 = new int[n5 / 2];
            int[] nArray3 = new int[n5 / 2];
            int[] nArray4 = new int[n5 / 2];
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                nArray[n4] = this.fontFile.readTTFUShort();
            }
            this.fontFile.skip(2L);
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                nArray2[n4] = this.fontFile.readTTFUShort();
            }
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                nArray3[n4] = this.fontFile.readTTFShort();
            }
            for (n4 = 0; n4 < n5 / 2; ++n4) {
                nArray4[n4] = this.fontFile.readTTFUShort();
            }
            n4 = this.fontFile.getCurrentPos();
            BitSet bitSet = new BitSet(256);
            for (int i = 0; i < nArray2.length; ++i) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(i + ": " + nArray2[i] + " - " + nArray[i]));
                }
                if (this.log.isDebugEnabled() && this.isInPrivateUseArea(nArray2[i], nArray[i])) {
                    this.log.debug((Object)("Font contains glyphs in the Unicode private use area: " + Integer.toHexString(nArray2[i]) + " - " + Integer.toHexString(nArray[i])));
                }
                for (int j = nArray2[i]; j <= nArray[i]; ++j) {
                    int n9;
                    if (j < 256 && j > this.lastChar) {
                        this.lastChar = (short)j;
                    }
                    if (j < 256) {
                        bitSet.set(j);
                    }
                    if (n2 >= this.mtxTab.length) continue;
                    if (nArray4[i] != 0 && j != 65535) {
                        int n10 = n4 + (nArray4[i] / 2 + (j - nArray2[i]) + i - n5 / 2) * 2;
                        this.fontFile.seekSet(n10);
                        n9 = this.fontFile.readTTFUShort() + nArray3[i] & 0xFFFF;
                        this.unicodeMappings.add(new UnicodeMapping(n9, j));
                        this.mtxTab[n9].getUnicodeIndex().add(new Integer(j));
                        List<Integer> list = this.ansiIndex.get(new Integer(j));
                        if (list != null) {
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Integer n11 = (Integer)iterator.next();
                                this.ansiWidth[n11.intValue()] = this.mtxTab[n9].getWx();
                                if (!this.log.isTraceEnabled()) continue;
                                this.log.trace((Object)("Added width " + this.mtxTab[n9].getWx() + " uni: " + j + " ansi: " + n11));
                            }
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Idx: " + n9 + " Delta: " + nArray3[i] + " Unicode: " + j + " name: " + this.mtxTab[n9].getName()));
                        }
                    } else {
                        n9 = j + nArray3[i] & 0xFFFF;
                        if (n9 < this.mtxTab.length) {
                            this.mtxTab[n9].getUnicodeIndex().add(new Integer(j));
                        } else {
                            this.log.debug((Object)("Glyph " + n9 + " out of range: " + this.mtxTab.length));
                        }
                        this.unicodeMappings.add(new UnicodeMapping(n9, j));
                        if (n9 < this.mtxTab.length) {
                            this.mtxTab[n9].getUnicodeIndex().add(new Integer(j));
                        } else {
                            this.log.debug((Object)("Glyph " + n9 + " out of range: " + this.mtxTab.length));
                        }
                        List<Integer> list = this.ansiIndex.get(new Integer(j));
                        if (list != null) {
                            for (Integer n12 : list) {
                                this.ansiWidth[n12.intValue()] = this.mtxTab[n9].getWx();
                            }
                        }
                    }
                    if (n9 >= this.mtxTab.length || this.mtxTab[n9].getUnicodeIndex().size() >= 2) continue;
                    ++n2;
                }
            }
        } else {
            this.log.error((Object)("Cmap format not supported: " + n3));
            return false;
        }
        return true;
    }

    private boolean isInPrivateUseArea(int n, int n2) {
        return this.isInPrivateUseArea(n) || this.isInPrivateUseArea(n2);
    }

    private boolean isInPrivateUseArea(int n) {
        return n >= 57344 && n <= 63743;
    }

    private void printMaxMin() {
        int n = 255;
        int n2 = 0;
        for (int i = 0; i < this.mtxTab.length; ++i) {
            if (this.mtxTab[i].getIndex() < n) {
                n = this.mtxTab[i].getIndex();
            }
            if (this.mtxTab[i].getIndex() <= n2) continue;
            n2 = this.mtxTab[i].getIndex();
        }
        this.log.info((Object)("Min: " + n));
        this.log.info((Object)("Max: " + n2));
    }

    public void readFont(FontFileReader fontFileReader) throws IOException {
        this.readFont(fontFileReader, null);
    }

    private void initAnsiWidths() {
        int n;
        this.ansiWidth = new int[256];
        for (n = 0; n < 256; ++n) {
            this.ansiWidth[n] = this.mtxTab[0].getWx();
        }
        this.ansiIndex = new HashMap<Integer, List<Integer>>();
        for (n = 32; n < Glyphs.WINANSI_ENCODING.length; ++n) {
            Integer n2 = new Integer(n);
            Integer n3 = new Integer(Glyphs.WINANSI_ENCODING[n]);
            List<Integer> list = this.ansiIndex.get(n3);
            if (list == null) {
                list = new ArrayList<Integer>();
                this.ansiIndex.put(n3, list);
            }
            list.add(n2);
        }
    }

    public boolean readFont(FontFileReader fontFileReader, String string) throws IOException {
        this.fontFile = fontFileReader;
        if (!this.checkTTC(string)) {
            if (string == null) {
                throw new IllegalArgumentException("For TrueType collection you must specify which font to select (-ttcname)");
            }
            throw new IOException("Name does not exist in the TrueType collection: " + string);
        }
        this.readDirTabs();
        this.readFontHeader();
        this.getNumGlyphs();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Number of glyphs in font: " + this.numberOfGlyphs));
        }
        this.readHorizontalHeader();
        this.readHorizontalMetrics();
        this.initAnsiWidths();
        this.readPostScript();
        this.readOS2();
        this.determineAscDesc();
        if (!this.isCFF) {
            this.readIndexToLocation();
            this.readGlyf();
        }
        this.readName();
        boolean bl = this.readPCLT();
        boolean bl2 = this.readCMAP();
        if (!bl2) {
            return false;
        }
        this.createCMaps();
        if (this.useKerning) {
            this.readKerning();
        }
        if (this.useAdvanced) {
            try {
                OTFAdvancedTypographicTableReader oTFAdvancedTypographicTableReader = new OTFAdvancedTypographicTableReader(this, fontFileReader);
                oTFAdvancedTypographicTableReader.readAll();
                this.advancedTableReader = oTFAdvancedTypographicTableReader;
            }
            catch (AdvancedTypographicTableFormatException advancedTypographicTableFormatException) {
                this.log.warn((Object)("Encountered format constraint violation in advanced (typographic) table (AT) in font '" + this.getFullName() + "', ignoring AT data: " + advancedTypographicTableFormatException.getMessage()));
            }
        }
        this.guessVerticalMetricsFromGlyphBBox();
        return true;
    }

    public void readFont(FontFileReader fontFileReader, String string, Map<Integer, Integer> map) throws IOException {
        this.readFont(fontFileReader, string);
    }

    private void createCMaps() {
        int n;
        UnicodeMapping unicodeMapping;
        this.cmaps = new ArrayList<CMapSegment>();
        Iterator<UnicodeMapping> iterator = this.unicodeMappings.iterator();
        UnicodeMapping unicodeMapping2 = unicodeMapping = iterator.next();
        int n2 = unicodeMapping.getUnicodeIndex();
        int n3 = unicodeMapping.getGlyphIndex();
        while (iterator.hasNext()) {
            unicodeMapping = iterator.next();
            if (unicodeMapping2.getUnicodeIndex() + 1 != unicodeMapping.getUnicodeIndex() || unicodeMapping2.getGlyphIndex() + 1 != unicodeMapping.getGlyphIndex()) {
                n = unicodeMapping2.getUnicodeIndex();
                this.cmaps.add(new CMapSegment(n2, n, n3));
                n2 = unicodeMapping.getUnicodeIndex();
                n3 = unicodeMapping.getGlyphIndex();
            }
            unicodeMapping2 = unicodeMapping;
        }
        n = unicodeMapping2.getUnicodeIndex();
        this.cmaps.add(new CMapSegment(n2, n, n3));
    }

    public String getPostScriptName() {
        if (this.postScriptName.length() == 0) {
            return FontUtil.stripWhiteSpace(this.getFullName());
        }
        return this.postScriptName;
    }

    PostScriptVersion getPostScriptVersion() {
        return this.postScriptVersion;
    }

    public Set<String> getFamilyNames() {
        return this.familyNames;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getCharSetName() {
        return "WinAnsiEncoding";
    }

    public int getCapHeight() {
        return this.convertTTFUnit2PDFUnit(this.capHeight);
    }

    public int getXHeight() {
        return this.convertTTFUnit2PDFUnit(this.xHeight);
    }

    protected int getPadSize(int n) {
        int n2 = 4 - n % 4;
        return n2 < 4 ? n2 : 0;
    }

    public int getFlags() {
        int n = 32;
        if (this.italicAngle != 0L) {
            n |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            n |= 2;
        }
        if (this.hasSerifs) {
            n |= 1;
        }
        return n;
    }

    public int getWeightClass() {
        return this.usWeightClass;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String string = Short.toString((short)(this.italicAngle / 65536L));
        return string;
    }

    public int[] getFontBBox() {
        int[] nArray = new int[]{this.convertTTFUnit2PDFUnit(this.fontBBox1), this.convertTTFUnit2PDFUnit(this.fontBBox2), this.convertTTFUnit2PDFUnit(this.fontBBox3), this.convertTTFUnit2PDFUnit(this.fontBBox4)};
        return nArray;
    }

    public int getLowerCaseAscent() {
        return this.convertTTFUnit2PDFUnit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.convertTTFUnit2PDFUnit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return 0;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.mtxTab.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.convertTTFUnit2PDFUnit(this.mtxTab[i].getWx());
        }
        return nArray;
    }

    public int getCharWidth(int n) {
        return this.convertTTFUnit2PDFUnit(this.ansiWidth[n]);
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        return this.kerningTab;
    }

    public Map<Integer, Map<Integer, Integer>> getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public boolean isCFF() {
        return this.isCFF;
    }

    protected void readDirTabs() throws IOException {
        int n = this.fontFile.readTTFLong();
        switch (n) {
            case 65536: {
                this.log.debug((Object)"sfnt version: OpenType 1.0");
                break;
            }
            case 0x4F54544F: {
                this.isCFF = true;
                this.log.debug((Object)"sfnt version: OpenType with CFF data");
                break;
            }
            case 1953658213: {
                this.log.debug((Object)"sfnt version: Apple TrueType");
                break;
            }
            case 1954115633: {
                this.log.debug((Object)"sfnt version: Apple Type 1 housed in sfnt wrapper");
                break;
            }
            default: {
                this.log.debug((Object)("Unknown sfnt version: " + Integer.toHexString(n)));
            }
        }
        int n2 = this.fontFile.readTTFUShort();
        this.fontFile.skip(6L);
        this.dirTabs = new HashMap<TTFTableName, TTFDirTabEntry>();
        TTFDirTabEntry[] tTFDirTabEntryArray = new TTFDirTabEntry[n2];
        this.log.debug((Object)("Reading " + n2 + " dir tables"));
        for (int i = 0; i < n2; ++i) {
            tTFDirTabEntryArray[i] = new TTFDirTabEntry();
            String string = tTFDirTabEntryArray[i].read(this.fontFile);
            this.dirTabs.put(TTFTableName.getValue(string), tTFDirTabEntryArray[i]);
        }
        this.dirTabs.put(TTFTableName.TABLE_DIRECTORY, new TTFDirTabEntry(0L, this.fontFile.getCurrentPos()));
        this.log.debug((Object)("dir tables: " + this.dirTabs.keySet()));
    }

    protected void readFontHeader() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.HEAD, 16L);
        int n = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("flags: " + n + " - " + Integer.toString(n, 2)));
        }
        this.upem = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("unit per em: " + this.upem));
        }
        this.fontFile.skip(16L);
        this.fontBBox1 = this.fontFile.readTTFShort();
        this.fontBBox2 = this.fontFile.readTTFShort();
        this.fontBBox3 = this.fontFile.readTTFShort();
        this.fontBBox4 = this.fontFile.readTTFShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("font bbox: xMin=" + this.fontBBox1 + " yMin=" + this.fontBBox2 + " xMax=" + this.fontBBox3 + " yMax=" + this.fontBBox4));
        }
        this.fontFile.skip(6L);
        this.locaFormat = this.fontFile.readTTFShort();
    }

    protected void getNumGlyphs() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.MAXP, 4L);
        this.numberOfGlyphs = this.fontFile.readTTFUShort();
    }

    protected void readHorizontalHeader() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.HHEA, 4L);
        this.hheaAscender = this.fontFile.readTTFShort();
        this.hheaDescender = this.fontFile.readTTFShort();
        this.fontFile.skip(26L);
        this.nhmtx = this.fontFile.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("hhea.Ascender: " + this.formatUnitsForDebug(this.hheaAscender)));
            this.log.debug((Object)("hhea.Descender: " + this.formatUnitsForDebug(this.hheaDescender)));
            this.log.debug((Object)("Number of horizontal metrics: " + this.nhmtx));
        }
    }

    protected void readHorizontalMetrics() throws IOException {
        int n;
        this.seekTab(this.fontFile, TTFTableName.HMTX, 0L);
        int n2 = Math.max(this.numberOfGlyphs, this.nhmtx);
        this.mtxTab = new TTFMtxEntry[n2];
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"*** Widths array: \n");
        }
        for (n = 0; n < n2; ++n) {
            this.mtxTab[n] = new TTFMtxEntry();
        }
        for (n = 0; n < this.nhmtx; ++n) {
            this.mtxTab[n].setWx(this.fontFile.readTTFUShort());
            this.mtxTab[n].setLsb(this.fontFile.readTTFUShort());
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("   width[" + n + "] = " + this.convertTTFUnit2PDFUnit(this.mtxTab[n].getWx()) + ";"));
        }
        if (this.nhmtx < n2) {
            n = this.mtxTab[this.nhmtx - 1].getWx();
            for (int i = this.nhmtx; i < n2; ++i) {
                this.mtxTab[i].setWx(n);
                this.mtxTab[i].setLsb(this.fontFile.readTTFUShort());
            }
        }
    }

    private void readPostScript() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.POST, 0L);
        int n = this.fontFile.readTTFLong();
        this.italicAngle = this.fontFile.readTTFULong();
        this.underlinePosition = this.fontFile.readTTFShort();
        this.underlineThickness = this.fontFile.readTTFShort();
        this.isFixedPitch = this.fontFile.readTTFULong();
        this.fontFile.skip(16L);
        this.log.debug((Object)("PostScript format: 0x" + Integer.toHexString(n)));
        switch (n) {
            case 65536: {
                this.log.debug((Object)"PostScript format 1");
                this.postScriptVersion = PostScriptVersion.V1;
                for (int i = 0; i < MAC_GLYPH_ORDERING.length; ++i) {
                    this.mtxTab[i].setName(MAC_GLYPH_ORDERING[i]);
                }
                break;
            }
            case 131072: {
                int n2;
                this.log.debug((Object)"PostScript format 2");
                this.postScriptVersion = PostScriptVersion.V2;
                int n3 = 0;
                int n4 = this.fontFile.readTTFUShort();
                for (int i = 0; i < n4; ++i) {
                    this.mtxTab[i].setIndex(this.fontFile.readTTFUShort());
                    if (this.mtxTab[i].getIndex() > 257) {
                        ++n3;
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("PostScript index: " + this.mtxTab[i].getIndexAsString()));
                }
                String[] stringArray = new String[n3];
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Reading " + n3 + " glyphnames, that are not in the standard Macintosh" + " set. Total number of glyphs=" + n4));
                }
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = this.fontFile.readTTFString(this.fontFile.readTTFUByte());
                }
                for (n2 = 0; n2 < n4; ++n2) {
                    if (this.mtxTab[n2].getIndex() < MAC_GLYPH_ORDERING.length) {
                        this.mtxTab[n2].setName(MAC_GLYPH_ORDERING[this.mtxTab[n2].getIndex()]);
                        continue;
                    }
                    if (this.mtxTab[n2].isIndexReserved()) continue;
                    int n5 = this.mtxTab[n2].getIndex() - MAC_GLYPH_ORDERING.length;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)(n5 + " i=" + n2 + " mtx=" + this.mtxTab.length + " ps=" + stringArray.length));
                    }
                    this.mtxTab[n2].setName(stringArray[n5]);
                }
                break;
            }
            case 196608: {
                this.log.debug((Object)"PostScript format 3");
                this.postScriptVersion = PostScriptVersion.V3;
                break;
            }
            default: {
                this.log.error((Object)("Unknown PostScript format: " + n));
                this.postScriptVersion = PostScriptVersion.UNKNOWN;
            }
        }
    }

    private void readOS2() throws IOException {
        TTFDirTabEntry tTFDirTabEntry = this.dirTabs.get(TTFTableName.OS2);
        if (tTFDirTabEntry != null) {
            this.seekTab(this.fontFile, TTFTableName.OS2, 0L);
            int n = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("OS/2 table: version=" + n + ", offset=" + tTFDirTabEntry.getOffset() + ", len=" + tTFDirTabEntry.getLength()));
            }
            this.fontFile.skip(2L);
            this.usWeightClass = this.fontFile.readTTFUShort();
            this.fontFile.skip(2L);
            int n2 = this.fontFile.readTTFUShort();
            this.isEmbeddable = n2 != 2;
            this.fontFile.skip(22L);
            this.fontFile.skip(10L);
            this.fontFile.skip(16L);
            this.fontFile.skip(4L);
            this.fontFile.skip(6L);
            this.os2Ascender = this.fontFile.readTTFShort();
            this.os2Descender = this.fontFile.readTTFShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sTypoAscender: " + this.os2Ascender + " -> internal " + this.convertTTFUnit2PDFUnit(this.os2Ascender)));
                this.log.debug((Object)("sTypoDescender: " + this.os2Descender + " -> internal " + this.convertTTFUnit2PDFUnit(this.os2Descender)));
            }
            int n3 = this.fontFile.readTTFShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("sTypoLineGap: " + n3));
            }
            n3 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("usWinAscent: " + this.formatUnitsForDebug(n3)));
            }
            n3 = this.fontFile.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("usWinDescent: " + this.formatUnitsForDebug(n3)));
            }
            if (tTFDirTabEntry.getLength() >= 90L) {
                this.fontFile.skip(8L);
                this.os2xHeight = this.fontFile.readTTFShort();
                this.os2CapHeight = this.fontFile.readTTFShort();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("sxHeight: " + this.os2xHeight));
                    this.log.debug((Object)("sCapHeight: " + this.os2CapHeight));
                }
            }
        } else {
            this.isEmbeddable = true;
        }
    }

    protected final void readIndexToLocation() throws IOException {
        if (!this.seekTab(this.fontFile, TTFTableName.LOCA, 0L)) {
            throw new IOException("'loca' table not found, happens when the font file doesn't contain TrueType outlines (trying to read an OpenType CFF font maybe?)");
        }
        for (int i = 0; i < this.numberOfGlyphs; ++i) {
            this.mtxTab[i].setOffset(this.locaFormat == 1 ? this.fontFile.readTTFULong() : (long)(this.fontFile.readTTFUShort() << 1));
        }
        this.lastLoca = this.locaFormat == 1 ? this.fontFile.readTTFULong() : (long)(this.fontFile.readTTFUShort() << 1);
    }

    private void readGlyf() throws IOException {
        TTFDirTabEntry tTFDirTabEntry = this.dirTabs.get(TTFTableName.GLYF);
        if (tTFDirTabEntry == null) {
            throw new IOException("glyf table not found, cannot continue");
        }
        for (int i = 0; i < this.numberOfGlyphs - 1; ++i) {
            if (this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                this.fontFile.seekSet(tTFDirTabEntry.getOffset() + this.mtxTab[i].getOffset());
                this.fontFile.skip(2L);
                int[] nArray = new int[]{this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort()};
                this.mtxTab[i].setBoundingBox(nArray);
                continue;
            }
            this.mtxTab[i].setBoundingBox(this.mtxTab[0].getBoundingBox());
        }
        long l = this.dirTabs.get(TTFTableName.GLYF).getOffset();
        for (int i = 0; i < this.numberOfGlyphs; ++i) {
            if (i + 1 >= this.mtxTab.length || this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                this.fontFile.seekSet(l + this.mtxTab[i].getOffset());
                this.fontFile.skip(2L);
                int[] nArray = new int[]{this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort(), this.fontFile.readTTFShort()};
                this.mtxTab[i].setBoundingBox(nArray);
            } else {
                int n = this.mtxTab[0].getBoundingBox()[0];
                int[] nArray = new int[]{n, n, n, n};
                this.mtxTab[i].setBoundingBox(nArray);
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)this.mtxTab[i].toString(this));
        }
    }

    private void readName() throws IOException {
        this.seekTab(this.fontFile, TTFTableName.NAME, 2L);
        int n = this.fontFile.getCurrentPos();
        int n2 = this.fontFile.readTTFUShort();
        int n3 = this.fontFile.readTTFUShort() + n - 2;
        n += 4;
        while (n2-- > 0) {
            this.fontFile.seekSet(n);
            int n4 = this.fontFile.readTTFUShort();
            int n5 = this.fontFile.readTTFUShort();
            int n6 = this.fontFile.readTTFUShort();
            int n7 = this.fontFile.readTTFUShort();
            int n8 = this.fontFile.readTTFUShort();
            if (!(n4 != 1 && n4 != 3 || n5 != 0 && n5 != 1)) {
                this.fontFile.seekSet(n3 + this.fontFile.readTTFUShort());
                String string = n4 == 3 ? this.fontFile.readTTFString(n8, n5) : this.fontFile.readTTFString(n8);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(n4 + " " + n5 + " " + n6 + " " + n7 + " " + string));
                }
                switch (n7) {
                    case 0: {
                        if (this.notice.length() != 0) break;
                        this.notice = string;
                        break;
                    }
                    case 1: 
                    case 16: {
                        this.familyNames.add(string);
                        break;
                    }
                    case 2: {
                        if (this.subFamilyName.length() != 0) break;
                        this.subFamilyName = string;
                        break;
                    }
                    case 4: {
                        if (this.fullName.length() != 0 && (n4 != 3 || n6 != 1033)) break;
                        this.fullName = string;
                        break;
                    }
                    case 6: {
                        if (this.postScriptName.length() != 0) break;
                        this.postScriptName = string;
                        break;
                    }
                }
            }
            n += 12;
        }
    }

    private boolean readPCLT() throws IOException {
        TTFDirTabEntry tTFDirTabEntry = this.dirTabs.get(TTFTableName.PCLT);
        if (tTFDirTabEntry != null) {
            this.fontFile.seekSet(tTFDirTabEntry.getOffset() + 4L + 4L + 2L);
            this.xHeight = this.fontFile.readTTFUShort();
            this.log.debug((Object)("xHeight from PCLT: " + this.formatUnitsForDebug(this.xHeight)));
            this.fontFile.skip(4L);
            this.capHeight = this.fontFile.readTTFUShort();
            this.log.debug((Object)("capHeight from PCLT: " + this.formatUnitsForDebug(this.capHeight)));
            this.fontFile.skip(34L);
            int n = this.fontFile.readTTFUByte();
            n >>= 6;
            this.hasSerifs = (n &= 3) != 1;
            return true;
        }
        return false;
    }

    private void determineAscDesc() {
        int n = this.hheaAscender - this.hheaDescender;
        int n2 = this.os2Ascender - this.os2Descender;
        if (this.os2Ascender > 0 && n2 <= this.upem) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else if (this.hheaAscender > 0 && n <= this.upem) {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        } else if (this.os2Ascender > 0) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Font box height: " + (this.ascender - this.descender)));
            if (this.ascender - this.descender > this.upem) {
                this.log.debug((Object)"Ascender and descender together are larger than the em box.");
            }
        }
    }

    private void guessVerticalMetricsFromGlyphBBox() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.mtxTab.length; ++i) {
            if ("H".equals(this.mtxTab[i].getName())) {
                n = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if ("x".equals(this.mtxTab[i].getName())) {
                n2 = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if ("d".equals(this.mtxTab[i].getName())) {
                n3 = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if ("p".equals(this.mtxTab[i].getName())) {
                n4 = this.mtxTab[i].getBoundingBox()[1];
                continue;
            }
            List list = this.mtxTab[i].getUnicodeIndex();
            if (list.size() <= 0) continue;
            char c = (char)((Integer)list.get(0)).intValue();
            if (c == 'H') {
                n = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if (c == 'x') {
                n2 = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if (c == 'd') {
                n3 = this.mtxTab[i].getBoundingBox()[3];
                continue;
            }
            if (c != 'p') continue;
            n4 = this.mtxTab[i].getBoundingBox()[1];
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Ascender from glyph 'd': " + this.formatUnitsForDebug(n3)));
            this.log.debug((Object)("Descender from glyph 'p': " + this.formatUnitsForDebug(n4)));
        }
        if (this.ascender - this.descender > this.upem) {
            this.log.debug((Object)"Replacing specified ascender/descender with derived values to get values which fit in the em box.");
            this.ascender = n3;
            this.descender = n4;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("xHeight from glyph 'x': " + this.formatUnitsForDebug(n2)));
            this.log.debug((Object)("CapHeight from glyph 'H': " + this.formatUnitsForDebug(n)));
        }
        if (this.capHeight == 0) {
            this.capHeight = n;
            if (this.capHeight == 0) {
                this.capHeight = this.os2CapHeight;
            }
            if (this.capHeight == 0) {
                this.log.debug((Object)"capHeight value could not be determined. The font may not work as expected.");
            }
        }
        if (this.xHeight == 0) {
            this.xHeight = n2;
            if (this.xHeight == 0) {
                this.xHeight = this.os2xHeight;
            }
            if (this.xHeight == 0) {
                this.log.debug((Object)"xHeight value could not be determined. The font may not work as expected.");
            }
        }
    }

    private void readKerning() throws IOException {
        this.kerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        this.ansiKerningTab = new HashMap<Integer, Map<Integer, Integer>>();
        TTFDirTabEntry tTFDirTabEntry = this.dirTabs.get(TTFTableName.KERN);
        if (tTFDirTabEntry != null) {
            Object object;
            Integer n7;
            Object object2;
            this.seekTab(this.fontFile, TTFTableName.KERN, 2L);
            for (int i = this.fontFile.readTTFUShort(); i > 0; --i) {
                this.fontFile.skip(4L);
                int n2 = this.fontFile.readTTFUShort();
                if ((n2 & 1) == 0 || (n2 & 2) != 0 || (n2 & 4) != 0) {
                    return;
                }
                if (n2 >> 8 != 0) continue;
                n2 = this.fontFile.readTTFUShort();
                this.fontFile.skip(6L);
                while (n2-- > 0) {
                    int n3 = this.fontFile.readTTFUShort();
                    int n4 = this.fontFile.readTTFUShort();
                    short s = this.fontFile.readTTFShort();
                    if (s == 0) continue;
                    object2 = this.glyphToUnicode(n3);
                    n7 = this.glyphToUnicode(n4);
                    if (object2 == null) {
                        this.log.debug((Object)("Ignoring kerning pair because no Unicode index was found for the first glyph " + n3));
                        continue;
                    }
                    if (n7 == null) {
                        this.log.debug((Object)("Ignoring kerning pair because Unicode index was found for the second glyph " + n3));
                        continue;
                    }
                    object = this.kerningTab.get(object2);
                    if (object == null) {
                        object = new HashMap();
                    }
                    object.put(n7, new Integer(this.convertTTFUnit2PDFUnit(s)));
                    this.kerningTab.put((Integer)object2, (Map<Integer, Integer>)object);
                }
            }
            for (Integer n5 : this.kerningTab.keySet()) {
                Integer n6 = this.unicodeToGlyph(n5);
                HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
                Map<Integer, Integer> map = this.kerningTab.get(n5);
                for (Integer n7 : map.keySet()) {
                    object = this.unicodeToGlyph(n7);
                    Integer n8 = map.get(n7);
                    ListIterator listIterator = this.mtxTab[object.intValue()].getUnicodeIndex().listIterator();
                    while (listIterator.hasNext()) {
                        Integer n9 = (Integer)listIterator.next();
                        Integer[] integerArray = this.unicodeToWinAnsi(n9);
                        for (int i = 0; i < integerArray.length; ++i) {
                            hashMap.put(integerArray[i], n8);
                        }
                    }
                }
                if (hashMap.size() <= 0) continue;
                object2 = this.mtxTab[n6].getUnicodeIndex().listIterator();
                while (object2.hasNext()) {
                    n7 = object2.next();
                    object = this.unicodeToWinAnsi(n7);
                    for (int i = 0; i < ((Integer[])object).length; ++i) {
                        this.ansiKerningTab.put(object[i], hashMap);
                    }
                }
            }
        }
    }

    public void stream(TTFOutputStream tTFOutputStream) throws IOException {
        SortedSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortedSet = this.sortDirTabMap(this.dirTabs);
        byte[] byArray = this.fontFile.getAllBytes();
        TTFTableOutputStream tTFTableOutputStream = tTFOutputStream.getTableOutputStream();
        TTFGlyphOutputStream tTFGlyphOutputStream = tTFOutputStream.getGlyphOutputStream();
        tTFOutputStream.startFontStream();
        for (Map.Entry entry : sortedSet) {
            int n = (int)((TTFDirTabEntry)entry.getValue()).getOffset();
            int n2 = (int)((TTFDirTabEntry)entry.getValue()).getLength();
            n2 += this.getPadSize(n + n2);
            if (((TTFTableName)entry.getKey()).equals(TTFTableName.GLYF)) {
                this.streamGlyf(tTFGlyphOutputStream, byArray, n, n2);
                continue;
            }
            tTFTableOutputStream.streamTable(byArray, n, n2);
        }
        tTFOutputStream.endFontStream();
    }

    private void streamGlyf(TTFGlyphOutputStream tTFGlyphOutputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        tTFGlyphOutputStream.startGlyphStream();
        for (int i = 0; i < this.mtxTab.length - 1; ++i) {
            n3 = (int)this.mtxTab[i].getOffset() + n;
            n4 = (int)this.mtxTab[i + 1].getOffset() + n;
            tTFGlyphOutputStream.streamGlyph(byArray, n3, n4 - n3);
        }
        tTFGlyphOutputStream.streamGlyph(byArray, n4, n + n2 - n4);
        tTFGlyphOutputStream.endGlyphStream();
    }

    SortedSet<Map.Entry<TTFTableName, TTFDirTabEntry>> sortDirTabMap(Map<TTFTableName, TTFDirTabEntry> map) {
        TreeSet<Map.Entry<TTFTableName, TTFDirTabEntry>> treeSet = new TreeSet<Map.Entry<TTFTableName, TTFDirTabEntry>>(new Comparator<Map.Entry<TTFTableName, TTFDirTabEntry>>(){

            @Override
            public int compare(Map.Entry<TTFTableName, TTFDirTabEntry> entry, Map.Entry<TTFTableName, TTFDirTabEntry> entry2) {
                return (int)(entry.getValue().getOffset() - entry2.getValue().getOffset());
            }
        });
        treeSet.addAll(map.entrySet());
        return treeSet;
    }

    public List<CMapSegment> getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(String string) throws IOException {
        String string2 = this.fontFile.readTTFString(4);
        if ("ttcf".equals(string2)) {
            int n;
            this.fontFile.skip(4L);
            int n2 = (int)this.fontFile.readTTFULong();
            long[] lArray = new long[n2];
            for (n = 0; n < n2; ++n) {
                lArray[n] = this.fontFile.readTTFULong();
            }
            this.log.info((Object)("This is a TrueType collection file with " + n2 + " fonts"));
            this.log.info((Object)"Containing the following fonts: ");
            n = 0;
            long l = 0L;
            for (int i = 0; i < n2; ++i) {
                this.fontFile.seekSet(lArray[i]);
                this.readDirTabs();
                this.readName();
                if (this.fullName.equals(string)) {
                    n = 1;
                    l = lArray[i];
                    this.log.info((Object)(this.fullName + " <-- selected"));
                } else {
                    this.log.info((Object)this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            this.fontFile.seekSet(l);
            return n != 0;
        }
        this.fontFile.seekSet(0L);
        return true;
    }

    public final List<String> getTTCnames(FontFileReader fontFileReader) throws IOException {
        this.fontFile = fontFileReader;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = fontFileReader.readTTFString(4);
        if ("ttcf".equals(string)) {
            int n;
            fontFileReader.skip(4L);
            int n2 = (int)fontFileReader.readTTFULong();
            long[] lArray = new long[n2];
            for (n = 0; n < n2; ++n) {
                lArray[n] = fontFileReader.readTTFULong();
            }
            this.log.info((Object)("This is a TrueType collection file with " + n2 + " fonts"));
            this.log.info((Object)"Containing the following fonts: ");
            for (n = 0; n < n2; ++n) {
                fontFileReader.seekSet(lArray[n]);
                this.readDirTabs();
                this.readName();
                this.log.info((Object)this.fullName);
                arrayList.add(this.fullName);
                this.notice = "";
                this.fullName = "";
                this.familyNames.clear();
                this.postScriptName = "";
                this.subFamilyName = "";
            }
            fontFileReader.seekSet(0L);
            return arrayList;
        }
        this.log.error((Object)"Not a TTC!");
        return null;
    }

    private Integer[] unicodeToWinAnsi(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            if (n != Glyphs.WINANSI_ENCODING[i]) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList.toArray(new Integer[0]);
    }

    public void printStuff() {
        System.out.println("Font name:   " + this.postScriptName);
        System.out.println("Full name:   " + this.fullName);
        System.out.println("Family name: " + this.familyNames);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:      " + this.notice);
        System.out.println("xHeight:     " + this.convertTTFUnit2PDFUnit(this.xHeight));
        System.out.println("capheight:   " + this.convertTTFUnit2PDFUnit(this.capHeight));
        int n = (int)(this.italicAngle >> 16);
        System.out.println("Italic:      " + n);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.convertTTFUnit2PDFUnit(this.ascender));
        System.out.println("Descender:   " + this.convertTTFUnit2PDFUnit(this.descender));
        System.out.println("FontBBox:    [" + this.convertTTFUnit2PDFUnit(this.fontBBox1) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox2) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox3) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox4) + "]");
    }

    private String formatUnitsForDebug(int n) {
        return n + " -> " + this.convertTTFUnit2PDFUnit(n) + " internal units";
    }

    private Integer glyphToUnicode(int n) {
        return this.glyphToUnicodeMap.get(new Integer(n));
    }

    private Integer unicodeToGlyph(int n) throws IOException {
        Integer n2 = this.unicodeToGlyphMap.get(new Integer(n));
        if (n2 == null) {
            throw new IOException("Glyph index not found for unicode value " + n);
        }
        return n2;
    }

    String getGlyphName(int n) {
        return this.mtxTab[n].getName();
    }

    public boolean hasAdvancedTable() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.hasAdvancedTable();
        }
        return false;
    }

    public GlyphDefinitionTable getGDEF() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGDEF();
        }
        return null;
    }

    public GlyphSubstitutionTable getGSUB() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGSUB();
        }
        return null;
    }

    public GlyphPositioningTable getGPOS() {
        if (this.advancedTableReader != null) {
            return this.advancedTableReader.getGPOS();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = true;
            boolean bl2 = true;
            TTFFile tTFFile = new TTFFile(bl, bl2);
            FontFileReader fontFileReader = new FontFileReader(stringArray[0]);
            String string = null;
            if (stringArray.length >= 2) {
                string = stringArray[1];
            }
            tTFFile.readFont(fontFileReader, string);
            tTFFile.printStuff();
        }
        catch (IOException iOException) {
            System.err.println("Problem reading font: " + iOException.toString());
            iOException.printStackTrace(System.err);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PostScriptVersion {
        V1,
        V2,
        V3,
        UNKNOWN;

    }

    final class UnicodeMapping
    implements Comparable {
        private final int unicodeIndex;
        private final int glyphIndex;

        UnicodeMapping(int n, int n2) {
            this.unicodeIndex = n2;
            this.glyphIndex = n;
            TTFFile.this.glyphToUnicodeMap.put(new Integer(n), new Integer(n2));
            TTFFile.this.unicodeToGlyphMap.put(new Integer(n2), new Integer(n));
        }

        public int getGlyphIndex() {
            return this.glyphIndex;
        }

        public int getUnicodeIndex() {
            return this.unicodeIndex;
        }

        public int hashCode() {
            int n = this.unicodeIndex;
            n = 19 * n + (n ^ this.glyphIndex);
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof UnicodeMapping) {
                UnicodeMapping unicodeMapping = (UnicodeMapping)object;
                if (this.unicodeIndex != unicodeMapping.unicodeIndex) {
                    return false;
                }
                return this.glyphIndex == unicodeMapping.glyphIndex;
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof UnicodeMapping) {
                UnicodeMapping unicodeMapping = (UnicodeMapping)object;
                if (this.unicodeIndex > unicodeMapping.unicodeIndex) {
                    return 1;
                }
                if (this.unicodeIndex < unicodeMapping.unicodeIndex) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }
}

