/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.type1.AFMCharMetrics;
import org.apache.fop.fonts.type1.AFMFile;
import org.apache.fop.fonts.type1.AFMWritingDirectionMetrics;
import org.apache.fop.fonts.type1.CharMetricsHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AFMParser {
    private static Log log = LogFactory.getLog(AFMParser.class);
    private static final String START_FONT_METRICS = "StartFontMetrics";
    private static final String FONT_NAME = "FontName";
    private static final String FULL_NAME = "FullName";
    private static final String FAMILY_NAME = "FamilyName";
    private static final String WEIGHT = "Weight";
    private static final String FONT_BBOX = "FontBBox";
    private static final String ENCODING_SCHEME = "EncodingScheme";
    private static final String CHARACTER_SET = "CharacterSet";
    private static final String IS_BASE_FONT = "IsBaseFont";
    private static final String IS_CID_FONT = "IsCIDFont";
    private static final String CAP_HEIGHT = "CapHeight";
    private static final String X_HEIGHT = "XHeight";
    private static final String ASCENDER = "Ascender";
    private static final String DESCENDER = "Descender";
    private static final String STDHW = "StdHW";
    private static final String STDVW = "StdVW";
    private static final String UNDERLINE_POSITION = "UnderlinePosition";
    private static final String UNDERLINE_THICKNESS = "UnderlineThickness";
    private static final String ITALIC_ANGLE = "ItalicAngle";
    private static final String IS_FIXED_PITCH = "IsFixedPitch";
    private static final String START_DIRECTION = "StartDirection";
    private static final String END_DIRECTION = "EndDirection";
    private static final String START_CHAR_METRICS = "StartCharMetrics";
    private static final String END_CHAR_METRICS = "EndCharMetrics";
    private static final String C = "C";
    private static final String CH = "CH";
    private static final String WX = "WX";
    private static final String W0X = "W0X";
    private static final String W1X = "W1X";
    private static final String WY = "WY";
    private static final String W0Y = "W0Y";
    private static final String W1Y = "W1Y";
    private static final String W = "W";
    private static final String W0 = "W0";
    private static final String W1 = "W1";
    private static final String N = "N";
    private static final String B = "B";
    private static final String START_TRACK_KERN = "StartTrackKern";
    private static final String END_TRACK_KERN = "EndTrackKern";
    private static final String START_KERN_PAIRS1 = "StartKernPairs1";
    private static final String START_COMPOSITES = "StartComposites";
    private static final String START_COMP_FONT_METRICS = "StartCompFontMetrics";
    private static final String KP = "KP";
    private static final String KPH = "KPH";
    private static final String KPX = "KPX";
    private static final String KPY = "KPY";
    private static final int PARSE_NORMAL = 0;
    private static final int PARSE_CHAR_METRICS = 1;
    private static final Map<String, ValueHandler> VALUE_PARSERS = new HashMap<String, ValueHandler>();
    private static final Map<String, Integer> PARSE_MODE_CHANGES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AFMFile parse(InputStream inputStream, String string) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
        try {
            AFMFile aFMFile = this.parse(new BufferedReader(inputStreamReader), string);
            return aFMFile;
        }
        finally {
            IOUtils.closeQuietly((Reader)inputStreamReader);
        }
    }

    public AFMFile parse(BufferedReader bufferedReader, String string) throws IOException {
        String string2;
        Stack<Object> stack = new Stack<Object>();
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            Integer n2;
            String string3 = null;
            switch (n) {
                case 0: {
                    string3 = this.parseLine(string2, stack);
                    break;
                }
                case 1: {
                    string3 = this.parseCharMetrics(string2, stack, string);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid parse mode");
                }
            }
            if ((n2 = PARSE_MODE_CHANGES.get(string3)) == null) continue;
            n = n2;
        }
        return (AFMFile)stack.pop();
    }

    private String parseLine(String string, Stack<Object> stack) throws IOException {
        int n = 0;
        n = AFMParser.skipToNonWhiteSpace(string, n);
        int n2 = AFMParser.skipToWhiteSpace(string, n);
        String string2 = string.substring(n, n2);
        n = AFMParser.skipToNonWhiteSpace(string, n2);
        ValueHandler valueHandler = VALUE_PARSERS.get(string2);
        if (valueHandler != null) {
            valueHandler.parse(string, n, stack);
        }
        return string2;
    }

    private String parseCharMetrics(String string, Stack<Object> stack, String string2) throws IOException {
        String string3 = string.trim();
        if (END_CHAR_METRICS.equals(string3)) {
            return string3;
        }
        AFMFile aFMFile = (AFMFile)stack.peek();
        String string4 = aFMFile.getEncodingScheme();
        CharMetricsHandler charMetricsHandler = CharMetricsHandler.getHandler(VALUE_PARSERS, string4);
        AFMCharMetrics aFMCharMetrics = charMetricsHandler.parse(string3, stack, string2);
        aFMFile.addCharMetrics(aFMCharMetrics);
        return null;
    }

    private static int skipToNonWhiteSpace(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && AFMParser.isWhitespace(string.charAt(n2)); ++n2) {
        }
        return n2;
    }

    private static int skipToWhiteSpace(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && !AFMParser.isWhitespace(string.charAt(n2)); ++n2) {
        }
        return n2;
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    static {
        VALUE_PARSERS.put(START_FONT_METRICS, new StartFontMetrics());
        VALUE_PARSERS.put(FONT_NAME, new StringSetter(FONT_NAME));
        VALUE_PARSERS.put(FULL_NAME, new StringSetter(FULL_NAME));
        VALUE_PARSERS.put(FAMILY_NAME, new StringSetter(FAMILY_NAME));
        VALUE_PARSERS.put(WEIGHT, new StringSetter(WEIGHT));
        VALUE_PARSERS.put(ENCODING_SCHEME, new StringSetter(ENCODING_SCHEME));
        VALUE_PARSERS.put(FONT_BBOX, new FontBBox());
        VALUE_PARSERS.put(CHARACTER_SET, new StringSetter(CHARACTER_SET));
        VALUE_PARSERS.put(IS_BASE_FONT, new IsBaseFont());
        VALUE_PARSERS.put(IS_CID_FONT, new IsCIDFont());
        VALUE_PARSERS.put(CAP_HEIGHT, new NumberSetter(CAP_HEIGHT));
        VALUE_PARSERS.put(X_HEIGHT, new NumberSetter(X_HEIGHT));
        VALUE_PARSERS.put(ASCENDER, new NumberSetter(ASCENDER));
        VALUE_PARSERS.put(DESCENDER, new NumberSetter(DESCENDER));
        VALUE_PARSERS.put(STDHW, new NumberSetter(STDHW));
        VALUE_PARSERS.put(STDVW, new NumberSetter(STDVW));
        VALUE_PARSERS.put(START_DIRECTION, new StartDirection());
        VALUE_PARSERS.put(END_DIRECTION, new EndDirection());
        VALUE_PARSERS.put(UNDERLINE_POSITION, new WritingDirNumberSetter(UNDERLINE_POSITION));
        VALUE_PARSERS.put(UNDERLINE_THICKNESS, new WritingDirNumberSetter(UNDERLINE_THICKNESS));
        VALUE_PARSERS.put(ITALIC_ANGLE, new WritingDirDoubleSetter(ITALIC_ANGLE));
        VALUE_PARSERS.put(IS_FIXED_PITCH, new WritingDirBooleanSetter(IS_FIXED_PITCH));
        VALUE_PARSERS.put(C, new IntegerSetter("CharCode"));
        VALUE_PARSERS.put(CH, new NotImplementedYet(CH));
        VALUE_PARSERS.put(WX, new DoubleSetter("WidthX"));
        VALUE_PARSERS.put(W0X, new DoubleSetter("WidthX"));
        VALUE_PARSERS.put(W1X, new NotImplementedYet(W1X));
        VALUE_PARSERS.put(WY, new DoubleSetter("WidthY"));
        VALUE_PARSERS.put(W0Y, new DoubleSetter("WidthY"));
        VALUE_PARSERS.put(W1Y, new NotImplementedYet(W1Y));
        VALUE_PARSERS.put(W, new NotImplementedYet(W));
        VALUE_PARSERS.put(W0, new NotImplementedYet(W0));
        VALUE_PARSERS.put(W1, new NotImplementedYet(W1));
        VALUE_PARSERS.put(N, new NamedCharacterSetter("Character"));
        VALUE_PARSERS.put(B, new CharBBox());
        VALUE_PARSERS.put(START_TRACK_KERN, new NotImplementedYet(START_TRACK_KERN));
        VALUE_PARSERS.put(START_KERN_PAIRS1, new NotImplementedYet(START_KERN_PAIRS1));
        VALUE_PARSERS.put(START_COMPOSITES, new NotImplementedYet(START_COMPOSITES));
        VALUE_PARSERS.put(START_COMP_FONT_METRICS, new NotImplementedYet(START_COMP_FONT_METRICS));
        VALUE_PARSERS.put(KP, new NotImplementedYet(KP));
        VALUE_PARSERS.put(KPH, new NotImplementedYet(KPH));
        VALUE_PARSERS.put(KPX, new KPXHandler());
        VALUE_PARSERS.put(KPY, new NotImplementedYet(KPY));
        PARSE_MODE_CHANGES = new HashMap<String, Integer>();
        PARSE_MODE_CHANGES.put(START_CHAR_METRICS, new Integer(1));
        PARSE_MODE_CHANGES.put(END_CHAR_METRICS, new Integer(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KPXHandler
    extends AbstractValueHandler {
        private KPXHandler() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            AFMFile aFMFile = (AFMFile)stack.peek();
            int n2 = this.findValue(string, n);
            String string2 = string.substring(n, n2);
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            n2 = this.findValue(string, n);
            String string3 = string.substring(n, n2);
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            n2 = this.findValue(string, n);
            double d = Double.parseDouble(string.substring(n, n2));
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            aFMFile.addXKerning(string2, string3, d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndDirection
    extends AbstractValueHandler {
        private EndDirection() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            if (!(stack.pop() instanceof AFMWritingDirectionMetrics)) {
                throw new IOException("AFM format error: nesting incorrect");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StartDirection
    extends AbstractValueHandler {
        private StartDirection() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            int n2 = this.getIntegerValue(string, n);
            AFMWritingDirectionMetrics aFMWritingDirectionMetrics = new AFMWritingDirectionMetrics();
            AFMFile aFMFile = (AFMFile)stack.peek();
            aFMFile.setWritingDirectionMetrics(n2, aFMWritingDirectionMetrics);
            stack.push(aFMWritingDirectionMetrics);
        }
    }

    private static class NotImplementedYet
    extends AbstractValueHandler {
        private String key;

        public NotImplementedYet(String string) {
            this.key = string;
        }

        public void parse(String string, int n, Stack stack) throws IOException {
            log.warn((Object)("Support for '" + this.key + "' has not been implemented, yet!" + " Some font data in the AFM file will be ignored."));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsCIDFont
    extends AbstractValueHandler {
        private IsCIDFont() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            if (this.getBooleanValue(string, n).booleanValue()) {
                throw new IOException("CID fonts are currently not supported!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IsBaseFont
    extends AbstractValueHandler {
        private IsBaseFont() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            if (this.getBooleanValue(string, n).booleanValue()) {
                throw new IOException("Only base fonts are currently supported!");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharBBox
    extends FontBBox {
        private CharBBox() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            Rectangle rectangle = this.parseBBox(string, n);
            AFMCharMetrics aFMCharMetrics = (AFMCharMetrics)stack.peek();
            aFMCharMetrics.setBBox(rectangle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FontBBox
    extends AbstractValueHandler {
        private FontBBox() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            Rectangle rectangle = this.parseBBox(string, n);
            AFMFile aFMFile = (AFMFile)stack.peek();
            aFMFile.setFontBBox(rectangle);
        }

        protected Rectangle parseBBox(String string, int n) {
            Rectangle rectangle = new Rectangle();
            int n2 = this.findValue(string, n);
            rectangle.x = Integer.parseInt(string.substring(n, n2));
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            n2 = this.findValue(string, n);
            rectangle.y = Integer.parseInt(string.substring(n, n2));
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            n2 = this.findValue(string, n);
            int n3 = Integer.parseInt(string.substring(n, n2));
            rectangle.width = n3 - rectangle.x;
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            n2 = this.findValue(string, n);
            n3 = Integer.parseInt(string.substring(n, n2));
            rectangle.height = n3 - rectangle.y;
            n = AFMParser.skipToNonWhiteSpace(string, n2);
            return rectangle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WritingDirBooleanSetter
    extends BooleanSetter {
        public WritingDirBooleanSetter(String string) {
            super(string);
        }

        @Override
        protected Object getContextObject(Stack<Object> stack) {
            if (stack.peek() instanceof AFMWritingDirectionMetrics) {
                return (AFMWritingDirectionMetrics)stack.peek();
            }
            AFMFile aFMFile = (AFMFile)stack.peek();
            AFMWritingDirectionMetrics aFMWritingDirectionMetrics = aFMFile.getWritingDirectionMetrics(0);
            if (aFMWritingDirectionMetrics == null) {
                aFMWritingDirectionMetrics = new AFMWritingDirectionMetrics();
                aFMFile.setWritingDirectionMetrics(0, aFMWritingDirectionMetrics);
            }
            return aFMWritingDirectionMetrics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanSetter
    extends AbstractValueHandler {
        private String method;

        public BooleanSetter(String string) {
            this.method = "set" + string.substring(2);
        }

        protected Object getContextObject(Stack<Object> stack) {
            return (AFMFile)stack.peek();
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            Boolean bl = this.getBooleanValue(string, n);
            Object object = this.getContextObject(stack);
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getMethod(this.method, Boolean.TYPE);
                method.invoke(object, bl);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Bean error: " + noSuchMethodException.getMessage(), noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Bean error: " + illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Bean error: " + invocationTargetException.getMessage(), invocationTargetException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WritingDirDoubleSetter
    extends WritingDirNumberSetter {
        public WritingDirDoubleSetter(String string) {
            super(string);
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            double d = this.getDoubleValue(string, n);
            this.setValue(this.getContextObject(stack), Double.TYPE, new Double(d));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WritingDirNumberSetter
    extends NumberSetter {
        public WritingDirNumberSetter(String string) {
            super(string);
        }

        @Override
        protected Object getContextObject(Stack<Object> stack) {
            if (stack.peek() instanceof AFMWritingDirectionMetrics) {
                return (AFMWritingDirectionMetrics)stack.peek();
            }
            AFMFile aFMFile = (AFMFile)stack.peek();
            AFMWritingDirectionMetrics aFMWritingDirectionMetrics = aFMFile.getWritingDirectionMetrics(0);
            if (aFMWritingDirectionMetrics == null) {
                aFMWritingDirectionMetrics = new AFMWritingDirectionMetrics();
                aFMFile.setWritingDirectionMetrics(0, aFMWritingDirectionMetrics);
            }
            return aFMWritingDirectionMetrics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleSetter
    extends NumberSetter {
        public DoubleSetter(String string) {
            super(string);
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            double d = this.getDoubleValue(string, n);
            this.setValue(this.getContextObject(stack), Double.TYPE, new Double(d));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerSetter
    extends NumberSetter {
        public IntegerSetter(String string) {
            super(string);
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            int n2 = this.getIntegerValue(string, n);
            this.setValue(this.getContextObject(stack), Integer.TYPE, new Integer(n2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberSetter
    extends BeanSetter {
        public NumberSetter(String string) {
            super(string);
        }

        protected Object getContextObject(Stack<Object> stack) {
            return stack.peek();
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            Number number = this.getNumberValue(string, n);
            this.setValue(this.getContextObject(stack), Number.class, number);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedCharacterSetter
    extends BeanSetter {
        public NamedCharacterSetter(String string) {
            super(string);
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            NamedCharacter namedCharacter = new NamedCharacter(this.getStringValue(string, n));
            Object object = stack.peek();
            this.setValue(object, NamedCharacter.class, namedCharacter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringSetter
    extends BeanSetter {
        public StringSetter(String string) {
            super(string);
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            String string2 = this.getStringValue(string, n);
            Object object = stack.peek();
            this.setValue(object, String.class, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BeanSetter
    extends AbstractValueHandler {
        protected String method;

        public BeanSetter(String string) {
            this.method = "set" + string;
        }

        protected void setValue(Object object, Class<?> clazz, Object object2) {
            Class<?> clazz2 = object.getClass();
            try {
                Method method = clazz2.getMethod(this.method, clazz);
                method.invoke(object, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Bean error: " + noSuchMethodException.getMessage(), noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("Bean error: " + illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Bean error: " + invocationTargetException.getMessage(), invocationTargetException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StartFontMetrics
    extends AbstractValueHandler {
        private StartFontMetrics() {
        }

        @Override
        public void parse(String string, int n, Stack<Object> stack) throws IOException {
            int n2 = this.findValue(string, n);
            double d = Double.parseDouble(string.substring(n, n2));
            if (d < 2.0) {
                throw new IOException("AFM version must be at least 2.0 but it is " + d + "!");
            }
            AFMFile aFMFile = new AFMFile();
            stack.push(aFMFile);
        }
    }

    private static abstract class AbstractValueHandler
    implements ValueHandler {
        private AbstractValueHandler() {
        }

        protected int findValue(String string, int n) {
            return AFMParser.skipToWhiteSpace(string, n);
        }

        protected String getStringValue(String string, int n) {
            return string.substring(n);
        }

        protected Number getNumberValue(String string, int n) {
            try {
                return new Integer(this.getIntegerValue(string, n));
            }
            catch (NumberFormatException numberFormatException) {
                return new Double(this.getDoubleValue(string, n));
            }
        }

        protected int getIntegerValue(String string, int n) {
            int n2 = this.findValue(string, n);
            return Integer.parseInt(string.substring(n, n2));
        }

        protected double getDoubleValue(String string, int n) {
            int n2 = this.findValue(string, n);
            return Double.parseDouble(string.substring(n, n2));
        }

        protected Boolean getBooleanValue(String string, int n) {
            return Boolean.valueOf(this.getStringValue(string, n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface ValueHandler {
        public void parse(String var1, int var2, Stack<Object> var3) throws IOException;
    }
}

