/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.fop.hyphenation.ByteVector;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.PatternConsumer;
import org.apache.fop.hyphenation.PatternParser;
import org.apache.fop.hyphenation.TernaryTree;
import org.xml.sax.InputSource;

public class HyphenationTree
extends TernaryTree
implements PatternConsumer,
Serializable {
    private static final long serialVersionUID = -7842107987915665573L;
    protected ByteVector vspace;
    protected HashMap stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String string) {
        int n = string.length();
        int n2 = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int n3 = this.vspace.alloc(n2);
        byte[] byArray = this.vspace.getArray();
        for (int i = 0; i < n; ++i) {
            int n4 = i >> 1;
            byte by = (byte)(string.charAt(i) - 48 + 1 & 0xF);
            byArray[n4 + n3] = (i & 1) == 1 ? (byte)(byArray[n4 + n3] | by) : (byte)(by << 4);
        }
        byArray[n2 - 1 + n3] = 0;
        return n3;
    }

    protected String unpackValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1 + 48);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        return stringBuffer.toString();
    }

    public void loadPatterns(String string) throws HyphenationException {
        File file = new File(string);
        try {
            InputSource inputSource = new InputSource(file.toURI().toURL().toExternalForm());
            this.loadPatterns(inputSource);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HyphenationException("Error converting the File '" + file + "' to a URL: " + malformedURLException.getMessage());
        }
    }

    public void loadPatterns(InputSource inputSource) throws HyphenationException {
        PatternParser patternParser = new PatternParser(this);
        this.ivalues = new TernaryTree();
        patternParser.parse(inputSource);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String string) {
        int n = super.find(string);
        if (n >= 0) {
            return this.unpackValues(n);
        }
        return "";
    }

    protected int hstrcmp(char[] cArray, int n, char[] cArray2, int n2) {
        while (cArray[n] == cArray2[n2]) {
            if (cArray[n] == '\u0000') {
                return 0;
            }
            ++n;
            ++n2;
        }
        if (cArray2[n2] == '\u0000') {
            return 0;
        }
        return cArray[n] - cArray2[n2];
    }

    protected byte[] getValues(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = this.vspace.get(n++);
        while (by != 0) {
            char c = (char)((by >>> 4) - 1);
            stringBuffer.append(c);
            c = (char)(by & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            stringBuffer.append(c);
            by = this.vspace.get(n++);
        }
        byte[] byArray = new byte[stringBuffer.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)stringBuffer.charAt(i);
        }
        return byArray;
    }

    protected void searchPatterns(char[] cArray, int n, byte[] byArray) {
        int n2 = n;
        char c = cArray[n2];
        char c2 = this.root;
        block0: while (c2 > '\u0000' && c2 < this.sc.length) {
            int n3;
            int n4;
            byte[] byArray2;
            if (this.sc[c2] == '\uffff') {
                if (this.hstrcmp(cArray, n2, this.kv.getArray(), this.lo[c2]) == 0) {
                    byArray2 = this.getValues(this.eq[c2]);
                    n4 = n;
                    for (n3 = 0; n3 < byArray2.length; ++n3) {
                        if (n4 < byArray.length && byArray2[n3] > byArray[n4]) {
                            byArray[n4] = byArray2[n3];
                        }
                        ++n4;
                    }
                }
                return;
            }
            n4 = c - this.sc[c2];
            if (n4 == 0) {
                if (c == '\u0000') break;
                c = cArray[++n2];
                char c3 = c2 = this.eq[c2];
                while (c3 > '\u0000' && c3 < this.sc.length && this.sc[c3] != '\uffff') {
                    if (this.sc[c3] == '\u0000') {
                        byArray2 = this.getValues(this.eq[c3]);
                        n3 = n;
                        for (int i = 0; i < byArray2.length; ++i) {
                            if (n3 < byArray.length && byArray2[i] > byArray[n3]) {
                                byArray[n3] = byArray2[i];
                            }
                            ++n3;
                        }
                        continue block0;
                    }
                    c3 = this.lo[c3];
                }
                continue;
            }
            c2 = n4 < 0 ? this.lo[c2] : this.hi[c2];
        }
    }

    public Hyphenation hyphenate(String string, int n, int n2) {
        char[] cArray = string.toCharArray();
        return this.hyphenate(cArray, 0, cArray.length, n, n2);
    }

    public Hyphenation hyphenate(char[] cArray, int n, int n2, int n3, int n4) {
        Object object;
        int n5;
        char[] cArray2 = new char[n2 + 3];
        char[] cArray3 = new char[2];
        int n6 = 0;
        int n7 = n2;
        boolean bl = false;
        for (n5 = 1; n5 <= n2; ++n5) {
            cArray3[0] = cArray[n + n5 - 1];
            int n8 = this.classmap.find(cArray3, 0);
            if (n8 < 0) {
                if (n5 == 1 + n6) {
                    ++n6;
                } else {
                    bl = true;
                }
                --n7;
                continue;
            }
            if (!bl) {
                cArray2[n5 - n6] = (char)n8;
                continue;
            }
            return null;
        }
        n2 = n7;
        if (n2 < n3 + n4) {
            return null;
        }
        int[] nArray = new int[n2 + 1];
        int n9 = 0;
        String string = new String(cArray2, 1, n2);
        if (this.stoplist.containsKey(string)) {
            object = (ArrayList)this.stoplist.get(string);
            int n10 = 0;
            for (n5 = 0; n5 < ((ArrayList)object).size(); ++n5) {
                Object e = ((ArrayList)object).get(n5);
                if (!(e instanceof String) || (n10 += ((String)e).length()) < n3 || n10 >= n2 - n4) continue;
                nArray[n9++] = n10 + n6;
            }
        } else {
            cArray2[0] = 46;
            cArray2[n2 + 1] = 46;
            cArray2[n2 + 2] = '\u0000';
            object = new byte[n2 + 3];
            for (n5 = 0; n5 < n2 + 1; ++n5) {
                this.searchPatterns(cArray2, n5, (byte[])object);
            }
            for (n5 = 0; n5 < n2; ++n5) {
                if ((object[n5 + 1] & 1) != 1 || n5 < n3 || n5 > n2 - n4) continue;
                nArray[n9++] = n5 + n6;
            }
        }
        if (n9 > 0) {
            object = new int[n9];
            System.arraycopy(nArray, 0, object, 0, n9);
            return new Hyphenation(new String(cArray, n, n2), (int[])object);
        }
        return null;
    }

    public void addClass(String string) {
        if (string.length() > 0) {
            char c = string.charAt(0);
            char[] cArray = new char[2];
            cArray[1] = '\u0000';
            for (int i = 0; i < string.length(); ++i) {
                cArray[0] = string.charAt(i);
                this.classmap.insert(cArray, 0, c);
            }
        }
    }

    public void addException(String string, ArrayList arrayList) {
        this.stoplist.put(string, arrayList);
    }

    public void addPattern(String string, String string2) {
        int n = this.ivalues.find(string2);
        if (n <= 0) {
            n = this.packValues(string2);
            this.ivalues.insert(string2, (char)n);
        }
        this.insert(string, (char)n);
    }

    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Exception {
        var1_1 = null;
        var2_2 = 2;
        var3_3 = new BufferedReader(new InputStreamReader(System.in));
        while (true) lbl-1000:
        // 17 sources

        {
            System.out.print("l:\tload patterns from XML\nL:\tload patterns from serialized object\ns:\tset minimum character count\nw:\twrite hyphenation tree to object file\nh:\thyphenate\nf:\tfind pattern\nb:\tbenchmark\nq:\tquit\n\nCommand:");
            var4_4 = var3_3.readLine().trim();
            if (var4_4.equals("f")) {
                System.out.print("Pattern: ");
                var4_4 = var3_3.readLine().trim();
                System.out.println("Values: " + var1_1.findPattern(var4_4));
                continue;
            }
            if (var4_4.equals("s")) {
                System.out.print("Minimun value: ");
                var4_4 = var3_3.readLine().trim();
                var2_2 = Integer.parseInt(var4_4);
                continue;
            }
            if (var4_4.equals("l")) {
                var1_1 = new HyphenationTree();
                System.out.print("XML file name: ");
                var4_4 = var3_3.readLine().trim();
                var1_1.loadPatterns(var4_4);
                continue;
            }
            if (var4_4.equals("L")) {
                var5_5 = null;
                System.out.print("Object file name: ");
                var4_4 = var3_3.readLine().trim();
                try {
                    var5_5 = new ObjectInputStream(new FileInputStream(var4_4));
                    var1_1 = (HyphenationTree)var5_5.readObject();
                }
                catch (Exception var6_10) {
                    var6_10.printStackTrace();
                }
                finally {
                    if (var5_5 == null) ** GOTO lbl-1000
                    try {
                        var5_5.close();
                    }
                    catch (IOException var6_11) {}
                }
                continue;
            }
            if (var4_4.equals("w")) {
                System.out.print("Object file name: ");
                var4_4 = var3_3.readLine().trim();
                var5_6 = null;
                try {
                    var5_6 = new ObjectOutputStream(new FileOutputStream(var4_4));
                    var5_6.writeObject(var1_1);
                }
                catch (Exception var6_14) {
                    var6_14.printStackTrace();
                }
                finally {
                    if (var5_6 == null) ** GOTO lbl-1000
                    try {
                        var5_6.flush();
                    }
                    catch (IOException var6_15) {}
                    try {
                        var5_6.close();
                    }
                    catch (IOException var6_16) {}
                }
                continue;
            }
            if (var4_4.equals("h")) {
                System.out.print("Word: ");
                var4_4 = var3_3.readLine().trim();
                System.out.print("Hyphenation points: ");
                System.out.println(var1_1.hyphenate(var4_4, var2_2, var2_2));
                continue;
            }
            if (var4_4.equals("b")) {
                if (var1_1 == null) {
                    System.out.println("No patterns have been loaded.");
                    break;
                }
                System.out.print("Word list filename: ");
                var4_4 = var3_3.readLine().trim();
                var5_7 = 0L;
                var7_17 = 0;
                try {
                    var8_21 = new BufferedReader(new FileReader(var4_4));
                    var5_7 = System.currentTimeMillis();
                    while ((var9_23 = var8_21.readLine()) != null) {
                        var10_29 = var1_1.hyphenate(var9_23, var2_2, var2_2);
                        if (var10_29 != null) {
                            var11_30 = var10_29.toString();
                        }
                        ++var7_17;
                    }
                }
                catch (Exception var8_22) {
                    System.out.println("Exception " + var8_22);
                    var8_22.printStackTrace();
                }
                var8_19 = System.currentTimeMillis();
                var10_25 = var8_19 - var5_7;
                System.out.println(var7_17 + " words in " + var10_25 + " Milliseconds hyphenated");
                continue;
            }
            if (var4_4.equals("q")) ** break;
        }
    }
}

