/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.xml.sax.InputSource;

public final class Hyphenator {
    protected static final Log log = LogFactory.getLog(Hyphenator.class);
    private static HyphenationTreeCache hTreeCache = null;
    private static boolean statisticsDump = false;

    private Hyphenator() {
    }

    public static synchronized HyphenationTreeCache getHyphenationTreeCache() {
        if (hTreeCache == null) {
            hTreeCache = new HyphenationTreeCache();
        }
        return hTreeCache;
    }

    public static HyphenationTree getHyphenationTree(String string, String string2, HyphenationTreeResolver hyphenationTreeResolver, Map map) {
        String string3;
        String string4 = HyphenationTreeCache.constructLlccKey(string, string2);
        HyphenationTreeCache hyphenationTreeCache = Hyphenator.getHyphenationTreeCache();
        if (hyphenationTreeCache.isMissing(string4)) {
            return null;
        }
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree2(string, string2, hyphenationTreeResolver, map);
        if (hyphenationTree == null && string2 != null && !string2.equals("none") && !hyphenationTreeCache.isMissing(string3 = HyphenationTreeCache.constructLlccKey(string, null))) {
            hyphenationTree = Hyphenator.getHyphenationTree2(string, null, hyphenationTreeResolver, map);
            if (hyphenationTree != null && log.isDebugEnabled()) {
                log.debug((Object)("Couldn't find hyphenation pattern for lang=\"" + string + "\",country=\"" + string2 + "\"." + " Using general language pattern " + "for lang=\"" + string + "\" instead."));
            }
            if (hyphenationTree == null) {
                hyphenationTreeCache.noteMissing(string3);
            } else {
                hyphenationTreeCache.cache(string4, hyphenationTree);
            }
        }
        if (hyphenationTree == null) {
            hyphenationTreeCache.noteMissing(string4);
            log.error((Object)("Couldn't find hyphenation pattern for lang=\"" + string + "\"" + (string2 != null && !string2.equals("none") ? ",country=\"" + string2 + "\"" : "") + "."));
        }
        return hyphenationTree;
    }

    private static HyphenationTree getHyphenationTree2(String string, String string2, HyphenationTreeResolver hyphenationTreeResolver, Map map) {
        String string3 = HyphenationTreeCache.constructLlccKey(string, string2);
        HyphenationTreeCache hyphenationTreeCache = Hyphenator.getHyphenationTreeCache();
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTreeCache().getHyphenationTree(string, string2);
        if (hyphenationTree != null) {
            return hyphenationTree;
        }
        String string4 = HyphenationTreeCache.constructUserKey(string, string2, map);
        if (string4 == null) {
            string4 = string3;
        }
        if (hyphenationTreeResolver != null) {
            hyphenationTree = Hyphenator.getUserHyphenationTree(string4, hyphenationTreeResolver);
        }
        if (hyphenationTree == null) {
            hyphenationTree = Hyphenator.getFopHyphenationTree(string4);
        }
        if (hyphenationTree != null) {
            hyphenationTreeCache.cache(string3, hyphenationTree);
        }
        return hyphenationTree;
    }

    private static InputStream getResourceStream(String string) {
        InputStream inputStream = null;
        try {
            Method method = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            if (method != null) {
                ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                inputStream = classLoader.getResourceAsStream("hyph/" + string + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = Hyphenator.class.getResourceAsStream("/hyph/" + string + ".hyp");
        }
        return inputStream;
    }

    private static HyphenationTree readHyphenationTree(InputStream inputStream) {
        HyphenationTree hyphenationTree = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            hyphenationTree = (HyphenationTree)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            log.error((Object)"I/O error while loading precompiled hyphenation pattern file", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.error((Object)"Error while reading hyphenation object from file", (Throwable)classNotFoundException);
        }
        return hyphenationTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getFopHyphenationTree(String string) {
        HyphenationTree hyphenationTree = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream2 = Hyphenator.getResourceStream(string);
            if (inputStream2 == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Couldn't find precompiled hyphenation pattern " + string + " in resources"));
                }
                HyphenationTree hyphenationTree2 = null;
                return hyphenationTree2;
            }
            hyphenationTree = Hyphenator.readHyphenationTree(inputStream2);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return hyphenationTree;
    }

    public static HyphenationTree getUserHyphenationTree(String string, String string2) {
        final File file = new File(string2);
        HyphenationTreeResolver hyphenationTreeResolver = new HyphenationTreeResolver(){

            public Source resolve(String string) {
                File file2 = new File(file, string);
                return new StreamSource(file2);
            }
        };
        return Hyphenator.getUserHyphenationTree(string, hyphenationTreeResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getUserHyphenationTree(String string, HyphenationTreeResolver hyphenationTreeResolver) {
        Source source;
        String string2;
        HyphenationTree hyphenationTree;
        block26: {
            hyphenationTree = null;
            string2 = string + ".hyp";
            source = hyphenationTreeResolver.resolve(string2);
            if (source != null) {
                try {
                    InputStream inputStream = null;
                    if (source instanceof StreamSource) {
                        inputStream = ((StreamSource)source).getInputStream();
                    }
                    if (inputStream == null) {
                        if (source.getSystemId() != null) {
                            inputStream = new URL(source.getSystemId()).openStream();
                        } else {
                            throw new UnsupportedOperationException("Cannot load hyphenation pattern file with the supplied Source object: " + source);
                        }
                    }
                    inputStream = new BufferedInputStream(inputStream);
                    try {
                        hyphenationTree = Hyphenator.readHyphenationTree(inputStream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                    return hyphenationTree;
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block26;
                    log.debug((Object)("I/O problem while trying to load " + string2), (Throwable)iOException);
                }
            }
        }
        if ((source = hyphenationTreeResolver.resolve(string2 = string + ".xml")) != null) {
            hyphenationTree = new HyphenationTree();
            try {
                InputStream inputStream = null;
                if (source instanceof StreamSource) {
                    inputStream = ((StreamSource)source).getInputStream();
                }
                if (inputStream == null) {
                    if (source.getSystemId() != null) {
                        inputStream = new URL(source.getSystemId()).openStream();
                    } else {
                        throw new UnsupportedOperationException("Cannot load hyphenation pattern file with the supplied Source object: " + source);
                    }
                }
                if (!(inputStream instanceof BufferedInputStream)) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                try {
                    InputSource inputSource = new InputSource(inputStream);
                    inputSource.setSystemId(source.getSystemId());
                    hyphenationTree.loadPatterns(inputSource);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                if (statisticsDump) {
                    System.out.println("Stats: ");
                    hyphenationTree.printStats();
                }
                return hyphenationTree;
            }
            catch (HyphenationException hyphenationException) {
                log.error((Object)("Can't load user patterns from XML file " + source.getSystemId() + ": " + hyphenationException.getMessage()));
                return null;
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("I/O problem while trying to load " + string2), (Throwable)iOException);
                }
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Could not load user hyphenation file for '" + string + "'."));
        }
        return null;
    }

    public static Hyphenation hyphenate(String string, String string2, HyphenationTreeResolver hyphenationTreeResolver, Map map, String string3, int n, int n2) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2, hyphenationTreeResolver, map);
        if (hyphenationTree == null) {
            return null;
        }
        return hyphenationTree.hyphenate(string3, n, n2);
    }
}

