/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.hyphenation.Hyphen;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.PatternConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PatternParser
extends DefaultHandler
implements PatternConsumer {
    private XMLReader parser;
    private int currElement;
    private PatternConsumer consumer;
    private StringBuffer token;
    private ArrayList exception;
    private char hyphenChar;
    private String errMsg;
    private boolean hasClasses = false;
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;
    private PrintStream testOut = System.out;

    public PatternParser() throws HyphenationException {
        this.consumer = this;
        this.token = new StringBuffer();
        this.parser = PatternParser.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        this.hyphenChar = (char)45;
    }

    public PatternParser(PatternConsumer patternConsumer) throws HyphenationException {
        this();
        this.consumer = patternConsumer;
    }

    public void parse(String string) throws HyphenationException {
        this.parse(new File(string));
    }

    public void parse(File file) throws HyphenationException {
        try {
            InputSource inputSource = new InputSource(file.toURI().toURL().toExternalForm());
            this.parse(inputSource);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HyphenationException("Error converting the File '" + file + "' to a URL: " + malformedURLException.getMessage());
        }
    }

    public void parse(InputSource inputSource) throws HyphenationException {
        try {
            this.parser.parse(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HyphenationException("File not found: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new HyphenationException(iOException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new HyphenationException(this.errMsg);
        }
    }

    static XMLReader createParser() {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            return sAXParserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new RuntimeException("Couldn't create XMLReader: " + exception.getMessage());
        }
    }

    private String readToken(StringBuffer stringBuffer) {
        int n;
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < stringBuffer.length() && Character.isWhitespace(stringBuffer.charAt(n2)); ++n2) {
            bl = true;
        }
        if (bl) {
            for (n = n2; n < stringBuffer.length(); ++n) {
                stringBuffer.setCharAt(n - n2, stringBuffer.charAt(n));
            }
            stringBuffer.setLength(stringBuffer.length() - n2);
            if (this.token.length() > 0) {
                String string = this.token.toString();
                this.token.setLength(0);
                return string;
            }
        }
        bl = false;
        for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
            if (!Character.isWhitespace(stringBuffer.charAt(n2))) continue;
            bl = true;
            break;
        }
        this.token.append(stringBuffer.toString().substring(0, n2));
        for (n = n2; n < stringBuffer.length(); ++n) {
            stringBuffer.setCharAt(n - n2, stringBuffer.charAt(n));
        }
        stringBuffer.setLength(stringBuffer.length() - n2);
        if (bl) {
            String string = this.token.toString();
            this.token.setLength(0);
            return string;
        }
        this.token.append(stringBuffer);
        return null;
    }

    private static String getPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private ArrayList normalizeException(ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof String) {
                String string = (String)e;
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < string.length(); ++j) {
                    char c = string.charAt(j);
                    if (c != this.hyphenChar) {
                        stringBuffer.append(c);
                        continue;
                    }
                    arrayList2.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    char[] cArray = new char[]{this.hyphenChar};
                    arrayList2.add(new Hyphen(new String(cArray), null, null));
                }
                if (stringBuffer.length() <= 0) continue;
                arrayList2.add(stringBuffer.toString());
                continue;
            }
            arrayList2.add(e);
        }
        return arrayList2;
    }

    private String getExceptionWord(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof String) {
                stringBuffer.append((String)e);
                continue;
            }
            if (((Hyphen)e).noBreak == null) continue;
            stringBuffer.append(((Hyphen)e).noBreak);
        }
        return stringBuffer.toString();
    }

    private static String getInterletterValues(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string + "a";
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
                ++i;
                continue;
            }
            stringBuffer.append('0');
        }
        return stringBuffer.toString();
    }

    protected void getExternalClasses() throws SAXException {
        XMLReader xMLReader = this.parser;
        this.parser = PatternParser.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        InputStream inputStream = this.getClass().getResourceAsStream("classes.xml");
        InputSource inputSource = new InputSource(inputStream);
        try {
            this.parser.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.getMessage());
        }
        finally {
            this.parser = xMLReader;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equals("hyphen-char")) {
            String string4 = attributes.getValue("value");
            if (string4 != null && string4.length() == 1) {
                this.hyphenChar = string4.charAt(0);
            }
        } else if (string2.equals("classes")) {
            this.currElement = 1;
        } else if (string2.equals("patterns")) {
            if (!this.hasClasses) {
                this.getExternalClasses();
            }
            this.currElement = 3;
        } else if (string2.equals("exceptions")) {
            if (!this.hasClasses) {
                this.getExternalClasses();
            }
            this.currElement = 2;
            this.exception = new ArrayList();
        } else if (string2.equals("hyphen")) {
            if (this.token.length() > 0) {
                this.exception.add(this.token.toString());
            }
            this.exception.add(new Hyphen(attributes.getValue("pre"), attributes.getValue("no"), attributes.getValue("post")));
            this.currElement = 4;
        }
        this.token.setLength(0);
    }

    public void endElement(String string, String string2, String string3) {
        if (this.token.length() > 0) {
            String string4 = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(string4);
                    break;
                }
                case 2: {
                    this.exception.add(string4);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(string4), PatternParser.getInterletterValues(string4));
                    break;
                }
                case 4: {
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        if (this.currElement == 1) {
            this.hasClasses = true;
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    public void characters(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append(cArray, n, n2);
        String string = this.readToken(stringBuffer);
        while (string != null) {
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(string);
                    break;
                }
                case 2: {
                    this.exception.add(string);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    this.exception.clear();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(string), PatternParser.getInterletterValues(string));
                    break;
                }
            }
            string = this.readToken(stringBuffer);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.errMsg = "[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
    }

    public void error(SAXParseException sAXParseException) {
        this.errMsg = "[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.errMsg = "[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage();
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public void addClass(String string) {
        this.testOut.println("class: " + string);
    }

    public void addException(String string, ArrayList arrayList) {
        this.testOut.println("exception: " + string + " : " + arrayList.toString());
    }

    public void addPattern(String string, String string2) {
        this.testOut.println("pattern: " + string + " : " + string2);
    }

    public void setTestOut(PrintStream printStream) {
        this.testOut = printStream;
    }

    public void closeTestOut() {
        this.testOut.flush();
        this.testOut.close();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            PatternParser patternParser = new PatternParser();
            PrintStream printStream = null;
            if (stringArray.length > 1) {
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
                printStream = new PrintStream((OutputStream)fileOutputStream, false, "utf-8");
                patternParser.setTestOut(printStream);
            }
            patternParser.parse(stringArray[0]);
            if (patternParser != null) {
                patternParser.closeTestOut();
            }
        }
    }
}

