/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.ImageWMF;
import org.apache.fop.util.UnclosableInputStream;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderWMF
extends AbstractImagePreloader {
    private static Log log = LogFactory.getLog(PreloaderWMF.class);
    private boolean batikAvailable = true;

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException {
        if (!ImageUtil.hasInputStream((Source)source)) {
            return null;
        }
        ImageInfo imageInfo = null;
        if (this.batikAvailable) {
            try {
                Loader loader = new Loader();
                imageInfo = loader.getImage(string, source, imageContext);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)noClassDefFoundError);
                return null;
            }
        }
        if (imageInfo != null) {
            ImageUtil.closeQuietly((Source)source);
        }
        return imageInfo;
    }

    private final class Loader {
        private Loader() {
        }

        private ImageInfo getImage(String string, Source source, ImageContext imageContext) {
            UnclosableInputStream unclosableInputStream = new UnclosableInputStream(ImageUtil.needInputStream((Source)source));
            try {
                ((InputStream)unclosableInputStream).mark(5);
                DataInputStream dataInputStream = new DataInputStream(unclosableInputStream);
                int n = EndianUtils.swapInteger((int)dataInputStream.readInt());
                dataInputStream.reset();
                if (n != -1698247209) {
                    return null;
                }
                WMFRecordStore wMFRecordStore = new WMFRecordStore();
                wMFRecordStore.read(dataInputStream);
                IOUtils.closeQuietly((InputStream)dataInputStream);
                int n2 = wMFRecordStore.getWidthUnits();
                int n3 = wMFRecordStore.getHeightUnits();
                int n4 = wMFRecordStore.getMetaFileUnitsPerInch();
                ImageInfo imageInfo = new ImageInfo(string, "image/x-wmf");
                ImageSize imageSize = new ImageSize();
                imageSize.setSizeInPixels(n2, n3);
                imageSize.setResolution((double)n4);
                imageSize.calcSizeFromPixels();
                imageInfo.setSize(imageSize);
                ImageWMF imageWMF = new ImageWMF(imageInfo, wMFRecordStore);
                imageInfo.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, imageWMF);
                return imageInfo;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                try {
                    ((InputStream)unclosableInputStream).reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                PreloaderWMF.this.batikAvailable = false;
                log.warn((Object)"Batik not in class path", (Throwable)noClassDefFoundError);
                return null;
            }
            catch (IOException iOException) {
                log.debug((Object)("Error while trying to load stream as an WMF file: " + iOException.getMessage()));
                try {
                    ((InputStream)unclosableInputStream).reset();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return null;
            }
        }
    }
}

