/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Position;

public abstract class AbstractBaseLayoutManager
implements LayoutManager,
PercentBaseContext {
    protected boolean generatesReferenceArea = false;
    protected boolean generatesBlockArea = false;
    protected final FObj fobj;
    private static final Log LOG = LogFactory.getLog(AbstractBaseLayoutManager.class);

    public AbstractBaseLayoutManager() {
        this.fobj = null;
    }

    public AbstractBaseLayoutManager(FObj fObj) {
        this.fobj = fObj;
        this.setGeneratesReferenceArea(fObj.generatesReferenceAreas());
        if (this.getGeneratesReferenceArea()) {
            this.setGeneratesBlockArea(true);
        }
    }

    public int getBaseLength(int n, FObj fObj) {
        LayoutManager layoutManager;
        if (fObj == this.fobj) {
            switch (n) {
                case 5: {
                    return this.getAncestorBlockAreaIPD();
                }
                case 6: {
                    return this.getAncestorBlockAreaBPD();
                }
                case 3: {
                    return this.getParentAreaIPD();
                }
                case 4: {
                    return this.getReferenceAreaIPD();
                }
            }
            LOG.error((Object)("Unknown base type for LengthBase:" + n));
            return 0;
        }
        for (layoutManager = this.getParent(); layoutManager != null && fObj != layoutManager.getFObj(); layoutManager = layoutManager.getParent()) {
        }
        if (layoutManager != null) {
            return layoutManager.getBaseLength(n, fObj);
        }
        LOG.error((Object)("Cannot find LM to handle given FO for LengthBase. (" + fObj.getContextInfo() + ")"));
        return 0;
    }

    protected int getAncestorBlockAreaIPD() {
        for (LayoutManager layoutManager = this.getParent(); layoutManager != null; layoutManager = layoutManager.getParent()) {
            if (!layoutManager.getGeneratesBlockArea() || layoutManager.getGeneratesLineArea()) continue;
            return layoutManager.getContentAreaIPD();
        }
        LOG.error((Object)"No parent LM found");
        return 0;
    }

    protected int getAncestorBlockAreaBPD() {
        for (LayoutManager layoutManager = this.getParent(); layoutManager != null; layoutManager = layoutManager.getParent()) {
            if (!layoutManager.getGeneratesBlockArea() || layoutManager.getGeneratesLineArea()) continue;
            return layoutManager.getContentAreaBPD();
        }
        LOG.error((Object)"No parent LM found");
        return 0;
    }

    protected int getParentAreaIPD() {
        LayoutManager layoutManager = this.getParent();
        if (layoutManager != null) {
            return layoutManager.getContentAreaIPD();
        }
        LOG.error((Object)"No parent LM found");
        return 0;
    }

    protected int getParentAreaBPD() {
        LayoutManager layoutManager = this.getParent();
        if (layoutManager != null) {
            return layoutManager.getContentAreaBPD();
        }
        LOG.error((Object)"No parent LM found");
        return 0;
    }

    public int getReferenceAreaIPD() {
        for (LayoutManager layoutManager = this.getParent(); layoutManager != null; layoutManager = layoutManager.getParent()) {
            if (!layoutManager.getGeneratesReferenceArea()) continue;
            return layoutManager.getContentAreaIPD();
        }
        LOG.error((Object)"No parent LM found");
        return 0;
    }

    protected int getReferenceAreaBPD() {
        for (LayoutManager layoutManager = this.getParent(); layoutManager != null; layoutManager = layoutManager.getParent()) {
            if (!layoutManager.getGeneratesReferenceArea()) continue;
            return layoutManager.getContentAreaBPD();
        }
        LOG.error((Object)"No parent LM found");
        return 0;
    }

    public int getContentAreaIPD() {
        throw new UnsupportedOperationException("getContentAreaIPD() called when it should have been overridden");
    }

    public int getContentAreaBPD() {
        throw new UnsupportedOperationException("getContentAreaBPD() called when it should have been overridden");
    }

    public boolean getGeneratesReferenceArea() {
        return this.generatesReferenceArea;
    }

    protected void setGeneratesReferenceArea(boolean bl) {
        this.generatesReferenceArea = bl;
    }

    public boolean getGeneratesBlockArea() {
        return this.generatesBlockArea;
    }

    protected void setGeneratesBlockArea(boolean bl) {
        this.generatesBlockArea = bl;
    }

    public boolean getGeneratesLineArea() {
        return false;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    public void reset() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRestartable() {
        return false;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n, Stack stack, Position position, LayoutManager layoutManager) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

