/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.traits.MinOptMax;

public class KnuthGlue
extends KnuthElement {
    private final int stretch;
    private final int shrink;
    private final Adjustment adjustmentClass;

    public KnuthGlue(MinOptMax minOptMax, Position position, boolean bl) {
        super(minOptMax.getOpt(), position, bl);
        this.stretch = minOptMax.getStretch();
        this.shrink = minOptMax.getShrink();
        this.adjustmentClass = Adjustment.NO_ADJUSTMENT;
    }

    public KnuthGlue(int n, int n2, int n3, Position position, boolean bl) {
        super(n, position, bl);
        this.stretch = n2;
        this.shrink = n3;
        this.adjustmentClass = Adjustment.NO_ADJUSTMENT;
    }

    public KnuthGlue(int n, int n2, int n3, Adjustment adjustment, Position position, boolean bl) {
        super(n, position, bl);
        this.stretch = n2;
        this.shrink = n3;
        this.adjustmentClass = adjustment;
    }

    public boolean isGlue() {
        return true;
    }

    public int getStretch() {
        return this.stretch;
    }

    public int getShrink() {
        return this.shrink;
    }

    public Adjustment getAdjustmentClass() {
        return this.adjustmentClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.isAuxiliary()) {
            stringBuffer.append("aux. ");
        }
        stringBuffer.append("glue");
        stringBuffer.append(" w=").append(this.getWidth());
        stringBuffer.append(" stretch=").append(this.getStretch());
        stringBuffer.append(" shrink=").append(this.getShrink());
        if (!this.getAdjustmentClass().equals(Adjustment.NO_ADJUSTMENT)) {
            stringBuffer.append(" adj-class=").append(this.getAdjustmentClass());
        }
        return stringBuffer.toString();
    }
}

