/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.RegionReference;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.inline.TextLayoutManager;

public class StaticContentLayoutManager
extends BlockStackingLayoutManager {
    private RegionReference targetRegion;
    private Block targetBlock;
    private SideRegion regionFO;
    private int contentAreaIPD = 0;
    private int contentAreaBPD = -1;

    public StaticContentLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, StaticContent staticContent, SideRegion sideRegion) {
        super(staticContent);
        this.setParent(pageSequenceLayoutManager);
        this.regionFO = sideRegion;
        this.targetRegion = this.getCurrentPV().getRegionReference(this.regionFO.getNameId());
    }

    public StaticContentLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, StaticContent staticContent, Block block) {
        super(staticContent);
        this.setParent(pageSequenceLayoutManager);
        this.targetBlock = block;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        throw new IllegalStateException();
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        AreaAdditionUtil.addAreas(this, positionIterator, layoutContext);
        this.flush();
        this.targetRegion = null;
    }

    public void addChildArea(Area area) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            this.targetBlock.addBlock((Block)area);
        } else {
            this.targetRegion.addBlock((Block)area);
        }
    }

    public Area getParentArea(Area area) {
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            return this.targetBlock;
        }
        return this.targetRegion;
    }

    public void doLayout() {
        int n = 0;
        int n2 = 0;
        int n3 = 9;
        boolean bl = false;
        if (this.getStaticContentFO().getFlowName().equals("xsl-footnote-separator")) {
            n = this.targetBlock.getIPD();
            n2 = this.targetBlock.getBPD();
            if (n2 == 0) {
                bl = true;
            }
            n3 = 13;
        } else {
            n = this.targetRegion.getIPD();
            n2 = this.targetRegion.getBPD();
            n3 = this.regionFO.getDisplayAlign();
        }
        this.setContentAreaIPD(n);
        this.setContentAreaBPD(n2);
        StaticContentBreaker staticContentBreaker = new StaticContentBreaker(this, n, n3);
        staticContentBreaker.doLayout(n2, bl);
        if (staticContentBreaker.isOverflow() && !bl) {
            String string = this.getPSLM().getCurrentPage().getPageViewport().getPageNumberString();
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getStaticContentFO().getUserAgent().getEventBroadcaster());
            boolean bl2 = this.regionFO.getOverflow() != 42;
            boolean bl3 = this.regionFO.getOverflow() == 57 || this.regionFO.getOverflow() == 42;
            blockLevelEventProducer.regionOverflow(this, this.regionFO.getName(), string, staticContentBreaker.getOverflowAmount(), bl3, bl2, this.getStaticContentFO().getLocator());
        }
    }

    protected StaticContent getStaticContentFO() {
        return (StaticContent)this.fobj;
    }

    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    protected void setContentAreaIPD(int n) {
        this.contentAreaIPD = n;
    }

    public int getContentAreaBPD() {
        return this.contentAreaBPD;
    }

    private void setContentAreaBPD(int n) {
        this.contentAreaBPD = n;
    }

    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    private class StaticContentBreaker
    extends AbstractBreaker {
        private StaticContentLayoutManager lm;
        private int displayAlign;
        private int ipd;
        private int overflow = 0;

        public StaticContentBreaker(StaticContentLayoutManager staticContentLayoutManager2, int n, int n2) {
            this.lm = staticContentLayoutManager2;
            this.ipd = n;
            this.displayAlign = n2;
        }

        protected void observeElementList(List list) {
            String string = StaticContentLayoutManager.this.getStaticContentFO().getFlowName();
            String string2 = ((PageSequence)this.lm.getParent().getFObj()).getId();
            if (string2 != null && string2.length() > 0) {
                string = string + "-" + string2;
            }
            ElementListObserver.observe(list, "static-content", string);
        }

        protected boolean isPartOverflowRecoveryActivated() {
            return false;
        }

        public boolean isOverflow() {
            return this.overflow != 0;
        }

        public int getOverflowAmount() {
            return this.overflow;
        }

        protected PageBreakingAlgorithm.PageBreakingLayoutListener createLayoutListener() {
            return new PageBreakingAlgorithm.PageBreakingLayoutListener(){

                public void notifyOverflow(int n, int n2, FObj fObj) {
                    if (StaticContentBreaker.this.overflow == 0) {
                        StaticContentBreaker.this.overflow = n2;
                    }
                }
            };
        }

        protected LayoutManager getTopLevelLM() {
            return this.lm;
        }

        protected LayoutContext createLayoutContext() {
            LayoutContext layoutContext = super.createLayoutContext();
            layoutContext.setRefIPD(this.ipd);
            return layoutContext;
        }

        protected List getNextKnuthElements(LayoutContext layoutContext, int n) {
            LayoutManager layoutManager;
            LinkedList linkedList = new LinkedList();
            while ((layoutManager = StaticContentLayoutManager.this.getChildLM()) != null) {
                LayoutContext layoutContext2 = new LayoutContext(0);
                layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
                layoutContext2.setRefIPD(layoutContext.getRefIPD());
                layoutContext2.setWritingMode(layoutContext.getWritingMode());
                List list = null;
                boolean bl = layoutManager instanceof TextLayoutManager;
                if (!layoutManager.isFinished()) {
                    list = layoutManager.getNextKnuthElements(layoutContext2, n);
                }
                if (list == null || bl) continue;
                this.lm.wrapPositionElements(list, linkedList);
            }
            SpaceResolver.resolveElementList(linkedList);
            StaticContentLayoutManager.this.setFinished(true);
            return linkedList;
        }

        protected int getCurrentDisplayAlign() {
            return this.displayAlign;
        }

        protected boolean hasMoreContent() {
            return !this.lm.isFinished();
        }

        protected void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
            AreaAdditionUtil.addAreas(this.lm, positionIterator, layoutContext);
        }

        protected void doPhase3(PageBreakingAlgorithm pageBreakingAlgorithm, int n, AbstractBreaker.BlockSequence blockSequence, AbstractBreaker.BlockSequence blockSequence2) {
            if (n > 1) {
                AbstractBreaker.PageBreakPosition pageBreakPosition = pageBreakingAlgorithm.getPageBreaks().getFirst();
                int n2 = ElementListUtils.calcContentLength(blockSequence2, blockSequence2.ignoreAtStart, pageBreakPosition.getLeafPos());
                this.overflow += pageBreakingAlgorithm.totalWidth - n2;
            }
            pageBreakingAlgorithm.removeAllPageBreaks();
            this.addAreas(pageBreakingAlgorithm, 1, blockSequence, blockSequence2);
        }

        protected void finishPart(PageBreakingAlgorithm pageBreakingAlgorithm, AbstractBreaker.PageBreakPosition pageBreakPosition) {
        }

        protected LayoutManager getCurrentChildLM() {
            return null;
        }
    }
}

