/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.Resolvable;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.AbstractPageNumberCitation;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public abstract class AbstractPageNumberCitationLayoutManager
extends LeafNodeLayoutManager {
    protected AbstractPageNumberCitation fobj;
    protected Font font;
    protected boolean resolved = false;

    public AbstractPageNumberCitationLayoutManager(AbstractPageNumberCitation abstractPageNumberCitation) {
        super(abstractPageNumberCitation);
        this.fobj = abstractPageNumberCitation;
    }

    public void initialize() {
        FontInfo fontInfo = this.fobj.getFOEventHandler().getFontInfo();
        FontTriplet[] fontTripletArray = this.fobj.getCommonFont().getFontState(fontInfo);
        this.font = fontInfo.getFontInstance(fontTripletArray[0], this.fobj.getCommonFont().fontSize.getValue(this));
        this.setCommonBorderPaddingBackground(this.fobj.getCommonBorderPaddingBackground());
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        return new AlignmentContext(this.font, this.fobj.getLineHeight().getOptimum(this).getLength().getValue(this), this.fobj.getAlignmentAdjust(), this.fobj.getAlignmentBaseline(), this.fobj.getBaselineShift(), this.fobj.getDominantBaseline(), layoutContext.getAlignmentContext());
    }

    public abstract InlineArea get(LayoutContext var1);

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        super.addAreas(positionIterator, layoutContext);
        if (!this.resolved) {
            this.getPSLM().addUnresolvedArea(this.fobj.getRefId(), (Resolvable)((Object)this.curArea));
        }
    }

    protected void updateTextAreaTraits(TextArea textArea) {
        TraitSetter.setProducerID(textArea, this.fobj.getId());
        textArea.setBPD(this.font.getAscender() - this.font.getDescender());
        textArea.setBaselineOffset(this.font.getAscender());
        TraitSetter.addFontTraits(textArea, this.font);
        textArea.addTrait(Trait.COLOR, this.fobj.getColor());
        TraitSetter.addStructureTreeElement(textArea, this.fobj.getStructureTreeElement());
        TraitSetter.addTextDecoration(textArea, this.fobj.getTextDecoration());
    }

    protected int getStringWidth(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += this.font.getCharWidth(string.charAt(i));
        }
        return n;
    }

    protected int getBidiLevel() {
        return this.fobj.getBidiLevel();
    }
}

