/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.Hyphenator;
import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelEventProducer;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LineLayoutPossibilities;
import org.apache.fop.traits.MinOptMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineLayoutManager
extends InlineStackingLayoutManager
implements BlockLevelLayoutManager {
    public static final int DEFAULT_SPACE_WIDTH = 3336;
    private static Log log = LogFactory.getLog(LineLayoutManager.class);
    private final Block fobj;
    private boolean isFirstInBlock;
    private int bidiLevel = -1;
    private int textAlignment = 70;
    private int textAlignmentLast;
    private int effectiveAlignment;
    private Length textIndent;
    private Length lastLineEndIndent;
    private CommonHyphenation hyphenationProperties;
    private Numeric hyphenationLadderCount;
    private int wrapOption = 161;
    private int whiteSpaceTreament;
    private final Length lineHeight;
    private final int lead;
    private final int follow;
    private AlignmentContext alignmentContext;
    private List<KnuthSequence> knuthParagraphs;
    private LineLayoutPossibilities lineLayouts;
    private LineLayoutPossibilities[] lineLayoutsList;
    private int ipd = 0;
    private boolean hyphenationPerformed;
    private int constantLineHeight = 12000;

    public LineLayoutManager(Block block, Length length, int n, int n2) {
        super(block);
        this.fobj = block;
        this.fobjIter = null;
        this.lineHeight = length;
        this.lead = n;
        this.follow = n2;
    }

    @Override
    public void initialize() {
        this.bidiLevel = this.fobj.getBidiLevel();
        this.textAlignment = this.fobj.getTextAlign();
        this.textAlignmentLast = this.fobj.getTextAlignLast();
        this.textIndent = this.fobj.getTextIndent();
        this.lastLineEndIndent = this.fobj.getLastLineEndIndent();
        this.hyphenationProperties = this.fobj.getCommonHyphenation();
        this.hyphenationLadderCount = this.fobj.getHyphenationLadderCount();
        this.wrapOption = this.fobj.getWrapOption();
        this.whiteSpaceTreament = this.fobj.getWhitespaceTreatment();
        this.effectiveAlignment = this.getEffectiveAlignment(this.textAlignment, this.textAlignmentLast);
        this.isFirstInBlock = this == this.getParent().getChildLMs().get(0);
    }

    private int getEffectiveAlignment(int n, int n2) {
        if (this.textAlignment != 70 && this.textAlignmentLast == 70) {
            return 0;
        }
        return this.textAlignment;
    }

    @Override
    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        if (this.alignmentContext == null) {
            FontInfo fontInfo = this.fobj.getFOEventHandler().getFontInfo();
            FontTriplet[] fontTripletArray = this.fobj.getCommonFont().getFontState(fontInfo);
            Font font = fontInfo.getFontInstance(fontTripletArray[0], this.fobj.getCommonFont().fontSize.getValue(this));
            this.alignmentContext = new AlignmentContext(font, this.lineHeight.getValue(this), layoutContext.getWritingMode());
        }
        layoutContext.setAlignmentContext(this.alignmentContext);
        this.ipd = layoutContext.getRefIPD();
        if (this.knuthParagraphs == null) {
            this.knuthParagraphs = new ArrayList<KnuthSequence>();
            this.collectInlineKnuthElements(layoutContext);
        }
        if (this.knuthParagraphs.size() == 0) {
            this.setFinished(true);
            return null;
        }
        return this.createLineBreaks(layoutContext.getBPAlignment(), layoutContext);
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n, LeafPosition leafPosition) {
        log.trace((Object)("Restarting line breaking from index " + leafPosition.getIndex()));
        int n2 = leafPosition.getLeafPos();
        KnuthSequence knuthSequence = this.knuthParagraphs.get(n2);
        knuthSequence.subList(0, leafPosition.getIndex() + 1).clear();
        Iterator iterator = knuthSequence.iterator();
        while (iterator.hasNext() && !((KnuthElement)iterator.next()).isBox()) {
            iterator.remove();
        }
        if (!iterator.hasNext()) {
            this.knuthParagraphs.remove(n2);
        }
        if (this.knuthParagraphs.size() == 0) {
            this.setFinished(true);
            return null;
        }
        this.ipd = layoutContext.getRefIPD();
        return this.createLineBreaks(layoutContext.getBPAlignment(), layoutContext);
    }

    private void collectInlineKnuthElements(LayoutContext layoutContext) {
        InlineLevelLayoutManager inlineLevelLayoutManager;
        LayoutContext layoutContext2 = new LayoutContext(layoutContext);
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("LineLM:");
        Paragraph paragraph = null;
        while ((inlineLevelLayoutManager = (InlineLevelLayoutManager)this.getChildLM()) != null) {
            Object object;
            Object object2;
            List list = inlineLevelLayoutManager.getNextKnuthElements(layoutContext2, this.effectiveAlignment);
            if (list == null || list.size() == 0) continue;
            if (paragraph != null) {
                object2 = (KnuthSequence)list.get(0);
                if (!((KnuthSequence)object2).isInlineSequence()) {
                    paragraph.endParagraph();
                    ElementListObserver.observe(paragraph, "line", null);
                    paragraph = null;
                    if (log.isTraceEnabled()) {
                        stringBuffer.append(" ]");
                    }
                    bl = false;
                }
                if (paragraph != null && ((ListElement)(object = (KnuthElement)((ArrayList)object2).get(0))).isBox() && !((KnuthElement)object).isAuxiliary() && bl) {
                    paragraph.addALetterSpace();
                }
            }
            object2 = list.listIterator();
            while (object2.hasNext()) {
                object = (KnuthSequence)object2.next();
                if (((KnuthSequence)object).isInlineSequence()) {
                    ListElement listElement = ((KnuthSequence)object).getLast();
                    assert (listElement != null);
                    boolean bl2 = bl = listElement.isBox() && !((KnuthElement)listElement).isAuxiliary() && ((KnuthElement)listElement).getWidth() != 0;
                    if (paragraph == null) {
                        paragraph = new Paragraph(this, this.textAlignment, this.textAlignmentLast, this.textIndent.getValue(this), this.lastLineEndIndent.getValue(this));
                        paragraph.startSequence();
                        if (log.isTraceEnabled()) {
                            stringBuffer.append(" [");
                        }
                    } else if (log.isTraceEnabled()) {
                        stringBuffer.append(" +");
                    }
                    paragraph.addAll(object);
                    if (log.isTraceEnabled()) {
                        stringBuffer.append(" I");
                    }
                    if (!listElement.isPenalty() || ((KnuthPenalty)listElement).getPenalty() != -1000) continue;
                    paragraph.removeLast();
                    if (!paragraph.containsBox()) {
                        paragraph.add(new KnuthGlue(this.ipd, 0, this.ipd, null, true));
                    }
                    paragraph.endParagraph();
                    ElementListObserver.observe(paragraph, "line", null);
                    paragraph = null;
                    if (log.isTraceEnabled()) {
                        stringBuffer.append(" ]");
                    }
                    bl = false;
                    continue;
                }
                this.knuthParagraphs.add((KnuthSequence)object);
                if (!log.isTraceEnabled()) continue;
                stringBuffer.append(" B");
            }
        }
        if (paragraph != null) {
            paragraph.endParagraph();
            ElementListObserver.observe(paragraph, "line", this.fobj.getId());
            if (log.isTraceEnabled()) {
                stringBuffer.append(" ]");
            }
        }
        log.trace((Object)stringBuffer);
    }

    private List<ListElement> createLineBreaks(int n, LayoutContext layoutContext) {
        Iterator<KnuthSequence> iterator = this.knuthParagraphs.iterator();
        this.lineLayoutsList = new LineLayoutPossibilities[this.knuthParagraphs.size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            KnuthSequence knuthSequence = iterator.next();
            LineLayoutPossibilities lineLayoutPossibilities = !knuthSequence.isInlineSequence() ? new LineLayoutPossibilities() : this.findOptimalBreakingPoints(n, (Paragraph)knuthSequence, !iterator.hasNext());
            this.lineLayoutsList[n2] = lineLayoutPossibilities;
            ++n2;
        }
        this.setFinished(true);
        return this.postProcessLineBreaks(n, layoutContext);
    }

    private LineLayoutPossibilities findOptimalBreakingPoints(int n, Paragraph paragraph, boolean bl) {
        int n2;
        int n3;
        boolean bl2;
        this.lineLayouts = new LineLayoutPossibilities();
        double d = 1.0;
        LineBreakingAlgorithm lineBreakingAlgorithm = new LineBreakingAlgorithm(n, this.textAlignment, this.textAlignmentLast, this.textIndent.getValue(this), paragraph.lineFiller.getOpt(), this.lineHeight.getValue(this), this.lead, this.follow, this.knuthParagraphs.indexOf(paragraph) == 0, this.hyphenationLadderCount.getEnum() == 89 ? 0 : this.hyphenationLadderCount.getValue(), this);
        lineBreakingAlgorithm.setConstantLineWidth(this.ipd);
        boolean bl3 = this.wrapOption != 93;
        boolean bl4 = bl2 = bl3 && this.hyphenationProperties.hyphenate.getEnum() == 149;
        if (bl2 && !this.hyphenationPerformed) {
            this.hyphenationPerformed = bl;
            this.findHyphenationPoints(paragraph);
        }
        if ((n3 = lineBreakingAlgorithm.findBreakingPoints(paragraph, d, false, n2 = bl3 ? 1 : 2)) == 0 || n == 70) {
            if (n3 > 0) {
                lineBreakingAlgorithm.resetAlgorithm();
                this.lineLayouts.savePossibilities(false);
            } else {
                log.debug((Object)("No set of breaking points found with maxAdjustment = " + d));
            }
            log.debug((Object)("Hyphenation possible? " + bl2));
            if (bl2 && n2 != 2) {
                n2 = 0;
            } else {
                d = 5.0;
            }
            n3 = lineBreakingAlgorithm.findBreakingPoints(paragraph, d, false, n2);
            if (n3 == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No set of breaking points found with maxAdjustment = " + d + (bl2 ? " and hyphenation" : "")));
                }
                d = 20.0;
                lineBreakingAlgorithm.findBreakingPoints(paragraph, d, true, n2);
            }
            this.lineLayouts.restorePossibilities();
        }
        return this.lineLayouts;
    }

    private List<ListElement> postProcessLineBreaks(int n, LayoutContext layoutContext) {
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        int n2 = -1;
        for (int i = 0; i < this.knuthParagraphs.size(); ++i) {
            Object object;
            Object object2;
            if (i > 0) {
                object2 = this.getKeepTogether();
                linkedList.add(new BreakElement(new Position(this), ((Keep)object2).getPenalty(), ((Keep)object2).getContext(), layoutContext));
            }
            object2 = this.lineLayoutsList[i];
            KnuthSequence knuthSequence = this.knuthParagraphs.get(i);
            if (!knuthSequence.isInlineSequence()) {
                LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
                ListIterator listIterator = knuthSequence.listIterator();
                while (listIterator.hasNext()) {
                    object = (ListElement)listIterator.next();
                    if (((ListElement)object).getLayoutManager() != this) {
                        ((ListElement)object).setPosition(this.notifyPos(new NonLeafPosition((LayoutManager)this, ((ListElement)object).getPosition())));
                    }
                    linkedList2.add((ListElement)object);
                }
                linkedList.addAll(linkedList2);
                continue;
            }
            if (knuthSequence.isInlineSequence() && n == 70) {
                LeafPosition leafPosition = new LeafPosition(this, i);
                this.createElements(linkedList, (LineLayoutPossibilities)object2, leafPosition);
                continue;
            }
            int n3 = 0;
            for (int j = 0; j < ((LineLayoutPossibilities)object2).getChosenLineCount(); ++j) {
                Object object3;
                if (linkedList.size() > 0 && j > 0 && j >= this.fobj.getOrphans() && j <= ((LineLayoutPossibilities)object2).getChosenLineCount() - this.fobj.getWidows()) {
                    object = this.getKeepTogether();
                    linkedList.add(new BreakElement(new LeafPosition(this, i, n2), ((Keep)object).getPenalty(), ((Keep)object).getContext(), layoutContext));
                }
                n2 = ((LineBreakPosition)((LineLayoutPossibilities)object2).getChosenPosition(j)).getLeafPos();
                object = new LinkedList();
                ListIterator listIterator = knuthSequence.listIterator(n3);
                while (listIterator.nextIndex() <= n2) {
                    object3 = (KnuthElement)listIterator.next();
                    if (object3 instanceof KnuthInlineBox && ((KnuthInlineBox)object3).isAnchor()) {
                        object.add(((KnuthInlineBox)object3).getFootnoteBodyLM());
                        continue;
                    }
                    if (!(object3 instanceof KnuthBlockBox)) continue;
                    object.addAll(((KnuthBlockBox)object3).getFootnoteBodyLMs());
                }
                n3 = n2 + 1;
                object3 = (LineBreakPosition)((LineLayoutPossibilities)object2).getChosenPosition(j);
                linkedList.add(new KnuthBlockBox(((LineBreakPosition)object3).lineHeight + ((LineBreakPosition)object3).spaceBefore + ((LineBreakPosition)object3).spaceAfter, (List)object, (Position)object3, false));
            }
        }
        return linkedList;
    }

    private void createElements(List<ListElement> list, LineLayoutPossibilities lineLayoutPossibilities, Position position) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.fobj.getOrphans();
        int n8 = this.fobj.getWidows();
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayoutPossibilities.getMinLineCount()) {
            n2 = lineLayoutPossibilities.getMinLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            n3 = lineLayoutPossibilities.getMaxLineCount() - lineLayoutPossibilities.getOptLineCount();
            n5 = lineLayoutPossibilities.getOptLineCount() - lineLayoutPossibilities.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayoutPossibilities.getOptLineCount()) {
            n3 = lineLayoutPossibilities.getMaxLineCount() - lineLayoutPossibilities.getOptLineCount();
            n5 = lineLayoutPossibilities.getOptLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            n6 = this.fobj.getOrphans() + this.fobj.getWidows() - lineLayoutPossibilities.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayoutPossibilities.getMaxLineCount()) {
            n3 = lineLayoutPossibilities.getMaxLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            n4 = this.fobj.getOrphans() + this.fobj.getWidows() - lineLayoutPossibilities.getOptLineCount();
            n6 = lineLayoutPossibilities.getOptLineCount() - lineLayoutPossibilities.getMinLineCount();
            n7 -= n4;
        } else {
            n4 = lineLayoutPossibilities.getMaxLineCount() - lineLayoutPossibilities.getOptLineCount();
            n6 = lineLayoutPossibilities.getOptLineCount() - lineLayoutPossibilities.getMinLineCount();
            n7 = lineLayoutPossibilities.getOptLineCount();
            n8 = 0;
        }
        if (n8 != 0 && (n4 > 0 || n6 > 0)) {
            linkedList.add(new KnuthPenalty(0, 1000, false, position, false));
            linkedList.add(new KnuthGlue(0, -n4 * this.constantLineHeight, -n6 * this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            linkedList.add(new KnuthPenalty(n4 * this.constantLineHeight, 0, false, position, false));
            linkedList.add(new KnuthGlue(0, n4 * this.constantLineHeight, n6 * this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
        } else if (n8 != 0) {
            linkedList.add(new KnuthPenalty(0, 0, false, position, false));
        }
        list.add(new KnuthBox(n7 * this.constantLineHeight, position, n8 == 0 && n4 == 0 && n6 == 0));
        if (n4 > 0 || n6 > 0) {
            list.add(new KnuthPenalty(0, 1000, false, position, false));
            list.add(new KnuthGlue(0, n4 * this.constantLineHeight, n6 * this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            list.add(new KnuthBox(0, position, n8 == 0));
        }
        for (n = 0; n < n3; ++n) {
            list.addAll(linkedList);
            list.add(new KnuthBox(0, position, false));
            list.add(new KnuthPenalty(0, 1000, false, position, false));
            list.add(new KnuthGlue(0, this.constantLineHeight, 0, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            list.add(new KnuthBox(0, position, false));
        }
        for (n = 0; n < n5; ++n) {
            list.addAll(linkedList);
            list.add(new KnuthBox(this.constantLineHeight, position, false));
            list.add(new KnuthPenalty(0, 1000, false, position, false));
            list.add(new KnuthGlue(0, 0, this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            list.add(new KnuthBox(0, position, false));
        }
        for (n = 0; n < n2; ++n) {
            list.addAll(linkedList);
            list.add(new KnuthBox(this.constantLineHeight, position, false));
        }
        if (n8 > 0) {
            list.addAll(linkedList);
            list.add(new KnuthBox(n8 * this.constantLineHeight, position, true));
        }
    }

    @Override
    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
    }

    @Override
    public KeepProperty getKeepTogetherProperty() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepTogetherProperty();
    }

    @Override
    public KeepProperty getKeepWithPreviousProperty() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepWithPreviousProperty();
    }

    @Override
    public KeepProperty getKeepWithNextProperty() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepWithNextProperty();
    }

    @Override
    public Keep getKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepTogether();
    }

    @Override
    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().isAuto();
    }

    @Override
    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().isAuto();
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public int negotiateBPDAdjustment(int n, KnuthElement knuthElement) {
        LeafPosition leafPosition = (LeafPosition)knuthElement.getPosition();
        int n2 = (int)Math.round((double)n / (double)this.constantLineHeight + (n > 0 ? -0.4 : 0.4));
        LineLayoutPossibilities lineLayoutPossibilities = this.lineLayoutsList[leafPosition.getLeafPos()];
        n2 = lineLayoutPossibilities.applyLineCountAdjustment(n2);
        return n2 * this.constantLineHeight;
    }

    @Override
    public void discardSpace(KnuthGlue knuthGlue) {
    }

    @Override
    public List getChangedKnuthElements(List list, int n, int n2) {
        return this.getChangedKnuthElements(list, n);
    }

    @Override
    public List getChangedKnuthElements(List list, int n) {
        LinkedList<KnuthElement> linkedList = new LinkedList<KnuthElement>();
        for (int i = 0; i < this.knuthParagraphs.size(); ++i) {
            LineLayoutPossibilities lineLayoutPossibilities = this.lineLayoutsList[i];
            for (int j = 0; j < lineLayoutPossibilities.getChosenLineCount(); ++j) {
                if (!((BlockLevelLayoutManager)this.parentLayoutManager).mustKeepTogether() && j >= this.fobj.getOrphans() && j <= lineLayoutPossibilities.getChosenLineCount() - this.fobj.getWidows()) {
                    linkedList.add(new KnuthPenalty(0, 0, false, new Position(this), false));
                }
                LineBreakPosition lineBreakPosition = (LineBreakPosition)lineLayoutPossibilities.getChosenPosition(j);
                MinOptMax minOptMax = n == 70 ? MinOptMax.getInstance(lineBreakPosition.lineWidth - lineBreakPosition.difference - lineBreakPosition.availableShrink, lineBreakPosition.lineWidth - lineBreakPosition.difference, lineBreakPosition.lineWidth - lineBreakPosition.difference + lineBreakPosition.availableStretch) : (n == 23 ? MinOptMax.getInstance(lineBreakPosition.lineWidth - 2 * lineBreakPosition.startIndent) : (n == 39 ? MinOptMax.getInstance(lineBreakPosition.lineWidth - lineBreakPosition.startIndent) : MinOptMax.getInstance(lineBreakPosition.lineWidth - lineBreakPosition.difference + lineBreakPosition.startIndent)));
                linkedList.add(new KnuthBlockBox(lineBreakPosition.lineHeight, minOptMax, lineBreakPosition.ipdAdjust != 0.0 ? lineBreakPosition.lineWidth - lineBreakPosition.difference : 0, lineBreakPosition, false));
            }
        }
        return linkedList;
    }

    private void findHyphenationPoints(Paragraph paragraph) {
        ListIterator listIterator = paragraph.listIterator(paragraph.ignoreAtStart);
        LinkedList<Update> linkedList = new LinkedList<Update>();
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        while (listIterator.hasNext()) {
            int n;
            HyphContext hyphContext;
            KnuthElement knuthElement = (KnuthElement)listIterator.next();
            if (knuthElement.getLayoutManager() != inlineLevelLayoutManager) {
                inlineLevelLayoutManager = (InlineLevelLayoutManager)knuthElement.getLayoutManager();
                if (inlineLevelLayoutManager == null) break;
                linkedList.add(new Update(inlineLevelLayoutManager, listIterator.previousIndex()));
            } else if (inlineLevelLayoutManager == null) break;
            if (!knuthElement.isBox() || knuthElement.isAuxiliary()) continue;
            int n2 = 1;
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(inlineLevelLayoutManager.getWordChars(knuthElement.getPosition()));
            while (listIterator.hasNext()) {
                KnuthElement knuthElement2 = (KnuthElement)listIterator.next();
                if (knuthElement2.isBox() && !knuthElement2.isAuxiliary()) {
                    if (inlineLevelLayoutManager != knuthElement2.getLayoutManager()) {
                        inlineLevelLayoutManager = (InlineLevelLayoutManager)knuthElement2.getLayoutManager();
                        linkedList.add(new Update(inlineLevelLayoutManager, listIterator.previousIndex()));
                    }
                    ++n2;
                    stringBuffer.append(inlineLevelLayoutManager.getWordChars(knuthElement2.getPosition()));
                    continue;
                }
                if (!knuthElement2.isAuxiliary()) {
                    listIterator.previous();
                    break;
                }
                if (inlineLevelLayoutManager != knuthElement2.getLayoutManager()) {
                    inlineLevelLayoutManager = (InlineLevelLayoutManager)knuthElement2.getLayoutManager();
                    linkedList.add(new Update(inlineLevelLayoutManager, listIterator.previousIndex()));
                }
                ++n3;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(" Word to hyphenate: " + stringBuffer.toString()));
            }
            if ((hyphContext = this.getHyphenContext(stringBuffer)) == null) continue;
            KnuthElement knuthElement3 = null;
            for (n = 0; n < n2 + n3; ++n) {
                listIterator.previous();
            }
            for (n = 0; n < n2 + n3; ++n) {
                knuthElement3 = (KnuthElement)listIterator.next();
                if (!knuthElement3.isBox() || knuthElement3.isAuxiliary()) continue;
                ((InlineLevelLayoutManager)knuthElement3.getLayoutManager()).hyphenate(knuthElement3.getPosition(), hyphContext);
            }
        }
        this.processUpdates(paragraph, linkedList);
    }

    private void processUpdates(Paragraph paragraph, List list) {
        ListIterator listIterator = list.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            int n2;
            Object object;
            Update update = (Update)listIterator.next();
            int n3 = update.firstIndex;
            if (listIterator.hasNext()) {
                object = (Update)listIterator.next();
                n2 = ((Update)object).firstIndex;
                listIterator.previous();
            } else {
                n2 = paragraph.size() - paragraph.ignoreAtEnd - n;
            }
            if (!update.inlineLM.applyChanges(paragraph.subList(n3 + n, n2 + n))) continue;
            object = update.inlineLM.getChangedKnuthElements(paragraph.subList(n3 + n, n2 + n), this.effectiveAlignment);
            paragraph.subList(n3 + n, n2 + n).clear();
            paragraph.addAll(n3 + n, object);
            n += object.size() - (n2 - n3);
        }
        list.clear();
    }

    @Override
    protected boolean hasLeadingFence(boolean bl) {
        return true;
    }

    @Override
    protected boolean hasTrailingFence(boolean bl) {
        return true;
    }

    private HyphContext getHyphenContext(StringBuffer stringBuffer) {
        Hyphenation hyphenation = Hyphenator.hyphenate(this.hyphenationProperties.language.getString(), this.hyphenationProperties.country.getString(), this.getFObj().getUserAgent().getFactory().getHyphenationTreeResolver(), this.getFObj().getUserAgent().getFactory().getHyphPatNames(), stringBuffer.toString(), this.hyphenationProperties.hyphenationRemainCharacterCount.getValue(), this.hyphenationProperties.hyphenationPushCharacterCount.getValue());
        if (hyphenation != null) {
            return new HyphContext(hyphenation.getHyphenationPoints());
        }
        return null;
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        while (positionIterator.hasNext()) {
            boolean bl;
            Position position = positionIterator.next();
            boolean bl2 = bl = !positionIterator.hasNext();
            if (position instanceof LineBreakPosition) {
                this.addInlineArea(layoutContext, (LineBreakPosition)position, bl);
                continue;
            }
            if (!(position instanceof NonLeafPosition) || !position.generatesAreas()) continue;
            this.addBlockArea(layoutContext, position, bl);
        }
        this.setCurrentArea(null);
    }

    private void addInlineArea(LayoutContext layoutContext, LineBreakPosition lineBreakPosition, boolean bl) {
        LayoutManager layoutManager;
        ListIterator listIterator;
        KnuthSequence knuthSequence = this.knuthParagraphs.get(lineBreakPosition.parIndex);
        int n = lineBreakPosition.startIndex;
        int n2 = lineBreakPosition.getLeafPos();
        LineArea lineArea = new LineArea(lineBreakPosition.getLeafPos() < knuthSequence.size() - 1 ? this.textAlignment : this.textAlignmentLast, lineBreakPosition.difference, lineBreakPosition.availableStretch, lineBreakPosition.availableShrink);
        if (lineBreakPosition.startIndent != 0) {
            lineArea.addTrait(Trait.START_INDENT, lineBreakPosition.startIndent);
        }
        if (lineBreakPosition.endIndent != 0) {
            lineArea.addTrait(Trait.END_INDENT, new Integer(lineBreakPosition.endIndent));
        }
        lineArea.setBPD(lineBreakPosition.lineHeight);
        lineArea.setIPD(lineBreakPosition.lineWidth);
        lineArea.setBidiLevel(this.bidiLevel);
        lineArea.addTrait(Trait.SPACE_BEFORE, lineBreakPosition.spaceBefore);
        lineArea.addTrait(Trait.SPACE_AFTER, lineBreakPosition.spaceAfter);
        this.alignmentContext.resizeLine(lineBreakPosition.lineHeight, lineBreakPosition.baseline);
        if (knuthSequence instanceof Paragraph) {
            listIterator = (Paragraph)knuthSequence;
            n += n == 0 ? ((Paragraph)((Object)listIterator)).ignoreAtStart : 0;
            if (n2 == ((ArrayList)((Object)listIterator)).size() - 1) {
                n2 -= ((Paragraph)((Object)listIterator)).ignoreAtEnd;
                lineArea.setIPD(lineArea.getIPD() - this.lastLineEndIndent.getValue(this));
            }
        }
        listIterator = knuthSequence.listIterator(n2);
        KnuthElement knuthElement = (KnuthElement)listIterator.next();
        LayoutManager layoutManager2 = knuthElement.getLayoutManager();
        if (knuthElement.isGlue() && (this.whiteSpaceTreament == 63 || this.whiteSpaceTreament == 60 || this.whiteSpaceTreament == 62)) {
            --n2;
            listIterator.previous();
            if (listIterator.hasPrevious()) {
                layoutManager2 = ((KnuthElement)listIterator.previous()).getLayoutManager();
            }
        }
        if (this.whiteSpaceTreament == 63 || this.whiteSpaceTreament == 60 || this.whiteSpaceTreament == 61) {
            listIterator = knuthSequence.listIterator(n);
            while (listIterator.hasNext() && !((KnuthElement)listIterator.next()).isBox()) {
                ++n;
            }
        }
        KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter(knuthSequence, n, n2 + 1);
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setAlignmentContext(this.alignmentContext);
        layoutContext2.setSpaceAdjust(lineBreakPosition.dAdjust);
        layoutContext2.setIPDAdjust(lineBreakPosition.ipdAdjust);
        layoutContext2.setLeadingSpace(new SpaceSpecifier(true));
        layoutContext2.setTrailingSpace(new SpaceSpecifier(false));
        layoutContext2.setFlags(256, true);
        this.setCurrentArea(lineArea);
        this.setChildContext(layoutContext2);
        while ((layoutManager = knuthPossPosIter.getNextChildLM()) != null) {
            layoutContext2.setFlags(128, layoutManager == layoutManager2);
            layoutManager.addAreas(knuthPossPosIter, layoutContext2);
            layoutContext2.setLeadingSpace(layoutContext2.getTrailingSpace());
            layoutContext2.setTrailingSpace(new SpaceSpecifier(false));
        }
        if (!(layoutContext.getSpaceAfter() <= 0 || layoutContext.isLastArea() && bl)) {
            lineArea.setBPD(lineArea.getBPD() + layoutContext.getSpaceAfter());
        }
        lineArea.finish();
        if (lineArea.getBidiLevel() >= 0) {
            BidiResolver.reorder(lineArea);
        }
        this.parentLayoutManager.addChildArea(lineArea);
    }

    private void addBlockArea(LayoutContext layoutContext, Position position, boolean bl) {
        LayoutManager layoutManager;
        ArrayList<Position> arrayList = new ArrayList<Position>(1);
        Position position2 = position.getPosition();
        arrayList.add(position2);
        LayoutManager layoutManager2 = null;
        if (bl) {
            layoutManager2 = position2.getLM();
        }
        LineArea lineArea = new LineArea();
        this.setCurrentArea(lineArea);
        LayoutContext layoutContext2 = new LayoutContext(0);
        layoutContext2.setAlignmentContext(this.alignmentContext);
        this.setChildContext(layoutContext2);
        PositionIterator positionIterator = new PositionIterator(arrayList.listIterator());
        LayoutContext layoutContext3 = new LayoutContext(0);
        layoutContext3.setLeadingSpace(new SpaceSpecifier(true));
        layoutContext3.setTrailingSpace(new SpaceSpecifier(false));
        layoutContext3.setFlags(256, true);
        while ((layoutManager = positionIterator.getNextChildLM()) != null) {
            layoutContext3.setFlags(128, layoutContext.isLastArea() && layoutManager == layoutManager2);
            layoutContext3.setStackLimitBP(layoutContext.getStackLimitBP());
            layoutManager.addAreas(positionIterator, layoutContext3);
            layoutContext3.setLeadingSpace(layoutContext3.getTrailingSpace());
            layoutContext3.setTrailingSpace(new SpaceSpecifier(false));
        }
        lineArea.updateExtentsFromChildren();
        if (lineArea.getBidiLevel() >= 0) {
            BidiResolver.reorder(lineArea);
        }
        this.parentLayoutManager.addChildArea(lineArea);
    }

    @Override
    public void addChildArea(Area area) {
        if (area instanceof InlineArea) {
            Area area2 = this.getCurrentArea();
            if (this.getContext().resolveLeadingSpace()) {
                this.addSpace(area2, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
            }
            area2.addChildArea(area);
        }
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return true;
    }

    @Override
    public boolean getGeneratesLineArea() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    public boolean handleOverflow(int n) {
        if (this.getParent() instanceof BlockLayoutManager) {
            return ((BlockLayoutManager)this.getParent()).handleOverflow(n);
        }
        return false;
    }

    private class LineBreakingAlgorithm
    extends BreakingAlgorithm {
        private final LineLayoutManager thisLLM;
        private final int pageAlignment;
        private int activePossibility;
        private int addedPositions;
        private final int textIndent;
        private final int lineHeight;
        private final int lead;
        private final int follow;
        private static final double MAX_DEMERITS = 1.0E7;

        public LineBreakingAlgorithm(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9, LineLayoutManager lineLayoutManager2) {
            super(n2, n3, bl, false, n9);
            this.pageAlignment = n;
            this.textIndent = n4;
            this.lineHeight = n6;
            this.lead = n7;
            this.follow = n8;
            this.thisLLM = lineLayoutManager2;
            this.activePossibility = -1;
        }

        public void updateData1(int n, double d) {
            LineLayoutManager.this.lineLayouts.addPossibility(n, d);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Layout possibility in " + n + " lines; break at position:"));
            }
        }

        public void updateData2(BreakingAlgorithm.KnuthNode knuthNode, KnuthSequence knuthSequence, int n) {
            int n2;
            double d;
            int n3;
            int n4;
            int n5 = knuthNode.difference;
            int n6 = knuthNode.line < n ? this.alignment : this.alignmentLast;
            switch (n6) {
                case 135: {
                    n4 = 0;
                    n3 = n5 > 0 ? n5 : 0;
                    break;
                }
                case 39: {
                    n4 = n5 > 0 ? n5 : 0;
                    n3 = 0;
                    break;
                }
                case 23: {
                    n3 = n4 = n5 / 2;
                    break;
                }
                default: {
                    n4 = 0;
                    n3 = 0;
                }
            }
            n4 += knuthNode.line == 1 && this.indentFirstPart && LineLayoutManager.this.isFirstInBlock ? this.textIndent : 0;
            double d2 = d = n6 == 70 || n5 < 0 && -n5 <= knuthNode.availableShrink ? knuthNode.adjustRatio : 0.0;
            if (this.activePossibility == -1) {
                this.activePossibility = 0;
                this.addedPositions = 0;
            }
            if (this.addedPositions == LineLayoutManager.this.lineLayouts.getLineCount(this.activePossibility)) {
                ++this.activePossibility;
                this.addedPositions = 0;
            }
            if (log.isWarnEnabled() && (n2 = n5 + knuthNode.availableShrink) < 0 && !LineLayoutManager.this.handleOverflow(-n2)) {
                InlineLevelEventProducer inlineLevelEventProducer = InlineLevelEventProducer.Provider.get(LineLayoutManager.this.getFObj().getUserAgent().getEventBroadcaster());
                inlineLevelEventProducer.lineOverflows(this, knuthNode.line, -n2, LineLayoutManager.this.getFObj().getLocator());
            }
            LineLayoutManager.this.lineLayouts.addBreakPosition(this.makeLineBreakPosition(knuthSequence, knuthNode.line > 1 ? knuthNode.previous.position + 1 : 0, knuthNode.position, knuthNode.availableShrink - (this.addedPositions > 0 ? 0 : ((Paragraph)knuthSequence).lineFiller.getShrink()), knuthNode.availableStretch, n5, d, n4, n3), this.activePossibility);
            ++this.addedPositions;
        }

        public void resetAlgorithm() {
            this.activePossibility = -1;
        }

        private LineBreakPosition makeLineBreakPosition(KnuthSequence knuthSequence, int n, int n2, int n3, int n4, int n5, double d, int n6, int n7) {
            boolean bl;
            int n8 = (this.lineHeight - this.lead - this.follow) / 2;
            int n9 = this.lineHeight - this.lead - this.follow - n8;
            int n10 = this.lead;
            int n11 = this.follow;
            boolean bl2 = bl = n5 == LineLayoutManager.this.ipd;
            if (LineLayoutManager.this.fobj.getLineStackingStrategy() != 52) {
                ListIterator listIterator = knuthSequence.listIterator(n);
                AlignmentContext alignmentContext = null;
                int n12 = 0;
                for (int i = n; i <= n2; ++i) {
                    KnuthElement knuthElement = (KnuthElement)listIterator.next();
                    if (!(knuthElement instanceof KnuthInlineBox)) continue;
                    AlignmentContext alignmentContext2 = ((KnuthInlineBox)knuthElement).getAlignmentContext();
                    if (alignmentContext2 != null && alignmentContext != alignmentContext2) {
                        if (!alignmentContext2.usesInitialBaselineTable() || alignmentContext2.getAlignmentBaselineIdentifier() != 14 && alignmentContext2.getAlignmentBaselineIdentifier() != 4) {
                            if (LineLayoutManager.this.fobj.getLineHeightShiftAdjustment() == 30 || alignmentContext2.getBaselineShiftValue() == 0) {
                                int n13 = alignmentContext2.getTotalAlignmentBaselineOffset();
                                if (n13 + alignmentContext2.getAltitude() > n10) {
                                    n10 = n13 + alignmentContext2.getAltitude();
                                }
                                if (alignmentContext2.getDepth() - n13 > n11) {
                                    n11 = alignmentContext2.getDepth() - n13;
                                }
                            }
                        } else if (alignmentContext2.getHeight() > n12) {
                            n12 = alignmentContext2.getHeight();
                        }
                        alignmentContext = alignmentContext2;
                    }
                    if (!bl || knuthElement.isAuxiliary() && (alignmentContext2 == null || alignmentContext2.getHeight() <= 0)) continue;
                    bl = false;
                }
                if (n11 < n12 - n10) {
                    n11 = n12 - n10;
                }
            }
            LineLayoutManager.this.constantLineHeight = n10 + n11;
            if (bl) {
                return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(knuthSequence), n, n2, n3, n4, n5, d, 0.0, n6, n7, 0, LineLayoutManager.this.ipd, 0, 0, 0);
            }
            return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(knuthSequence), n, n2, n3, n4, n5, d, 0.0, n6, n7, n10 + n11, LineLayoutManager.this.ipd, n8, n9, n10);
        }

        protected int filterActiveNodes() {
            BreakingAlgorithm.KnuthNode knuthNode = null;
            if (this.pageAlignment == 70) {
                BreakingAlgorithm.KnuthNode knuthNode2;
                int n;
                for (n = this.startLine; n < this.endLine; ++n) {
                    knuthNode2 = this.getNode(n);
                    while (knuthNode2 != null) {
                        knuthNode = this.compareNodes(knuthNode, knuthNode2);
                        knuthNode2 = knuthNode2.next;
                    }
                }
                for (n = this.startLine; n < this.endLine; ++n) {
                    knuthNode2 = this.getNode(n);
                    while (knuthNode2 != null) {
                        if (knuthNode2.line != knuthNode.line && knuthNode2.totalDemerits > 1.0E7) {
                            this.removeNode(n, knuthNode2);
                        }
                        knuthNode2 = knuthNode2.next;
                    }
                }
            } else {
                for (int i = this.startLine; i < this.endLine; ++i) {
                    BreakingAlgorithm.KnuthNode knuthNode3 = this.getNode(i);
                    while (knuthNode3 != null) {
                        if (knuthNode3 != (knuthNode = this.compareNodes(knuthNode, knuthNode3))) {
                            this.removeNode(i, knuthNode3);
                        }
                        knuthNode3 = knuthNode3.next;
                    }
                }
            }
            return knuthNode.line;
        }
    }

    private class Paragraph
    extends InlineKnuthSequence {
        private static final long serialVersionUID = 5862072380375189105L;
        private int ignoreAtStart = 0;
        private int ignoreAtEnd = 0;
        private MinOptMax lineFiller;
        private final int textAlignment;
        private final int textAlignmentLast;
        private final int textIndent;
        private final int lastLineEndIndent;
        private final LineLayoutManager layoutManager;

        Paragraph(LineLayoutManager lineLayoutManager2, int n, int n2, int n3, int n4) {
            this.layoutManager = lineLayoutManager2;
            this.textAlignment = n;
            this.textAlignmentLast = n2;
            this.textIndent = n3;
            this.lastLineEndIndent = n4;
        }

        public void startSequence() {
            this.lineFiller = this.textAlignment == 23 ? MinOptMax.getInstance(this.lastLineEndIndent) : MinOptMax.getInstance(this.lastLineEndIndent, this.lastLineEndIndent, this.layoutManager.ipd);
            if (this.textAlignment == 23 && this.textAlignmentLast != 70) {
                this.add(new KnuthGlue(0, 10008, 0, null, false));
                ++this.ignoreAtStart;
            }
            if (LineLayoutManager.this.isFirstInBlock && LineLayoutManager.this.knuthParagraphs.size() == 0 && this.textIndent != 0) {
                this.add(new KnuthInlineBox(this.textIndent, null, null, false));
                ++this.ignoreAtStart;
            }
        }

        public void endParagraph() {
            KnuthSequence knuthSequence = this.endSequence();
            if (knuthSequence != null) {
                LineLayoutManager.this.knuthParagraphs.add(knuthSequence);
            }
        }

        public KnuthSequence endSequence() {
            if (this.size() > this.ignoreAtStart) {
                if (this.textAlignment == 23 && this.textAlignmentLast != 70) {
                    this.add(new KnuthGlue(0, 10008, 0, null, false));
                    this.add(new KnuthPenalty(this.lineFiller.getOpt(), -1000, false, null, false));
                    this.ignoreAtEnd = 2;
                } else if (this.textAlignmentLast != 70) {
                    this.add(new KnuthPenalty(0, 1000, false, null, false));
                    this.add(new KnuthGlue(0, this.lineFiller.getStretch(), this.lineFiller.getShrink(), null, false));
                    this.add(new KnuthPenalty(this.lineFiller.getOpt(), -1000, false, null, false));
                    this.ignoreAtEnd = 3;
                } else {
                    this.add(new KnuthPenalty(this.lineFiller.getOpt(), -1000, false, null, false));
                    this.ignoreAtEnd = 1;
                }
                return this;
            }
            this.clear();
            return null;
        }

        public boolean containsBox() {
            for (int i = 0; i < this.size(); ++i) {
                KnuthElement knuthElement = (KnuthElement)this.get(i);
                if (!knuthElement.isBox()) continue;
                return true;
            }
            return false;
        }
    }

    private final class Update {
        private final InlineLevelLayoutManager inlineLM;
        private final int firstIndex;

        private Update(InlineLevelLayoutManager inlineLevelLayoutManager, int n) {
            this.inlineLM = inlineLevelLayoutManager;
            this.firstIndex = n;
        }
    }

    private static class LineBreakPosition
    extends LeafPosition {
        private final int parIndex;
        private final int startIndex;
        private final int availableShrink;
        private final int availableStretch;
        private final int difference;
        private final double dAdjust;
        private final double ipdAdjust;
        private final int startIndent;
        private final int endIndent;
        private final int lineHeight;
        private final int lineWidth;
        private final int spaceBefore;
        private final int spaceAfter;
        private final int baseline;

        LineBreakPosition(LayoutManager layoutManager, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
            super(layoutManager, n3);
            this.availableShrink = n4;
            this.availableStretch = n5;
            this.difference = n6;
            this.parIndex = n;
            this.startIndex = n2;
            this.ipdAdjust = d;
            this.dAdjust = d2;
            this.startIndent = n7;
            this.endIndent = n8;
            this.lineHeight = n9;
            this.lineWidth = n10;
            this.spaceBefore = n11;
            this.spaceAfter = n12;
            this.baseline = n13;
        }
    }
}

