/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.UnresolvedPageNumber;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.inline.AbstractPageNumberCitationLayoutManager;

public class PageNumberCitationLastLayoutManager
extends AbstractPageNumberCitationLayoutManager {
    public PageNumberCitationLastLayoutManager(PageNumberCitationLast pageNumberCitationLast) {
        super(pageNumberCitationLast);
        this.fobj = pageNumberCitationLast;
    }

    public InlineArea get(LayoutContext layoutContext) {
        this.curArea = this.getPageNumberCitationLastInlineArea(this.parentLayoutManager);
        return this.curArea;
    }

    private InlineArea getPageNumberCitationLastInlineArea(LayoutManager layoutManager) {
        TextArea textArea = null;
        int n = this.getBidiLevel();
        if (!this.getPSLM().associateLayoutManagerID(this.fobj.getRefId())) {
            textArea = new UnresolvedPageNumber(this.fobj.getRefId(), this.font, false);
            this.getPSLM().addUnresolvedArea(this.fobj.getRefId(), (Resolvable)((Object)textArea));
            String string = "MMM";
            int n2 = this.getStringWidth(string);
            textArea.setBidiLevel(n);
            textArea.setIPD(n2);
            this.resolved = false;
        } else {
            PageViewport pageViewport = this.getPSLM().getLastPVWithID(this.fobj.getRefId());
            String string = pageViewport.getPageNumberString();
            textArea = new TextArea();
            int n3 = this.getStringWidth(string);
            textArea.setBidiLevel(n);
            textArea.addWord(string, 0, n);
            textArea.setIPD(n3);
            this.resolved = true;
        }
        this.updateTextAreaTraits(textArea);
        return textArea;
    }
}

