/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class ListBlockLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private static Log log = LogFactory.getLog(ListBlockLayoutManager.class);
    private Block curBlockArea;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;

    public ListBlockLayoutManager(ListBlock listBlock) {
        super(listBlock);
    }

    protected ListBlock getListBlockFO() {
        return (ListBlock)this.fobj;
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getListBlockFO().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getListBlockFO().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.startIndent = this.getListBlockFO().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getListBlockFO().getCommonMarginBlock().endIndent.getValue(this);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public List getNextKnuthElements(LayoutContext layoutContext, int n) {
        int n2;
        this.resetSpaces();
        List list = super.getNextKnuthElements(layoutContext, n);
        int n3 = this.getListBlockFO().getWidowContentLimit().getValue();
        if (n3 != 0) {
            ElementListUtils.removeLegalBreaks(list, n3);
        }
        if ((n2 = this.getListBlockFO().getOrphanContentLimit().getValue()) != 0) {
            ElementListUtils.removeLegalBreaksFromEnd(list, n2);
        }
        return list;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        LayoutManager layoutManager;
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance(layoutContext.getSpaceBefore()));
        }
        this.addId();
        LayoutContext layoutContext2 = new LayoutContext(0);
        LayoutManager layoutManager2 = null;
        LayoutManager layoutManager3 = null;
        Position position = null;
        Position position2 = null;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            if (!(position3 instanceof NonLeafPosition) || position3.getPosition() == null || position3.getPosition().getLM() == this) continue;
            linkedList.add(position3.getPosition());
            layoutManager3 = position3.getPosition().getLM();
            if (layoutManager2 != null) continue;
            layoutManager2 = layoutManager3;
        }
        this.addMarkersToPage(true, this.isFirst(position), this.isLast(position2));
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
            layoutContext2.setFlags(32, layoutManager == layoutManager2);
            layoutContext2.setFlags(128, layoutManager == layoutManager3);
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            layoutManager.addAreas(positionIterator2, layoutContext2);
        }
        this.addMarkersToPage(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addBackground(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this);
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(position2);
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.parentLayoutManager.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getListBlockFO().getId());
            TraitSetter.addBorders(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.getListBlockFO().getCommonMarginBlock(), this);
            TraitSetter.addBreaks(this.curBlockArea, this.getListBlockFO().getBreakBefore(), this.getListBlockFO().getBreakAfter());
            int n = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(n);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getListBlockFO().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getListBlockFO().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getListBlockFO().getKeepWithNext();
    }

    public void notifySpace(RelSide relSide, MinOptMax minOptMax) {
        if (RelSide.BEFORE == relSide) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceBefore + "-> " + minOptMax));
            }
            this.effSpaceBefore = minOptMax;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + relSide + ", " + this.effSpaceAfter + "-> " + minOptMax));
            }
            this.effSpaceAfter = minOptMax;
        }
    }

    public void notifyBorder(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + relSide + " -> " + minOptMax));
        }
    }

    public void notifyPadding(RelSide relSide, MinOptMax minOptMax) {
        if (minOptMax == null) {
            if (RelSide.BEFORE == relSide) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + relSide + " -> " + minOptMax));
        }
    }
}

