/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import org.apache.fop.fo.flow.table.BorderSpecification;
import org.apache.fop.layoutmgr.table.CollapsingBorderModelEyeCatching;

public abstract class CollapsingBorderModel {
    protected static final int BEFORE = 0;
    protected static final int AFTER = 1;
    protected static final int START = 2;
    protected static final int END = 3;
    private static CollapsingBorderModel collapse = null;

    public static CollapsingBorderModel getBorderModelFor(int n) {
        switch (n) {
            case 26: {
                if (collapse == null) {
                    collapse = new CollapsingBorderModelEyeCatching();
                }
                return collapse;
            }
            case 27: {
                throw new UnsupportedOperationException("collapse-with-precedence not yet supported");
            }
        }
        throw new IllegalArgumentException("Illegal border-collapse mode.");
    }

    public static int getOtherSide(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Illegal parameter: side");
    }

    protected boolean isVerticalRelation(int n) {
        return n == 0 || n == 1;
    }

    private static int compareInt(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return 1;
    }

    private static int getStylePreferenceValue(int n) {
        switch (n) {
            case 37: {
                return 0;
            }
            case 133: {
                return -1;
            }
            case 31: {
                return -2;
            }
            case 36: {
                return -3;
            }
            case 119: {
                return -4;
            }
            case 101: {
                return -5;
            }
            case 55: {
                return -6;
            }
            case 67: {
                return -7;
            }
        }
        throw new IllegalStateException("Illegal border style: " + n);
    }

    static int compareStyles(int n, int n2) {
        int n3 = CollapsingBorderModel.getStylePreferenceValue(n);
        int n4 = CollapsingBorderModel.getStylePreferenceValue(n2);
        return CollapsingBorderModel.compareInt(n3, n4);
    }

    private static int getHolderPreferenceValue(int n) {
        switch (n) {
            case 75: {
                return 0;
            }
            case 79: {
                return -1;
            }
            case 73: 
            case 77: 
            case 78: {
                return -2;
            }
            case 76: {
                return -3;
            }
            case 71: {
                return -4;
            }
        }
        throw new IllegalStateException();
    }

    static int compareFOs(int n, int n2) {
        int n3 = CollapsingBorderModel.getHolderPreferenceValue(n);
        int n4 = CollapsingBorderModel.getHolderPreferenceValue(n2);
        return CollapsingBorderModel.compareInt(n3, n4);
    }

    public abstract BorderSpecification determineWinner(BorderSpecification var1, BorderSpecification var2, boolean var3);

    public abstract BorderSpecification determineWinner(BorderSpecification var1, BorderSpecification var2);
}

