/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.expr.RelativeNumericProperty;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;

public class ColumnSetup {
    private static Log log = LogFactory.getLog(ColumnSetup.class);
    private Table table;
    private WritingModeTraitsGetter wmTraits;
    private List columns = new ArrayList();
    private List colWidths = new ArrayList();
    private int maxColIndexReferenced = 0;

    public ColumnSetup(Table table) {
        assert (table != null);
        this.table = table;
        this.wmTraits = WritingModeTraits.getWritingModeTraitsGetter(table);
        this.prepareColumns();
        this.initializeColumnWidths();
    }

    private void prepareColumns() {
        List list = this.table.getColumns();
        if (list != null) {
            int n = 1;
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                TableColumn tableColumn = (TableColumn)listIterator.next();
                if (tableColumn == null) continue;
                n = tableColumn.getColumnNumber();
                for (int i = 0; i < tableColumn.getNumberColumnsRepeated(); ++i) {
                    while (n > this.columns.size()) {
                        this.columns.add(null);
                    }
                    this.columns.set(n - 1, tableColumn);
                    ++n;
                }
            }
            int n2 = 1;
            ListIterator listIterator2 = this.columns.listIterator();
            while (listIterator2.hasNext()) {
                TableColumn tableColumn = (TableColumn)listIterator2.next();
                if (tableColumn == null) assert (false);
                ++n2;
            }
        }
    }

    public TableColumn getColumn(int n) {
        int n2 = this.columns.size();
        if (n > n2) {
            if (n > this.maxColIndexReferenced) {
                this.maxColIndexReferenced = n;
                TableColumn tableColumn = this.getColumn(1);
                if (n2 != 1 || !tableColumn.isImplicitColumn()) {
                    assert (false);
                    log.warn((Object)FONode.decorateWithContextInfo("There are fewer table-columns than are needed. Column " + n + " was accessed, but only " + n2 + " columns have been defined. " + "The last defined column will be reused.", this.table));
                    if (!this.table.isAutoLayout()) {
                        log.warn((Object)"Please note that according XSL-FO 1.0 (7.26.9) says that the 'column-width' property must be specified for every column, unless the automatic table layout is used.");
                    }
                }
            }
            return (TableColumn)this.columns.get(n2 - 1);
        }
        return (TableColumn)this.columns.get(n - 1);
    }

    public String toString() {
        return this.columns.toString();
    }

    public int getColumnCount() {
        if (this.maxColIndexReferenced > this.columns.size()) {
            return this.maxColIndexReferenced;
        }
        return this.columns.size();
    }

    public Iterator iterator() {
        return this.columns.iterator();
    }

    private void initializeColumnWidths() {
        int n = this.columns.size();
        while (--n >= 0) {
            if (this.columns.get(n) == null) continue;
            TableColumn tableColumn = (TableColumn)this.columns.get(n);
            Length length = tableColumn.getColumnWidth();
            this.colWidths.add(0, length);
        }
        this.colWidths.add(0, null);
    }

    protected double computeTableUnit(TableLayoutManager tableLayoutManager) {
        return this.computeTableUnit(tableLayoutManager, tableLayoutManager.getContentAreaIPD());
    }

    public float computeTableUnit(PercentBaseContext percentBaseContext, int n) {
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        for (Length length : this.colWidths) {
            if (length == null) continue;
            n2 += length.getValue(percentBaseContext);
            if (length instanceof RelativeNumericProperty) {
                f = (float)((double)f + ((RelativeNumericProperty)length).getTableUnits());
                continue;
            }
            if (!(length instanceof TableColLength)) continue;
            f = (float)((double)f + ((TableColLength)length).getTableUnits());
        }
        if (f > 0.0f) {
            if (n2 < n) {
                f2 = (float)(n - n2) / f;
            } else {
                log.warn((Object)"No space remaining to distribute over columns.");
            }
        }
        return f2;
    }

    public int getXOffset(int n, int n2, PercentBaseContext percentBaseContext) {
        if (this.wmTraits != null && this.wmTraits.getColumnProgressionDirection() == Direction.RL) {
            return this.getXOffsetRTL(n, n2, percentBaseContext);
        }
        return this.getXOffsetLTR(n, percentBaseContext);
    }

    private int getXOffsetRTL(int n, int n2, PercentBaseContext percentBaseContext) {
        int n3 = 0;
        int n4 = n + n2 - 1;
        int n5 = this.colWidths.size();
        while (++n4 < n5) {
            int n6 = n4;
            if (this.colWidths.get(n6) == null) continue;
            n3 += ((Length)this.colWidths.get(n6)).getValue(percentBaseContext);
        }
        return n3;
    }

    private int getXOffsetLTR(int n, PercentBaseContext percentBaseContext) {
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n3 < this.colWidths.size() ? n3 : this.colWidths.size() - 1;
            if (this.colWidths.get(n4) == null) continue;
            n2 += ((Length)this.colWidths.get(n4)).getValue(percentBaseContext);
        }
        return n2;
    }

    public int getSumOfColumnWidths(PercentBaseContext percentBaseContext) {
        int n = 0;
        int n2 = this.getColumnCount();
        for (int i = 1; i <= n2; ++i) {
            int n3 = i;
            if (i >= this.colWidths.size()) {
                n3 = this.colWidths.size() - 1;
            }
            if (this.colWidths.get(n3) == null) continue;
            n += ((Length)this.colWidths.get(n3)).getValue(percentBaseContext);
        }
        return n;
    }
}

