/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.EmptyGridUnit;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ActiveCell;
import org.apache.fop.layoutmgr.table.CellPart;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

class RowPainter {
    private static Log log = LogFactory.getLog(RowPainter.class);
    private int colCount;
    private int currentRowOffset = 0;
    private EffRow currentRow = null;
    private LayoutContext layoutContext;
    private int firstRowIndex;
    private int firstRowOnPageIndex;
    private List rowOffsets = new ArrayList();
    private int[] cellHeights;
    private boolean[] firstCellOnPage;
    private CellPart[] firstCellParts;
    private CellPart[] lastCellParts;
    private int tablePartOffset = 0;
    private CommonBorderPaddingBackground tablePartBackground;
    private List tablePartBackgroundAreas;
    private TableContentLayoutManager tclm;

    RowPainter(TableContentLayoutManager tableContentLayoutManager, LayoutContext layoutContext) {
        this.tclm = tableContentLayoutManager;
        this.layoutContext = layoutContext;
        this.colCount = tableContentLayoutManager.getColumns().getColumnCount();
        this.cellHeights = new int[this.colCount];
        this.firstCellOnPage = new boolean[this.colCount];
        this.firstCellParts = new CellPart[this.colCount];
        this.lastCellParts = new CellPart[this.colCount];
        this.firstRowIndex = -1;
        this.firstRowOnPageIndex = -1;
    }

    void startTablePart(TablePart tablePart) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = tablePart.getCommonBorderPaddingBackground();
        if (commonBorderPaddingBackground.hasBackground()) {
            this.tablePartBackground = commonBorderPaddingBackground;
            if (this.tablePartBackgroundAreas == null) {
                this.tablePartBackgroundAreas = new ArrayList();
            }
        }
        this.tablePartOffset = this.currentRowOffset;
    }

    void endTablePart(boolean bl, boolean bl2) {
        this.addAreasAndFlushRow(bl, bl2);
        if (this.tablePartBackground != null) {
            TableLayoutManager tableLayoutManager = this.tclm.getTableLM();
            for (Block block : this.tablePartBackgroundAreas) {
                TraitSetter.addBackground(block, this.tablePartBackground, tableLayoutManager, -block.getXOffset(), this.tablePartOffset - block.getYOffset(), tableLayoutManager.getContentAreaIPD(), this.currentRowOffset - this.tablePartOffset);
            }
            this.tablePartBackground = null;
            this.tablePartBackgroundAreas.clear();
        }
    }

    int getAccumulatedBPD() {
        return this.currentRowOffset;
    }

    void handleTableContentPosition(TableContentPosition tableContentPosition) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("===handleTableContentPosition(" + tableContentPosition));
        }
        if (this.currentRow == null) {
            this.currentRow = tableContentPosition.getNewPageRow();
        } else {
            EffRow effRow = tableContentPosition.getRow();
            if (effRow.getIndex() > this.currentRow.getIndex()) {
                this.addAreasAndFlushRow(false, false);
                this.currentRow = effRow;
            }
        }
        if (this.firstRowIndex < 0) {
            this.firstRowIndex = this.currentRow.getIndex();
            if (this.firstRowOnPageIndex < 0) {
                this.firstRowOnPageIndex = this.firstRowIndex;
            }
        }
        for (CellPart cellPart : tableContentPosition.cellParts) {
            int n;
            if (log.isDebugEnabled()) {
                log.debug((Object)(">" + cellPart));
            }
            if (this.firstCellParts[n = cellPart.pgu.getColIndex()] == null) {
                this.firstCellParts[n] = cellPart;
                this.cellHeights[n] = cellPart.getBorderPaddingBefore(this.firstCellOnPage[n]);
            } else {
                assert (this.firstCellParts[n].pgu == cellPart.pgu);
                int n2 = n;
                this.cellHeights[n2] = this.cellHeights[n2] + cellPart.getConditionalBeforeContentLength();
            }
            int n3 = n;
            this.cellHeights[n3] = this.cellHeights[n3] + cellPart.getLength();
            this.lastCellParts[n] = cellPart;
        }
    }

    private void addAreasAndFlushRow(boolean bl, boolean bl2) {
        int n;
        int n2;
        GridUnit gridUnit;
        int n3;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remembering yoffset for row " + this.currentRow.getIndex() + ": " + this.currentRowOffset));
        }
        this.recordRowOffset(this.currentRow.getIndex(), this.currentRowOffset);
        boolean bl3 = true;
        boolean bl4 = true;
        int n4 = 0;
        for (n3 = 0; n3 < this.colCount; ++n3) {
            gridUnit = this.currentRow.getGridUnit(n3);
            if (gridUnit.isEmpty()) continue;
            if (gridUnit.getColSpanIndex() == 0 && (bl || gridUnit.isLastGridUnitRowSpan()) && this.firstCellParts[n3] != null) {
                n2 = this.cellHeights[n3];
                n2 += this.lastCellParts[n3].getConditionalAfterContentLength();
                n = this.getRowOffset(Math.max(this.firstCellParts[n3].pgu.getRowIndex(), this.firstRowIndex));
                n4 = Math.max(n4, n + (n2 += this.lastCellParts[n3].getBorderPaddingAfter(bl)) - this.currentRowOffset);
            }
            if (this.firstCellParts[n3] != null && !this.firstCellParts[n3].isFirstPart()) {
                bl3 = false;
            }
            if (this.lastCellParts[n3] == null || this.lastCellParts[n3].isLastPart()) continue;
            bl4 = false;
        }
        for (n3 = 0; n3 < this.colCount; ++n3) {
            gridUnit = this.currentRow.getGridUnit(n3);
            if (gridUnit.isEmpty() && !this.tclm.isSeparateBorderModel()) {
                n2 = bl3 ? (this.firstCellOnPage[n3] ? 1 : 0) : 2;
                n = bl4 ? (bl ? 1 : 0) : 2;
                this.addAreaForEmptyGridUnit((EmptyGridUnit)gridUnit, this.currentRow.getIndex(), n3, n4, n2, n, bl2);
                this.firstCellOnPage[n3] = false;
                continue;
            }
            if (gridUnit.getColSpanIndex() != 0 || !bl && !gridUnit.isLastGridUnitRowSpan() || this.firstCellParts[n3] == null) continue;
            assert (this.firstCellParts[n3].pgu == gridUnit.getPrimary());
            if (this.firstCellParts[n3].isFirstPart()) {
                n2 = this.firstCellOnPage[n3] ? 1 : 0;
            } else {
                assert (this.firstCellOnPage[n3]);
                n2 = 2;
            }
            n = this.lastCellParts[n3].isLastPart() ? (bl ? 1 : 0) : 2;
            this.addAreasForCell(this.firstCellParts[n3].pgu, this.firstCellParts[n3].start, this.lastCellParts[n3].end, n4, n2, n, bl2);
            this.firstCellParts[n3] = null;
            Arrays.fill(this.firstCellOnPage, n3, n3 + gridUnit.getCell().getNumberColumnsSpanned(), false);
        }
        this.currentRowOffset += n4;
        if (bl) {
            this.currentRow = null;
            this.firstRowIndex = -1;
            this.rowOffsets.clear();
            this.firstRowOnPageIndex = Integer.MAX_VALUE;
        }
    }

    private int computeContentLength(PrimaryGridUnit primaryGridUnit, int n, int n2) {
        if (n > n2) {
            return 0;
        }
        ListIterator listIterator = primaryGridUnit.getElements().listIterator(n);
        boolean bl = false;
        while (listIterator.nextIndex() <= n2 && !bl) {
            bl = ((KnuthElement)listIterator.next()).isBox();
        }
        int n3 = 0;
        if (((KnuthElement)listIterator.previous()).isBox()) {
            while (listIterator.nextIndex() < n2) {
                KnuthElement knuthElement = (KnuthElement)listIterator.next();
                if (!knuthElement.isBox() && !knuthElement.isGlue()) continue;
                n3 += knuthElement.getWidth();
            }
            n3 += ActiveCell.getElementContentLength((KnuthElement)listIterator.next());
        }
        return n3;
    }

    private void addAreasForCell(PrimaryGridUnit primaryGridUnit, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this.currentRow.getIndex();
        if (primaryGridUnit.getRowIndex() >= this.firstRowIndex) {
            n9 = primaryGridUnit.getRowIndex();
            n8 = n9 < n10 ? this.getRowOffset(n9 + 1) - this.getRowOffset(n9) : n3;
        } else {
            n9 = this.firstRowIndex;
            n8 = 0;
        }
        int[] nArray = null;
        if (!this.tclm.getTableLM().getTable().isSeparateBorderModel() && primaryGridUnit.hasSpanning()) {
            nArray = new int[n10 - n9 + 1];
            n7 = this.getRowOffset(n9);
            for (n6 = 0; n6 < n10 - n9; ++n6) {
                int n11 = this.getRowOffset(n9 + n6 + 1);
                nArray[n6] = n11 - n7;
                n7 = n11;
            }
            nArray[n10 - n9] = n3;
        }
        n7 = this.getRowOffset(n9);
        n6 = n3 + this.currentRowOffset - n7;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating area for cell:");
            log.debug((Object)("  start row: " + primaryGridUnit.getRowIndex() + " " + this.currentRowOffset + " " + n7));
            log.debug((Object)(" rowHeight=" + n3 + " cellTotalHeight=" + n6));
        }
        TableCellLayoutManager tableCellLayoutManager = primaryGridUnit.getCellLM();
        tableCellLayoutManager.setXOffset(this.tclm.getXOffsetOfGridUnit(primaryGridUnit));
        tableCellLayoutManager.setYOffset(n7);
        tableCellLayoutManager.setContentHeight(this.computeContentLength(primaryGridUnit, n, n2));
        tableCellLayoutManager.setTotalHeight(n6);
        int n12 = ElementListUtils.determinePreviousBreak(primaryGridUnit.getElements(), n);
        if (n2 >= 0) {
            SpaceResolver.performConditionalsNotification(primaryGridUnit.getElements(), n, n2, n12);
        }
        tableCellLayoutManager.addAreas(new KnuthPossPosIter(primaryGridUnit.getElements(), n, n2 + 1), this.layoutContext, nArray, n9 - primaryGridUnit.getRowIndex(), n10 - primaryGridUnit.getRowIndex(), n4, n5, n9 == this.firstRowOnPageIndex, bl, this, n8);
    }

    private void addAreaForEmptyGridUnit(EmptyGridUnit emptyGridUnit, int n, int n2, int n3, int n4, int n5, boolean bl) {
        CommonBorderPaddingBackground.BorderInfo borderInfo = emptyGridUnit.getBorderBefore(n4);
        CommonBorderPaddingBackground.BorderInfo borderInfo2 = emptyGridUnit.getBorderAfter(n5);
        CommonBorderPaddingBackground.BorderInfo borderInfo3 = emptyGridUnit.getBorderStart();
        CommonBorderPaddingBackground.BorderInfo borderInfo4 = emptyGridUnit.getBorderEnd();
        if (borderInfo.getRetainedWidth() == 0 && borderInfo2.getRetainedWidth() == 0 && borderInfo3.getRetainedWidth() == 0 && borderInfo4.getRetainedWidth() == 0) {
            return;
        }
        TableLayoutManager tableLayoutManager = this.tclm.getTableLM();
        Table table = tableLayoutManager.getTable();
        TableColumn tableColumn = this.tclm.getColumns().getColumn(n2 + 1);
        boolean bl2 = n == this.firstRowOnPageIndex;
        boolean bl3 = n2 == 0;
        boolean bl4 = n2 == table.getNumberOfColumns() - 1;
        int n6 = tableColumn.getColumnWidth().getValue(tableLayoutManager);
        int n7 = n3;
        Block block = new Block();
        block.setPositioning(2);
        block.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
        block.setIPD(n6 -= (borderInfo3.getRetainedWidth() + borderInfo4.getRetainedWidth()) / 2);
        block.setBPD(n7 -= (borderInfo.getRetainedWidth() + borderInfo2.getRetainedWidth()) / 2);
        block.setXOffset(this.tclm.getXOffsetOfGridUnit(n2, 1) + borderInfo3.getRetainedWidth() / 2);
        block.setYOffset(this.getRowOffset(n) - borderInfo.getRetainedWidth() / 2);
        boolean[] blArray = new boolean[]{bl2, bl, bl3, bl4};
        TraitSetter.addCollapsingBorders(block, borderInfo, borderInfo2, borderInfo3, borderInfo4, blArray);
        tableLayoutManager.addChildArea(block);
    }

    void registerPartBackgroundArea(Block block) {
        this.tclm.getTableLM().addBackgroundArea(block);
        this.tablePartBackgroundAreas.add(block);
    }

    private void recordRowOffset(int n, int n2) {
        for (int i = this.rowOffsets.size(); i <= n - this.firstRowIndex; ++i) {
            this.rowOffsets.add(new Integer(n2));
        }
    }

    private int getRowOffset(int n) {
        return (Integer)this.rowOffsets.get(n - this.firstRowIndex);
    }

    void startBody() {
        Arrays.fill(this.firstCellOnPage, true);
    }

    void endBody() {
        Arrays.fill(this.firstCellOnPage, false);
    }
}

