/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.List;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.table.CellPart;

class TableContentPosition
extends Position {
    public static final int FIRST_IN_ROWGROUP = 1;
    public static final int LAST_IN_ROWGROUP = 2;
    protected List cellParts;
    private EffRow row;
    protected int flags;
    private EffRow newPageRow;

    protected TableContentPosition(LayoutManager layoutManager, List list, EffRow effRow) {
        super(layoutManager);
        this.cellParts = list;
        this.row = effRow;
        this.newPageRow = effRow;
    }

    void setNewPageRow(EffRow effRow) {
        this.newPageRow = effRow;
    }

    EffRow getNewPageRow() {
        return this.newPageRow;
    }

    EffRow getRow() {
        return this.row;
    }

    TablePart getTablePart() {
        return ((CellPart)this.cellParts.get((int)0)).pgu.getTablePart();
    }

    public boolean getFlag(int n) {
        return (this.flags & 1 << n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    public boolean generatesAreas() {
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TableContentPosition:");
        stringBuffer.append(this.getIndex());
        stringBuffer.append("[");
        stringBuffer.append(this.row.getIndex()).append("/");
        stringBuffer.append(this.getFlag(1) ? "F" : "-");
        stringBuffer.append(this.getFlag(2) ? "L" : "-").append("]");
        stringBuffer.append("(");
        stringBuffer.append(this.cellParts);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

