/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFReference;

public class BitmapImage
implements PDFImage {
    private int height;
    private int width;
    private int bitsPerComponent;
    private PDFDeviceColorSpace colorSpace;
    private byte[] bitmaps;
    private PDFReference maskRef;
    private PDFColor transparent = null;
    private String key;
    private PDFDocument pdfDoc;
    private PDFFilter pdfFilter;
    private boolean multipleFiltersAllowed = true;

    public BitmapImage(String string, int n, int n2, byte[] byArray, String string2) {
        this.key = string;
        this.height = n2;
        this.width = n;
        this.bitsPerComponent = 8;
        this.colorSpace = new PDFDeviceColorSpace(2);
        this.bitmaps = byArray;
        if (string2 != null) {
            this.maskRef = new PDFReference(string2);
        }
    }

    public void setup(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
    }

    public String getKey() {
        return this.key;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setColorSpace(PDFDeviceColorSpace pDFDeviceColorSpace) {
        this.colorSpace = pDFDeviceColorSpace;
    }

    public PDFDeviceColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public void setTransparent(PDFColor pDFColor) {
        this.transparent = pDFColor;
    }

    public boolean isTransparent() {
        return this.transparent != null;
    }

    public PDFColor getTransparentColor() {
        return this.transparent;
    }

    public String getMask() {
        return null;
    }

    public PDFReference getSoftMaskReference() {
        return this.maskRef;
    }

    public boolean isInverted() {
        return false;
    }

    public void outputContents(OutputStream outputStream) throws IOException {
        outputStream.write(this.bitmaps);
    }

    public void populateXObjectDictionary(PDFDictionary pDFDictionary) {
    }

    public PDFICCStream getICCStream() {
        return null;
    }

    public boolean isPS() {
        return false;
    }

    public String getFilterHint() {
        return "image";
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    public void setPDFFilter(PDFFilter pDFFilter) {
        this.pdfFilter = pDFFilter;
    }

    public boolean multipleFiltersAllowed() {
        return this.multipleFiltersAllowed;
    }

    public void disallowMultipleFilters() {
        this.multipleFiltersAllowed = false;
    }
}

