/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.xref.CompressedObjectReference;

public class ObjectStream
extends PDFStream {
    private static final PDFName OBJ_STM = new PDFName("ObjStm");
    private List<CompressedObject> objects = new ArrayList<CompressedObject>();
    private int firstObjectOffset;

    ObjectStream() {
        super(false);
    }

    ObjectStream(ObjectStream objectStream) {
        this();
        this.put("Extends", objectStream);
    }

    CompressedObjectReference addObject(CompressedObject compressedObject) {
        if (compressedObject == null) {
            throw new NullPointerException("obj must not be null");
        }
        CompressedObjectReference compressedObjectReference = new CompressedObjectReference(compressedObject.getObjectNumber(), this.getObjectNumber(), this.objects.size());
        this.objects.add(compressedObject);
        return compressedObjectReference;
    }

    protected void outputRawStreamData(OutputStream outputStream) throws IOException {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (CompressedObject compressedObject : this.objects) {
            stringBuilder.append(compressedObject.getObjectNumber()).append(' ').append(n).append('\n');
            n += compressedObject.output(byteArrayOutputStream);
        }
        Object object = PDFDocument.encode(stringBuilder.toString());
        this.firstObjectOffset = ((Object)object).length;
        outputStream.write((byte[])object);
        byteArrayOutputStream.writeTo(outputStream);
    }

    protected void populateStreamDict(Object object) {
        this.put("Type", OBJ_STM);
        this.put("N", this.objects.size());
        this.put("First", this.firstObjectOffset);
        super.populateStreamDict(object);
    }
}

