/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;

public class PDFDictionary
extends PDFObject {
    protected Map<String, Object> entries = new HashMap<String, Object>();
    protected List<String> order = new ArrayList<String>();

    public PDFDictionary() {
    }

    public PDFDictionary(PDFObject pDFObject) {
        super(pDFObject);
    }

    public void put(String string, Object object) {
        PDFObject pDFObject;
        if (object instanceof PDFObject && !(pDFObject = (PDFObject)object).hasObjectNumber()) {
            pDFObject.setParent(this);
        }
        if (!this.entries.containsKey(string)) {
            this.order.add(string);
        }
        this.entries.put(string, object);
    }

    public void put(String string, int n) {
        if (!this.entries.containsKey(string)) {
            this.order.add(string);
        }
        this.entries.put(string, n);
    }

    public Object get(String string) {
        return this.entries.get(string);
    }

    public int output(OutputStream outputStream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(outputStream);
        StringBuilder stringBuilder = new StringBuilder(64);
        this.writeDictionary((OutputStream)countingOutputStream, stringBuilder);
        PDFDocument.flushTextBuffer(stringBuilder, (OutputStream)countingOutputStream);
        return countingOutputStream.getCount();
    }

    protected void writeDictionary(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        stringBuilder.append("<<");
        boolean bl = this.order.size() <= 2;
        for (String string : this.order) {
            if (bl) {
                stringBuilder.append(' ');
            } else {
                stringBuilder.append("\n  ");
            }
            stringBuilder.append(PDFName.escapeName(string));
            stringBuilder.append(' ');
            Object object = this.entries.get(string);
            this.formatObject(object, outputStream, stringBuilder);
        }
        if (bl) {
            stringBuilder.append(' ');
        } else {
            stringBuilder.append('\n');
        }
        stringBuilder.append(">>\n");
    }
}

