/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.fonts.FontType;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFontTrueType;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFontType1;
import org.apache.fop.pdf.PDFName;

public class PDFFont
extends PDFDictionary {
    private String fontname;

    public PDFFont(String string, FontType fontType, String string2, Object object) {
        this.fontname = string;
        this.put("Type", new PDFName("Font"));
        this.put("Subtype", this.getPDFNameForFontType(fontType));
        this.put("BaseFont", new PDFName(string2));
        if (object instanceof PDFEncoding) {
            this.setEncoding((PDFEncoding)object);
        } else if (object instanceof String) {
            this.setEncoding((String)object);
        }
    }

    public void setEncoding(String string) {
        if (string != null) {
            this.put("Encoding", new PDFName(string));
        }
    }

    public void setEncoding(PDFEncoding pDFEncoding) {
        if (pDFEncoding != null) {
            this.put("Encoding", pDFEncoding);
        }
    }

    public void setToUnicode(PDFCMap pDFCMap) {
        this.put("ToUnicode", pDFCMap);
    }

    public static PDFFont createFont(String string, FontType fontType, String string2, Object object) {
        if (fontType == FontType.TYPE0) {
            return new PDFFontType0(string, string2, object);
        }
        if (fontType == FontType.TYPE1 || fontType == FontType.MMTYPE1) {
            return new PDFFontType1(string, string2, object);
        }
        if (fontType == FontType.TYPE3) {
            return null;
        }
        if (fontType == FontType.TRUETYPE) {
            return new PDFFontTrueType(string, string2, object);
        }
        return null;
    }

    public String getName() {
        return this.fontname;
    }

    public PDFName getBaseFont() {
        return (PDFName)this.get("BaseFont");
    }

    protected PDFName getPDFNameForFontType(FontType fontType) {
        if (fontType == FontType.TYPE0) {
            return new PDFName(fontType.getName());
        }
        if (fontType == FontType.TYPE1) {
            return new PDFName(fontType.getName());
        }
        if (fontType == FontType.MMTYPE1) {
            return new PDFName(fontType.getName());
        }
        if (fontType == FontType.TYPE3) {
            return new PDFName(fontType.getName());
        }
        if (fontType == FontType.TRUETYPE) {
            return new PDFName(fontType.getName());
        }
        throw new IllegalArgumentException("Unsupported font type: " + fontType.getName());
    }

    protected void validate() {
        if (this.getDocumentSafely().getProfile().isFontEmbeddingRequired() && this.getClass() == PDFFont.class) {
            throw new PDFConformanceException("For " + this.getDocumentSafely().getProfile() + ", all fonts, even the base 14" + " fonts, have to be embedded! Offending font: " + this.getBaseFont());
        }
    }

    public int output(OutputStream outputStream) throws IOException {
        this.validate();
        return super.output(outputStream);
    }
}

