/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFWritable;

public abstract class PDFObject
implements PDFWritable {
    protected static final Log log = LogFactory.getLog((String)PDFObject.class.getName());
    private int objnum;
    private int generation = 0;
    private PDFDocument document;
    private PDFObject parent;

    public int getObjectNumber() {
        if (this.objnum == 0) {
            throw new IllegalStateException("Object has no number assigned: " + this.toString());
        }
        return this.objnum;
    }

    public PDFObject() {
    }

    public PDFObject(PDFObject pDFObject) {
        this.setParent(pDFObject);
    }

    public boolean hasObjectNumber() {
        return this.objnum > 0;
    }

    public void setObjectNumber(int n) {
        this.objnum = n;
        PDFDocument pDFDocument = this.getDocument();
        this.setParent(null);
        this.setDocument(pDFDocument);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Assigning " + this + " object number " + n));
        }
    }

    public int getGeneration() {
        return this.generation;
    }

    public final PDFDocument getDocument() {
        if (this.document != null) {
            return this.document;
        }
        if (this.getParent() != null) {
            return this.getParent().getDocument();
        }
        return null;
    }

    public final PDFDocument getDocumentSafely() {
        PDFDocument pDFDocument = this.getDocument();
        if (pDFDocument == null) {
            throw new IllegalStateException("Parent PDFDocument is unavailable on " + this.getClass().getName());
        }
        return pDFDocument;
    }

    public void setDocument(PDFDocument pDFDocument) {
        this.document = pDFDocument;
    }

    public PDFObject getParent() {
        return this.parent;
    }

    public void setParent(PDFObject pDFObject) {
        this.parent = pDFObject;
    }

    public String getObjectID() {
        return this.getObjectNumber() + " " + this.getGeneration() + " obj\n";
    }

    public String referencePDF() {
        if (!this.hasObjectNumber()) {
            throw new IllegalArgumentException("Cannot reference this object. It doesn't have an object number");
        }
        String string = this.getObjectNumber() + " " + this.getGeneration() + " R";
        return string;
    }

    public PDFReference makeReference() {
        return new PDFReference(this);
    }

    public int output(OutputStream outputStream) throws IOException {
        byte[] byArray = this.toPDF();
        outputStream.write(byArray);
        return byArray.length;
    }

    public void outputInline(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        if (this.hasObjectNumber()) {
            stringBuilder.append(this.referencePDF());
        } else {
            PDFDocument.flushTextBuffer(stringBuilder, outputStream);
            this.output(outputStream);
        }
    }

    protected byte[] toPDF() {
        return PDFObject.encode(this.toPDFString());
    }

    protected String toPDFString() {
        throw new UnsupportedOperationException("Not implemented. Use output(OutputStream) instead.");
    }

    public static final byte[] encode(String string) {
        return PDFDocument.encode(string);
    }

    protected byte[] encodeText(String string) {
        if (this.getDocumentSafely().isEncryptionActive()) {
            byte[] byArray = PDFText.toUTF16(string);
            return PDFText.escapeByteArray(this.getDocument().getEncryption().encrypt(byArray, this));
        }
        return PDFObject.encode(PDFText.escapeText(string, false));
    }

    protected byte[] encodeString(String string) {
        return this.encodeText(string);
    }

    protected void encodeBinaryToHexString(byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(60);
        if (this.getDocumentSafely().isEncryptionActive()) {
            byArray = this.getDocument().getEncryption().encrypt(byArray, this);
        }
        String string = PDFText.toHex(byArray, false);
        byte[] byArray2 = string.getBytes("US-ASCII");
        outputStream.write(byArray2);
        outputStream.write(62);
    }

    protected void formatObject(Object object, OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        if (object == null) {
            stringBuilder.append("null");
        } else if (object instanceof PDFWritable) {
            ((PDFWritable)object).outputInline(outputStream, stringBuilder);
        } else if (object instanceof Number) {
            if (object instanceof Double || object instanceof Float) {
                stringBuilder.append(PDFNumber.doubleOut(((Number)object).doubleValue()));
            } else {
                stringBuilder.append(object.toString());
            }
        } else if (object instanceof Boolean) {
            stringBuilder.append(object.toString());
        } else if (object instanceof byte[]) {
            PDFDocument.flushTextBuffer(stringBuilder, outputStream);
            this.encodeBinaryToHexString((byte[])object, outputStream);
        } else {
            PDFDocument.flushTextBuffer(stringBuilder, outputStream);
            outputStream.write(this.encodeText(object.toString()));
        }
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        return this.equals(pDFObject);
    }
}

