/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;

public class PDFPages
extends PDFObject {
    protected List kids = new ArrayList();
    protected int count = 0;

    public PDFPages(int n) {
        this.setObjectNumber(n);
    }

    public void addPage(PDFPage pDFPage) {
        pDFPage.setParent(this);
        this.incrementCount();
    }

    public void notifyKidRegistered(PDFPage pDFPage) {
        int n = pDFPage.getPageIndex();
        if (n >= 0) {
            while (n > this.kids.size() - 1) {
                this.kids.add(null);
            }
            if (this.kids.get(n) != null) {
                throw new IllegalStateException("A page already exists at index " + n + " (zero-based).");
            }
            this.kids.set(n, pDFPage.referencePDF());
        } else {
            this.kids.add(pDFPage.referencePDF());
        }
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public String toPDFString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<< /Type /Pages\n/Count ").append(this.getCount()).append("\n/Kids [");
        for (int i = 0; i < this.kids.size(); ++i) {
            Object e = this.kids.get(i);
            if (e == null) {
                throw new IllegalStateException("Gap in the kids list!");
            }
            stringBuffer.append(e).append(" ");
        }
        stringBuffer.append("] >>");
        return stringBuffer.toString();
    }
}

