/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.util.AbstractPaintingState;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class PDFPaintingState
extends AbstractPaintingState {
    private static final long serialVersionUID = 5384726143906371279L;

    public boolean setPaint(Paint paint) {
        PDFData pDFData = this.getPDFData();
        Paint paint2 = pDFData.paint;
        if (paint2 == null) {
            if (paint != null) {
                pDFData.paint = paint;
                return true;
            }
        } else if (paint instanceof Color && paint2 instanceof Color) {
            if (!ColorUtil.isSameColor((Color)((Color)paint), (Color)((Color)paint2))) {
                pDFData.paint = paint;
                return true;
            }
        } else if (!paint2.equals(paint)) {
            pDFData.paint = paint;
            return true;
        }
        return false;
    }

    public boolean checkClip(Shape shape) {
        Shape shape2 = this.getPDFData().clip;
        return shape2 == null ? shape != null : !new Area(shape2).equals(new Area(shape));
    }

    public void setClip(Shape shape) {
        PDFData pDFData = this.getPDFData();
        Shape shape2 = pDFData.clip;
        if (shape2 != null) {
            Area area = new Area(shape2);
            area.intersect(new Area(shape));
            pDFData.clip = new GeneralPath(area);
        } else {
            pDFData.clip = shape;
        }
    }

    public boolean setCharacterSpacing(float f) {
        PDFData pDFData = this.getPDFData();
        if (f != pDFData.characterSpacing) {
            pDFData.characterSpacing = f;
            return true;
        }
        return false;
    }

    public float getCharacterSpacing() {
        return this.getPDFData().characterSpacing;
    }

    public int getStackLevel() {
        return this.getStateStack().size();
    }

    public PDFGState getGState() {
        PDFGState pDFGState = PDFGState.DEFAULT;
        PDFGState pDFGState2 = new PDFGState();
        pDFGState2.addValues(pDFGState);
        for (PDFData pDFData : this.getStateStack()) {
            PDFGState pDFGState3 = pDFData.gstate;
            if (pDFGState3 == null) continue;
            pDFGState2.addValues(pDFGState3);
        }
        if (this.getPDFData().gstate != null) {
            pDFGState2.addValues(this.getPDFData().gstate);
        }
        return pDFGState2;
    }

    protected AbstractPaintingState.AbstractData instantiateData() {
        return new PDFData();
    }

    protected AbstractPaintingState instantiate() {
        return new PDFPaintingState();
    }

    public void save() {
        AbstractPaintingState.AbstractData abstractData = this.getData();
        AbstractPaintingState.AbstractData abstractData2 = (AbstractPaintingState.AbstractData)abstractData.clone();
        abstractData.clearTransform();
        this.getStateStack().add(abstractData2);
    }

    private PDFData getPDFData() {
        return (PDFData)this.getData();
    }

    private class PDFData
    extends AbstractPaintingState.AbstractData {
        private static final long serialVersionUID = 3527950647293177764L;
        private Paint paint;
        private Paint backPaint;
        private Shape clip;
        private PDFGState gstate;
        private float characterSpacing;

        private PDFData() {
            super(PDFPaintingState.this);
            this.paint = null;
            this.backPaint = null;
            this.clip = null;
            this.gstate = null;
            this.characterSpacing = 0.0f;
        }

        public Object clone() {
            PDFData pDFData = (PDFData)super.clone();
            pDFData.paint = this.paint;
            pDFData.backPaint = this.paint;
            pDFData.clip = this.clip;
            pDFData.gstate = this.gstate;
            pDFData.characterSpacing = this.characterSpacing;
            return pDFData;
        }

        public String toString() {
            return super.toString() + ", paint=" + this.paint + ", backPaint=" + this.backPaint + ", clip=" + this.clip + ", gstate=" + this.gstate;
        }

        protected AbstractPaintingState.AbstractData instantiate() {
            return new PDFData();
        }
    }
}

