/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.pdf.Version;
import org.apache.fop.util.LanguageTags;

public class PDFRoot
extends PDFDictionary {
    public static final int PAGEMODE_USENONE = 0;
    public static final int PAGEMODE_USEOUTLINES = 1;
    public static final int PAGEMODE_USETHUMBS = 2;
    public static final int PAGEMODE_FULLSCREEN = 3;
    private static final PDFName[] PAGEMODE_NAMES = new PDFName[]{new PDFName("UseNone"), new PDFName("UseOutlines"), new PDFName("UseThumbs"), new PDFName("FullScreen")};

    public PDFRoot(int n, PDFPages pDFPages) {
        this.setObjectNumber(n);
        this.put("Type", new PDFName("Catalog"));
        this.setRootPages(pDFPages);
        this.setLanguage("x-unknown");
    }

    public int output(OutputStream outputStream) throws IOException {
        this.getDocument().getProfile().verifyTaggedPDF();
        return super.output(outputStream);
    }

    public void setPageMode(int n) {
        this.put("PageMode", PAGEMODE_NAMES[n]);
    }

    public int getPageMode() {
        PDFName pDFName = (PDFName)this.get("PageMode");
        if (pDFName != null) {
            for (int i = 0; i < PAGEMODE_NAMES.length; ++i) {
                if (!PAGEMODE_NAMES[i].equals(pDFName)) continue;
                return i;
            }
            throw new IllegalStateException("Unknown /PageMode encountered: " + pDFName);
        }
        return 0;
    }

    public void addPage(PDFPage pDFPage) {
        PDFPages pDFPages = this.getRootPages();
        pDFPages.addPage(pDFPage);
    }

    public void setRootPages(PDFPages pDFPages) {
        this.put("Pages", pDFPages.makeReference());
    }

    public PDFPages getRootPages() {
        PDFReference pDFReference = (PDFReference)this.get("Pages");
        return pDFReference != null ? (PDFPages)pDFReference.getObject() : null;
    }

    public void setPageLabels(PDFPageLabels pDFPageLabels) {
        this.put("PageLabels", pDFPageLabels.makeReference());
    }

    public PDFPageLabels getPageLabels() {
        PDFReference pDFReference = (PDFReference)this.get("PageLabels");
        return pDFReference != null ? (PDFPageLabels)pDFReference.getObject() : null;
    }

    public void setRootOutline(PDFOutline pDFOutline) {
        this.put("Outlines", pDFOutline.makeReference());
        PDFName pDFName = (PDFName)this.get("PageMode");
        if (pDFName == null) {
            this.setPageMode(1);
        }
    }

    public PDFOutline getRootOutline() {
        PDFReference pDFReference = (PDFReference)this.get("Outlines");
        return pDFReference != null ? (PDFOutline)pDFReference.getObject() : null;
    }

    public void setNames(PDFNames pDFNames) {
        this.put("Names", pDFNames.makeReference());
    }

    public PDFNames getNames() {
        PDFReference pDFReference = (PDFReference)this.get("Names");
        return pDFReference != null ? (PDFNames)pDFReference.getObject() : null;
    }

    public void setMetadata(PDFMetadata pDFMetadata) {
        if (this.getDocumentSafely().getPDFVersion().compareTo(Version.V1_4) >= 0) {
            this.put("Metadata", pDFMetadata.makeReference());
        }
    }

    public PDFMetadata getMetadata() {
        PDFReference pDFReference = (PDFReference)this.get("Metadata");
        return pDFReference != null ? (PDFMetadata)pDFReference.getObject() : null;
    }

    public PDFArray getOutputIntents() {
        return (PDFArray)this.get("OutputIntents");
    }

    public void addOutputIntent(PDFOutputIntent pDFOutputIntent) {
        if (this.getDocumentSafely().getPDFVersion().compareTo(Version.V1_4) >= 0) {
            PDFArray pDFArray = this.getOutputIntents();
            if (pDFArray == null) {
                pDFArray = new PDFArray(this);
                this.put("OutputIntents", pDFArray);
            }
            pDFArray.add(pDFOutputIntent);
        }
    }

    void setVersion(Version version) {
        this.put("Version", new PDFName(version.toString()));
    }

    public String getLanguage() {
        return (String)this.get("Lang");
    }

    public void setLanguage(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale must not be null");
        }
        this.setLanguage(LanguageTags.toLanguageTag(locale));
    }

    private void setLanguage(String string) {
        this.put("Lang", string);
    }

    public void setStructTreeRoot(PDFStructTreeRoot pDFStructTreeRoot) {
        if (pDFStructTreeRoot == null) {
            throw new NullPointerException("structTreeRoot must not be null");
        }
        this.put("StructTreeRoot", pDFStructTreeRoot);
    }

    public PDFStructTreeRoot getStructTreeRoot() {
        return (PDFStructTreeRoot)this.get("StructTreeRoot");
    }

    public void makeTagged() {
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("Marked", Boolean.TRUE);
        this.put("MarkInfo", pDFDictionary);
    }

    public PDFDictionary getMarkInfo() {
        return (PDFDictionary)this.get("MarkInfo");
    }
}

