/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.List;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;

public class PDFShading
extends PDFObject {
    protected String shadingName = null;
    protected int shadingType = 3;
    protected PDFDeviceColorSpace colorSpace = null;
    protected List background = null;
    protected List bBox = null;
    protected boolean antiAlias = false;
    protected List domain = null;
    protected List matrix = null;
    protected PDFFunction function = null;
    protected List coords = null;
    protected List extend = null;
    protected int bitsPerCoordinate = 0;
    protected int bitsPerFlag = 0;
    protected List decode = null;
    protected int bitsPerComponent = 0;
    protected int verticesPerRow = 0;

    public PDFShading(int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, List list3, List list4, PDFFunction pDFFunction) {
        this.shadingType = n;
        this.colorSpace = pDFDeviceColorSpace;
        this.background = list;
        this.bBox = list2;
        this.antiAlias = bl;
        this.domain = list3;
        this.matrix = list4;
        this.function = pDFFunction;
    }

    public PDFShading(int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, List list3, List list4, PDFFunction pDFFunction, List list5) {
        this.shadingType = n;
        this.colorSpace = pDFDeviceColorSpace;
        this.background = list;
        this.bBox = list2;
        this.antiAlias = bl;
        this.coords = list3;
        this.domain = list4;
        this.function = pDFFunction;
        this.extend = list5;
    }

    public PDFShading(int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, int n2, int n3, int n4, List list3, PDFFunction pDFFunction) {
        this.shadingType = n;
        this.colorSpace = pDFDeviceColorSpace;
        this.background = list;
        this.bBox = list2;
        this.antiAlias = bl;
        this.bitsPerCoordinate = n2;
        this.bitsPerComponent = n3;
        this.bitsPerFlag = n4;
        this.decode = list3;
        this.function = pDFFunction;
    }

    public PDFShading(int n, PDFDeviceColorSpace pDFDeviceColorSpace, List list, List list2, boolean bl, int n2, int n3, List list3, int n4, PDFFunction pDFFunction) {
        this.shadingType = n;
        this.colorSpace = pDFDeviceColorSpace;
        this.background = list;
        this.bBox = list2;
        this.antiAlias = bl;
        this.bitsPerCoordinate = n2;
        this.bitsPerComponent = n3;
        this.decode = list3;
        this.verticesPerRow = n4;
        this.function = pDFFunction;
    }

    public String getName() {
        return this.shadingName;
    }

    public void setName(String string) {
        if (string.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("Shading name must not contain any spaces");
        }
        this.shadingName = string;
    }

    public String toPDFString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("<<\n/ShadingType " + this.shadingType + " \n");
        if (this.colorSpace != null) {
            stringBuffer.append("/ColorSpace /" + this.colorSpace.getName() + " \n");
        }
        if (this.background != null) {
            stringBuffer.append("/Background [ ");
            n2 = this.background.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(PDFNumber.doubleOut((Double)this.background.get(n)) + " ");
            }
            stringBuffer.append("] \n");
        }
        if (this.bBox != null) {
            stringBuffer.append("/BBox [ ");
            n2 = this.bBox.size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(PDFNumber.doubleOut((Double)this.bBox.get(n)) + " ");
            }
            stringBuffer.append("] \n");
        }
        if (this.antiAlias) {
            stringBuffer.append("/AntiAlias " + this.antiAlias + " \n");
        }
        if (this.shadingType == 1) {
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n2 = this.domain.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.domain.get(n)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.matrix != null) {
                stringBuffer.append("/Matrix [ ");
                n2 = this.matrix.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.matrix.get(n)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(this.function.referencePDF() + " \n");
            }
        } else if (this.shadingType == 2 || this.shadingType == 3) {
            if (this.coords != null) {
                stringBuffer.append("/Coords [ ");
                n2 = this.coords.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.coords.get(n)) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.domain != null) {
                stringBuffer.append("/Domain [ ");
                n2 = this.domain.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(PDFNumber.doubleOut((Double)this.domain.get(n)) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Domain [ 0 1 ] \n");
            }
            if (this.extend != null) {
                stringBuffer.append("/Extend [ ");
                n2 = this.extend.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append((Boolean)this.extend.get(n) + " ");
                }
                stringBuffer.append("] \n");
            } else {
                stringBuffer.append("/Extend [ true true ] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(this.function.referencePDF() + " \n");
            }
        } else if (this.shadingType == 4 || this.shadingType == 6 || this.shadingType == 7) {
            if (this.bitsPerCoordinate > 0) {
                stringBuffer.append("/BitsPerCoordinate " + this.bitsPerCoordinate + " \n");
            } else {
                stringBuffer.append("/BitsPerCoordinate 1 \n");
            }
            if (this.bitsPerComponent > 0) {
                stringBuffer.append("/BitsPerComponent " + this.bitsPerComponent + " \n");
            } else {
                stringBuffer.append("/BitsPerComponent 1 \n");
            }
            if (this.bitsPerFlag > 0) {
                stringBuffer.append("/BitsPerFlag " + this.bitsPerFlag + " \n");
            } else {
                stringBuffer.append("/BitsPerFlag 2 \n");
            }
            if (this.decode != null) {
                stringBuffer.append("/Decode [ ");
                n2 = this.decode.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append((Boolean)this.decode.get(n) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(this.function.referencePDF() + " \n");
            }
        } else if (this.shadingType == 5) {
            if (this.bitsPerCoordinate > 0) {
                stringBuffer.append("/BitsPerCoordinate " + this.bitsPerCoordinate + " \n");
            } else {
                stringBuffer.append("/BitsPerCoordinate 1 \n");
            }
            if (this.bitsPerComponent > 0) {
                stringBuffer.append("/BitsPerComponent " + this.bitsPerComponent + " \n");
            } else {
                stringBuffer.append("/BitsPerComponent 1 \n");
            }
            if (this.decode != null) {
                stringBuffer.append("/Decode [ ");
                n2 = this.decode.size();
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append((Boolean)this.decode.get(n) + " ");
                }
                stringBuffer.append("] \n");
            }
            if (this.function != null) {
                stringBuffer.append("/Function ");
                stringBuffer.append(this.function.referencePDF() + " \n");
            }
            if (this.verticesPerRow > 0) {
                stringBuffer.append("/VerticesPerRow " + this.verticesPerRow + " \n");
            } else {
                stringBuffer.append("/VerticesPerRow 2 \n");
            }
        }
        stringBuffer.append(">>");
        return stringBuffer.toString();
    }

    protected boolean contentEquals(PDFObject pDFObject) {
        if (pDFObject == null) {
            return false;
        }
        if (pDFObject == this) {
            return true;
        }
        if (!(pDFObject instanceof PDFShading)) {
            return false;
        }
        PDFShading pDFShading = (PDFShading)pDFObject;
        if (this.shadingType != pDFShading.shadingType) {
            return false;
        }
        if (this.antiAlias != pDFShading.antiAlias) {
            return false;
        }
        if (this.bitsPerCoordinate != pDFShading.bitsPerCoordinate) {
            return false;
        }
        if (this.bitsPerFlag != pDFShading.bitsPerFlag) {
            return false;
        }
        if (this.bitsPerComponent != pDFShading.bitsPerComponent) {
            return false;
        }
        if (this.verticesPerRow != pDFShading.verticesPerRow) {
            return false;
        }
        if (this.colorSpace != null ? !this.colorSpace.equals(pDFShading.colorSpace) : pDFShading.colorSpace != null) {
            return false;
        }
        if (this.background != null ? !this.background.equals(pDFShading.background) : pDFShading.background != null) {
            return false;
        }
        if (this.bBox != null ? !this.bBox.equals(pDFShading.bBox) : pDFShading.bBox != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(pDFShading.domain) : pDFShading.domain != null) {
            return false;
        }
        if (this.matrix != null ? !this.matrix.equals(pDFShading.matrix) : pDFShading.matrix != null) {
            return false;
        }
        if (this.coords != null ? !this.coords.equals(pDFShading.coords) : pDFShading.coords != null) {
            return false;
        }
        if (this.extend != null ? !this.extend.equals(pDFShading.extend) : pDFShading.extend != null) {
            return false;
        }
        if (this.decode != null ? !this.decode.equals(pDFShading.decode) : pDFShading.decode != null) {
            return false;
        }
        return !(this.function != null ? !this.function.equals(pDFShading.function) : pDFShading.function != null);
    }
}

