/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.fop.pdf.PDFObject;

public class PDFText
extends PDFObject {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String text;

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    protected String toPDFString() {
        if (this.getText() == null) {
            throw new IllegalArgumentException("The text of this PDFText must not be empty");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("(");
        stringBuffer.append(PDFText.escapeText(this.getText()));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static final String escapeText(String string) {
        return PDFText.escapeText(string, false);
    }

    public static final String escapeText(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            int n;
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                bl3 = true;
            } else {
                n = string.length();
                for (int i = 0; i < n; ++i) {
                    if (string.charAt(i) < '\u0080') continue;
                    bl2 = true;
                    bl3 = true;
                    break;
                }
            }
            if (bl3) {
                byte[] byArray;
                try {
                    byArray = string.getBytes("UTF-16");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new CascadingRuntimeException("Incompatible VM", (Throwable)unsupportedEncodingException);
                }
                return PDFText.toHex(byArray);
            }
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            stringBuffer.append("(");
            n = string.length();
            if (bl2) {
                stringBuffer.append("\\376\\377");
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    int n2 = (c & 0xFF00) >>> 8;
                    int n3 = c & 0xFF;
                    stringBuffer.append("\\");
                    stringBuffer.append(Integer.toOctalString(n2));
                    stringBuffer.append("\\");
                    stringBuffer.append(Integer.toOctalString(n3));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c >= '\u0100') {
                        throw new IllegalStateException("Can only treat text in 8-bit ASCII/PDFEncoding");
                    }
                    PDFText.escapeStringChar(c, stringBuffer);
                }
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return "()";
    }

    public static final String toHex(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        if (bl) {
            stringBuffer.append("<");
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(DIGITS[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(DIGITS[byArray[i] & 0xF]);
        }
        if (bl) {
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    public static final String toHex(byte[] byArray) {
        return PDFText.toHex(byArray, true);
    }

    public static final byte[] toUTF16(String string) {
        try {
            return string.getBytes("UnicodeBig");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CascadingRuntimeException("Incompatible VM", (Throwable)unsupportedEncodingException);
        }
    }

    public static final String toUnicodeHex(char c) {
        byte[] byArray;
        StringBuffer stringBuffer = new StringBuffer(4);
        try {
            char[] cArray = new char[]{c};
            byArray = new String(cArray).getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CascadingRuntimeException("Incompatible VM", (Throwable)unsupportedEncodingException);
        }
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(DIGITS[byArray[i] >>> 4 & 0xF]);
            stringBuffer.append(DIGITS[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static final String escapeString(String string) {
        if (string == null || string.length() == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("(");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            PDFText.escapeStringChar(c, stringBuffer);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static final void escapeStringChar(char c, StringBuffer stringBuffer) {
        if (c > '\u007f') {
            stringBuffer.append("\\");
            stringBuffer.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '(': {
                    stringBuffer.append("\\(");
                    break;
                }
                case ')': {
                    stringBuffer.append("\\)");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }

    public static final byte[] escapeByteArray(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byteArrayOutputStream.write(40);
        block10: for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            switch (by) {
                case 10: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(110);
                    continue block10;
                }
                case 13: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(114);
                    continue block10;
                }
                case 9: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(116);
                    continue block10;
                }
                case 8: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(98);
                    continue block10;
                }
                case 12: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(102);
                    continue block10;
                }
                case 92: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(92);
                    continue block10;
                }
                case 40: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(40);
                    continue block10;
                }
                case 41: {
                    byteArrayOutputStream.write(92);
                    byteArrayOutputStream.write(41);
                    continue block10;
                }
                default: {
                    byteArrayOutputStream.write(by);
                }
            }
        }
        byteArrayOutputStream.write(41);
        return byteArrayOutputStream.toByteArray();
    }

    public static String toPDFString(CharSequence charSequence) {
        return PDFText.toPDFString(charSequence, '?');
    }

    public static String toPDFString(CharSequence charSequence, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c2 = charSequence.charAt(i);
            if (c2 > '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

