/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.pdf.CMapBuilder;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;

public class PDFToUnicodeCMap
extends PDFCMap {
    protected char[] unicodeCharMap;
    private boolean singleByte;

    public PDFToUnicodeCMap(char[] cArray, String string, PDFCIDSystemInfo pDFCIDSystemInfo, boolean bl) {
        super(string, pDFCIDSystemInfo);
        if (bl && cArray.length > 256) {
            throw new IllegalArgumentException("unicodeCharMap may not contain more than 256 characters for single-byte encodings");
        }
        this.unicodeCharMap = cArray;
        this.singleByte = bl;
    }

    protected CMapBuilder createCMapBuilder(Writer writer) {
        return new ToUnicodeCMapBuilder(writer);
    }

    class ToUnicodeCMapBuilder
    extends CMapBuilder {
        public ToUnicodeCMapBuilder(Writer writer) {
            super(writer, null);
        }

        public void writeCMap() throws IOException {
            this.writeCIDInit();
            this.writeCIDSystemInfo("Adobe", "UCS", 0);
            this.writeName("Adobe-Identity-UCS");
            this.writeType("2");
            this.writeCodeSpaceRange(PDFToUnicodeCMap.this.singleByte);
            this.writeBFEntries();
            this.writeWrapUp();
        }

        protected void writeBFEntries() throws IOException {
            if (PDFToUnicodeCMap.this.unicodeCharMap != null) {
                this.writeBFCharEntries(PDFToUnicodeCMap.this.unicodeCharMap);
                this.writeBFRangeEntries(PDFToUnicodeCMap.this.unicodeCharMap);
            }
        }

        protected void writeBFCharEntries(char[] cArray) throws IOException {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < cArray.length; ++n2) {
                if (this.partOfRange(cArray, n2)) continue;
                ++n3;
            }
            if (n3 < 1) {
                return;
            }
            n2 = n3;
            int n4 = 0;
            do {
                n = Math.min(n2, 100);
                this.writer.write(n + " beginbfchar\n");
                for (int i = 0; i < n; ++i) {
                    while (this.partOfRange(cArray, n4)) {
                        ++n4;
                    }
                    this.writer.write("<" + this.padCharIndex(n4) + "> ");
                    this.writer.write("<" + this.padHexString(Integer.toHexString(cArray[n4]), 4) + ">\n");
                    ++n4;
                }
                this.writer.write("endbfchar\n");
            } while ((n2 -= n) > 0);
        }

        private String padCharIndex(int n) {
            return this.padHexString(Integer.toHexString(n), PDFToUnicodeCMap.this.singleByte ? 2 : 4);
        }

        protected void writeBFRangeEntries(char[] cArray) throws IOException {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < cArray.length; ++n2) {
                if (!this.startOfRange(cArray, n2)) continue;
                ++n3;
            }
            if (n3 < 1) {
                return;
            }
            n2 = n3;
            int n4 = 0;
            do {
                n = Math.min(n2, 100);
                this.writer.write(n + " beginbfrange\n");
                for (int i = 0; i < n; ++i) {
                    while (!this.startOfRange(cArray, n4)) {
                        ++n4;
                    }
                    this.writer.write("<" + this.padCharIndex(n4) + "> ");
                    this.writer.write("<" + this.padCharIndex(this.endOfRange(cArray, n4)) + "> ");
                    this.writer.write("<" + this.padHexString(Integer.toHexString(cArray[n4]), 4) + ">\n");
                    ++n4;
                }
                this.writer.write("endbfrange\n");
            } while ((n2 -= n) > 0);
        }

        private int endOfRange(char[] cArray, int n) {
            int n2;
            for (n2 = n; n2 < cArray.length - 1 && this.sameRangeEntryAsNext(cArray, n2); ++n2) {
            }
            return n2;
        }

        private boolean partOfRange(char[] cArray, int n) {
            if (cArray.length < 2) {
                return false;
            }
            if (n == 0) {
                return this.sameRangeEntryAsNext(cArray, 0);
            }
            if (n == cArray.length - 1) {
                return this.sameRangeEntryAsNext(cArray, n - 1);
            }
            if (this.sameRangeEntryAsNext(cArray, n - 1)) {
                return true;
            }
            return this.sameRangeEntryAsNext(cArray, n);
        }

        private boolean sameRangeEntryAsNext(char[] cArray, int n) {
            if (cArray[n] + '\u0001' != cArray[n + 1]) {
                return false;
            }
            return n / 256 == (n + 1) / 256;
        }

        private boolean startOfRange(char[] cArray, int n) {
            if (!this.partOfRange(cArray, n)) {
                return false;
            }
            if (n == 0) {
                return true;
            }
            if (n == cArray.length - 1) {
                return false;
            }
            return !this.sameRangeEntryAsNext(cArray, n - 1);
        }

        private String padHexString(String string, int n) {
            int n2 = string.length();
            if (n2 >= n) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i <= n - n2; ++i) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
    }
}

